/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.lib;

import com.jxdinfo.hussar.formdesign.jgit.errors.IncorrectObjectTypeException;
import com.jxdinfo.hussar.formdesign.jgit.errors.MissingObjectException;
import com.jxdinfo.hussar.formdesign.jgit.lib.AnyObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectInserter;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectLoader;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectReader;
import java.io.IOException;

public abstract class ObjectDatabase {
    protected ObjectDatabase() {
    }

    public boolean exists() {
        return true;
    }

    public void create() throws IOException {
    }

    public abstract ObjectInserter newInserter();

    public abstract ObjectReader newReader();

    public abstract void close();

    public boolean has(AnyObjectId objectId) throws IOException {
        try (ObjectReader or = this.newReader();){
            boolean bl = or.has(objectId);
            return bl;
        }
    }

    public ObjectLoader open(AnyObjectId objectId) throws IOException {
        return this.open(objectId, -1);
    }

    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        try (ObjectReader or = this.newReader();){
            ObjectLoader objectLoader = or.open(objectId, typeHint);
            return objectLoader;
        }
    }

    public ObjectDatabase newCachedDatabase() {
        return this;
    }
}

