/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.internal.revwalk;

import com.jxdinfo.hussar.formdesign.jgit.lib.BitmapIndex;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevCommit;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevFlag;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevWalk;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.filter.RevFilter;

public class AddUnseenToBitmapFilter
extends RevFilter {
    private final BitmapIndex.BitmapBuilder seen;
    private final BitmapIndex.BitmapBuilder bitmap;

    public AddUnseenToBitmapFilter(BitmapIndex.BitmapBuilder seen, BitmapIndex.BitmapBuilder bitmap) {
        this.seen = seen;
        this.bitmap = bitmap;
    }

    @Override
    public final boolean include(RevWalk walker, RevCommit cmit) {
        if (!this.seen.contains(cmit) && !this.bitmap.contains(cmit)) {
            BitmapIndex.Bitmap visitedBitmap = this.bitmap.getBitmapIndex().getBitmap(cmit);
            if (visitedBitmap != null) {
                this.bitmap.or(visitedBitmap);
            } else {
                this.bitmap.addObject(cmit, 1);
                return true;
            }
        }
        for (RevCommit p : cmit.getParents()) {
            p.add(RevFlag.SEEN);
        }
        return false;
    }

    @Override
    public final RevFilter clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean requiresCommitBody() {
        return false;
    }
}

