/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.api;

import com.jxdinfo.hussar.formdesign.jgit.api.GitCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.GitAPIException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.JGitInternalException;
import com.jxdinfo.hussar.formdesign.jgit.errors.ConfigInvalidException;
import com.jxdinfo.hussar.formdesign.jgit.lib.Ref;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.lib.StoredConfig;
import com.jxdinfo.hussar.formdesign.jgit.submodule.SubmoduleWalk;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.filter.PathFilterGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SubmoduleSyncCommand
extends GitCommand<Map<String, String>> {
    private final Collection<String> paths = new ArrayList<String>();

    public SubmoduleSyncCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleSyncCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    protected String getHeadBranch(Repository subRepo) throws IOException {
        Ref head = subRepo.exactRef("HEAD");
        if (head != null && head.isSymbolic()) {
            return Repository.shortenRefName(head.getLeaf().getName());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, String> call() throws GitAPIException {
        this.checkCallable();
        try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
            if (!this.paths.isEmpty()) {
                generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            HashMap<String, String> synced = new HashMap<String, String>();
            StoredConfig config = this.repo.getConfig();
            while (generator.next()) {
                String remoteUrl = generator.getRemoteUrl();
                if (remoteUrl == null) continue;
                String path = generator.getPath();
                config.setString("submodule", path, "url", remoteUrl);
                synced.put(path, remoteUrl);
                Repository subRepo = generator.getRepository();
                Throwable throwable = null;
                try {
                    if (subRepo == null) continue;
                    StoredConfig subConfig = subRepo.getConfig();
                    String branch = this.getHeadBranch(subRepo);
                    String remote = null;
                    if (branch != null) {
                        remote = subConfig.getString("branch", branch, "remote");
                    }
                    if (remote == null) {
                        remote = "origin";
                    }
                    subConfig.setString("remote", remote, "url", remoteUrl);
                    subConfig.save();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (subRepo == null) continue;
                    if (throwable != null) {
                        try {
                            subRepo.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    subRepo.close();
                }
            }
            if (!synced.isEmpty()) {
                config.save();
            }
            HashMap<String, String> hashMap = synced;
            return hashMap;
        }
        catch (ConfigInvalidException | IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

