/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.api;

import com.jxdinfo.hussar.formdesign.jgit.api.GitCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.GitAPIException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.JGitInternalException;
import com.jxdinfo.hussar.formdesign.jgit.errors.ConfigInvalidException;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.submodule.SubmoduleStatus;
import com.jxdinfo.hussar.formdesign.jgit.submodule.SubmoduleStatusType;
import com.jxdinfo.hussar.formdesign.jgit.submodule.SubmoduleWalk;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.filter.PathFilterGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SubmoduleStatusCommand
extends GitCommand<Map<String, SubmoduleStatus>> {
    private final Collection<String> paths = new ArrayList<String>();

    public SubmoduleStatusCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleStatusCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, SubmoduleStatus> call() throws GitAPIException {
        this.checkCallable();
        try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
            if (!this.paths.isEmpty()) {
                generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            HashMap<String, SubmoduleStatus> statuses = new HashMap<String, SubmoduleStatus>();
            while (generator.next()) {
                SubmoduleStatus status = this.getStatus(generator);
                statuses.put(status.getPath(), status);
            }
            HashMap<String, SubmoduleStatus> hashMap = statuses;
            return hashMap;
        }
        catch (ConfigInvalidException | IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    private SubmoduleStatus getStatus(SubmoduleWalk generator) throws IOException, ConfigInvalidException {
        ObjectId id = generator.getObjectId();
        String path = generator.getPath();
        if (generator.getModulesPath() == null) {
            return new SubmoduleStatus(SubmoduleStatusType.MISSING, path, id);
        }
        if (generator.getConfigUrl() == null) {
            return new SubmoduleStatus(SubmoduleStatusType.UNINITIALIZED, path, id);
        }
        ObjectId headId = null;
        try (Repository subRepo = generator.getRepository();){
            if (subRepo == null) {
                SubmoduleStatus submoduleStatus = new SubmoduleStatus(SubmoduleStatusType.UNINITIALIZED, path, id);
                return submoduleStatus;
            }
            headId = subRepo.resolve("HEAD");
        }
        if (headId == null) {
            return new SubmoduleStatus(SubmoduleStatusType.UNINITIALIZED, path, id, headId);
        }
        if (!headId.equals(id)) {
            return new SubmoduleStatus(SubmoduleStatusType.REV_CHECKED_OUT, path, id, headId);
        }
        return new SubmoduleStatus(SubmoduleStatusType.INITIALIZED, path, id, headId);
    }
}

