/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.merge;

import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCache;
import com.jxdinfo.hussar.formdesign.jgit.errors.IncorrectObjectTypeException;
import com.jxdinfo.hussar.formdesign.jgit.errors.NoMergeBaseException;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.lib.CommitBuilder;
import com.jxdinfo.hussar.formdesign.jgit.lib.Config;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectInserter;
import com.jxdinfo.hussar.formdesign.jgit.lib.PersonIdent;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.merge.ResolveMerger;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevCommit;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.filter.RevFilter;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.AbstractTreeIterator;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.EmptyTreeIterator;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.WorkingTreeIterator;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class RecursiveMerger
extends ResolveMerger {
    public final int MAX_BASES = 200;

    protected RecursiveMerger(Repository local, boolean inCore) {
        super(local, inCore);
    }

    protected RecursiveMerger(Repository local) {
        this(local, false);
    }

    protected RecursiveMerger(ObjectInserter inserter, Config config) {
        super(inserter, config);
    }

    @Override
    protected RevCommit getBaseCommit(RevCommit a, RevCommit b) throws IncorrectObjectTypeException, IOException {
        return this.getBaseCommit(a, b, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RevCommit getBaseCommit(RevCommit a, RevCommit b, int callDepth) throws IOException {
        RevCommit c;
        ArrayList<RevCommit> baseCommits = new ArrayList<RevCommit>();
        this.walk.reset();
        this.walk.setRevFilter(RevFilter.MERGE_BASE);
        this.walk.markStart(a);
        this.walk.markStart(b);
        while ((c = this.walk.next()) != null) {
            baseCommits.add(c);
        }
        if (baseCommits.isEmpty()) {
            return null;
        }
        if (baseCommits.size() == 1) {
            return (RevCommit)baseCommits.get(0);
        }
        if (baseCommits.size() >= 200) {
            throw new NoMergeBaseException(NoMergeBaseException.MergeBaseFailureReason.TOO_MANY_MERGE_BASES, MessageFormat.format(JGitText.get().mergeRecursiveTooManyMergeBasesFor, 200, a.name(), b.name(), baseCommits.size()));
        }
        RevCommit currentBase = (RevCommit)baseCommits.get(0);
        DirCache oldDircache = this.dircache;
        boolean oldIncore = this.inCore;
        WorkingTreeIterator oldWTreeIt = this.workingTreeIterator;
        this.workingTreeIterator = null;
        try {
            this.dircache = DirCache.read(this.reader, currentBase.getTree());
            this.inCore = true;
            ArrayList<RevCommit> parents = new ArrayList<RevCommit>();
            parents.add(currentBase);
            for (int commitIdx = 1; commitIdx < baseCommits.size(); ++commitIdx) {
                AbstractTreeIterator bcTree;
                RevCommit nextBase = (RevCommit)baseCommits.get(commitIdx);
                if (commitIdx >= 200) {
                    throw new NoMergeBaseException(NoMergeBaseException.MergeBaseFailureReason.TOO_MANY_MERGE_BASES, MessageFormat.format(JGitText.get().mergeRecursiveTooManyMergeBasesFor, 200, a.name(), b.name(), baseCommits.size()));
                }
                parents.add(nextBase);
                RevCommit bc = this.getBaseCommit(currentBase, nextBase, callDepth + 1);
                AbstractTreeIterator abstractTreeIterator = bcTree = bc == null ? new EmptyTreeIterator() : this.openTree(bc.getTree());
                if (!this.mergeTrees(bcTree, currentBase.getTree(), nextBase.getTree(), true)) {
                    throw new NoMergeBaseException(NoMergeBaseException.MergeBaseFailureReason.CONFLICTS_DURING_MERGE_BASE_CALCULATION, MessageFormat.format(JGitText.get().mergeRecursiveConflictsWhenMergingCommonAncestors, currentBase.getName(), nextBase.getName()));
                }
                currentBase = this.createCommitForTree(this.resultTree, parents);
            }
        }
        finally {
            this.inCore = oldIncore;
            this.dircache = oldDircache;
            this.workingTreeIterator = oldWTreeIt;
            this.toBeCheckedOut.clear();
            this.toBeDeleted.clear();
            this.modifiedFiles.clear();
            this.unmergedPaths.clear();
            this.mergeResults.clear();
            this.failingPaths.clear();
        }
        return currentBase;
    }

    private RevCommit createCommitForTree(ObjectId tree, List<RevCommit> parents) throws IOException {
        CommitBuilder c = new CommitBuilder();
        c.setTreeId(tree);
        c.setParentIds(parents);
        c.setAuthor(RecursiveMerger.mockAuthor(parents));
        c.setCommitter(c.getAuthor());
        return RevCommit.parse(this.walk, c.build());
    }

    private static PersonIdent mockAuthor(List<RevCommit> parents) {
        String name = RecursiveMerger.class.getSimpleName();
        int time = 0;
        for (RevCommit p : parents) {
            time = Math.max(time, p.getCommitTime());
        }
        return new PersonIdent(name, name + "@JGit", new Date((long)(time + 1) * 1000L), TimeZone.getTimeZone("GMT+0000"));
    }
}

