/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.internal.storage.file;

import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.FileSnapshot;
import com.jxdinfo.hussar.formdesign.jgit.lib.AnyObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

class PackFileSnapshot
extends FileSnapshot {
    private static final ObjectId MISSING_CHECKSUM = ObjectId.zeroId();
    private AnyObjectId checksum = MISSING_CHECKSUM;
    private boolean wasChecksumChanged;

    public static PackFileSnapshot save(File path) {
        return new PackFileSnapshot(path);
    }

    PackFileSnapshot(File packFile) {
        super(packFile);
    }

    void setChecksum(AnyObjectId checksum) {
        this.checksum = checksum;
    }

    @Override
    public boolean isModified(File packFile) {
        if (!super.isModified(packFile)) {
            return false;
        }
        if (this.wasSizeChanged() || this.wasFileKeyChanged() || !this.wasLastModifiedRacilyClean()) {
            return true;
        }
        return this.isChecksumChanged(packFile);
    }

    boolean isChecksumChanged(File packFile) {
        this.wasChecksumChanged = this.checksum != MISSING_CHECKSUM && !this.checksum.equals(this.readChecksum(packFile));
        return this.wasChecksumChanged;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AnyObjectId readChecksum(File packFile) {
        try (RandomAccessFile fd = new RandomAccessFile(packFile, "r");){
            fd.seek(fd.length() - 20L);
            byte[] buf = new byte[20];
            fd.readFully(buf, 0, 20);
            ObjectId objectId = ObjectId.fromRaw(buf);
            return objectId;
        }
        catch (IOException e) {
            return MISSING_CHECKSUM;
        }
    }

    boolean wasChecksumChanged() {
        return this.wasChecksumChanged;
    }

    @Override
    public String toString() {
        return "PackFileSnapshot [checksum=" + this.checksum + ", " + super.toString() + "]";
    }
}

