/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.internal.revwalk;

import com.jxdinfo.hussar.formdesign.jgit.errors.IncorrectObjectTypeException;
import com.jxdinfo.hussar.formdesign.jgit.errors.MissingObjectException;
import com.jxdinfo.hussar.formdesign.jgit.lib.BitmapIndex;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.ReachabilityChecker;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevCommit;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevFlag;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevSort;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevWalk;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.filter.RevFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;

public class BitmappedReachabilityChecker
implements ReachabilityChecker {
    private final RevWalk walk;

    public BitmappedReachabilityChecker(RevWalk walk) throws IOException {
        this.walk = walk;
        if (walk.getObjectReader().getBitmapIndex() == null) {
            throw new AssertionError((Object)"Trying to use bitmapped reachability check on a repository without bitmaps");
        }
    }

    @Override
    public Optional<RevCommit> areAllReachable(Collection<RevCommit> targets, Stream<RevCommit> starters) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ArrayList<RevCommit> remainingTargets = new ArrayList<RevCommit>(targets);
        this.walk.reset();
        this.walk.sort(RevSort.TOPO);
        BitmapIndex repoBitmaps = this.walk.getObjectReader().getBitmapIndex();
        ReachedFilter reachedFilter = new ReachedFilter(repoBitmaps);
        this.walk.setRevFilter(reachedFilter);
        Iterator startersIter = starters.iterator();
        while (startersIter.hasNext()) {
            this.walk.markStart((RevCommit)startersIter.next());
            while (this.walk.next() != null) {
                remainingTargets.removeIf(reachedFilter::isReachable);
                if (!remainingTargets.isEmpty()) continue;
                return Optional.empty();
            }
            this.walk.reset();
        }
        return Optional.of(remainingTargets.get(0));
    }

    private static class ReachedFilter
    extends RevFilter {
        private final BitmapIndex repoBitmaps;
        private final BitmapIndex.BitmapBuilder reached;

        public ReachedFilter(BitmapIndex repoBitmaps) {
            this.repoBitmaps = repoBitmaps;
            this.reached = repoBitmaps.newBitmapBuilder();
        }

        @Override
        public final boolean include(RevWalk walker, RevCommit cmit) {
            if (this.reached.contains(cmit)) {
                ReachedFilter.dontFollow(cmit);
                return false;
            }
            BitmapIndex.Bitmap commitBitmap = this.repoBitmaps.getBitmap(cmit);
            if (commitBitmap != null) {
                this.reached.or(commitBitmap);
                ReachedFilter.dontFollow(cmit);
                return true;
            }
            this.reached.addObject(cmit, 1);
            return true;
        }

        private static final void dontFollow(RevCommit cmit) {
            for (RevCommit p : cmit.getParents()) {
                p.add(RevFlag.SEEN);
            }
        }

        @Override
        public final RevFilter clone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean requiresCommitBody() {
            return false;
        }

        boolean isReachable(RevCommit commit) {
            return this.reached.contains(commit);
        }
    }
}

