/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.transport;

import com.jxdinfo.hussar.formdesign.jgit.errors.NotSupportedException;
import com.jxdinfo.hussar.formdesign.jgit.errors.TransportException;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.transport.BundleFetchConnection;
import com.jxdinfo.hussar.formdesign.jgit.transport.FetchConnection;
import com.jxdinfo.hussar.formdesign.jgit.transport.PushConnection;
import com.jxdinfo.hussar.formdesign.jgit.transport.Transport;
import com.jxdinfo.hussar.formdesign.jgit.transport.TransportBundle;
import com.jxdinfo.hussar.formdesign.jgit.transport.URIish;
import java.io.IOException;
import java.io.InputStream;

public class TransportBundleStream
extends Transport
implements TransportBundle {
    private InputStream src;

    public TransportBundleStream(Repository db, URIish uri, InputStream in) {
        super(db, uri);
        this.src = in;
    }

    @Override
    public FetchConnection openFetch() throws TransportException {
        if (this.src == null) {
            throw new TransportException(this.uri, JGitText.get().onlyOneFetchSupported);
        }
        try {
            BundleFetchConnection bundleFetchConnection = new BundleFetchConnection(this, this.src);
            return bundleFetchConnection;
        }
        finally {
            this.src = null;
        }
    }

    @Override
    public PushConnection openPush() throws NotSupportedException {
        throw new NotSupportedException(JGitText.get().pushIsNotSupportedForBundleTransport);
    }

    @Override
    public void close() {
        if (this.src != null) {
            try {
                this.src.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.src = null;
            }
        }
    }
}

