/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.transport;

import com.jxdinfo.hussar.formdesign.jgit.errors.TransportException;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.transport.BasePackFetchConnection;
import com.jxdinfo.hussar.formdesign.jgit.transport.PackTransport;
import com.jxdinfo.hussar.formdesign.jgit.transport.UploadPack;
import com.jxdinfo.hussar.formdesign.jgit.transport.resolver.ServiceNotAuthorizedException;
import com.jxdinfo.hussar.formdesign.jgit.transport.resolver.ServiceNotEnabledException;
import com.jxdinfo.hussar.formdesign.jgit.transport.resolver.UploadPackFactory;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

class InternalFetchConnection<C>
extends BasePackFetchConnection {
    private Thread worker;

    public InternalFetchConnection(PackTransport transport, final UploadPackFactory<C> uploadPackFactory, final C req, final Repository remote) throws TransportException {
        super(transport);
        PipedOutputStream out_w;
        PipedInputStream out_r;
        PipedOutputStream in_w;
        PipedInputStream in_r;
        try {
            in_r = new PipedInputStream();
            in_w = new PipedOutputStream(in_r);
            out_r = new PipedInputStream(){
                {
                    this.buffer = new byte[2952];
                }
            };
            out_w = new PipedOutputStream(out_r);
        }
        catch (IOException err) {
            remote.close();
            throw new TransportException(this.uri, JGitText.get().cannotConnectPipes, err);
        }
        this.worker = new Thread("JGit-Upload-Pack"){

            @Override
            public void run() {
                try {
                    UploadPack rp = uploadPackFactory.create(req, remote);
                    rp.upload(out_r, in_w, null);
                }
                catch (ServiceNotAuthorizedException | ServiceNotEnabledException rp) {
                }
                catch (IOException | RuntimeException err) {
                    err.printStackTrace();
                }
                finally {
                    try {
                        out_r.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        in_w.close();
                    }
                    catch (IOException iOException) {}
                    remote.close();
                }
            }
        };
        this.worker.start();
        this.init(in_r, out_w);
        this.readAdvertisedRefs();
    }

    @Override
    public void close() {
        super.close();
        try {
            if (this.worker != null) {
                this.worker.join();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.worker = null;
        }
    }
}

