/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.transport;

import com.jxdinfo.hussar.formdesign.jgit.transport.AdvertiseRefsHook;
import com.jxdinfo.hussar.formdesign.jgit.transport.ReceivePack;
import com.jxdinfo.hussar.formdesign.jgit.transport.ServiceMayNotContinueException;
import com.jxdinfo.hussar.formdesign.jgit.transport.UploadPack;
import java.util.List;

public class AdvertiseRefsHookChain
implements AdvertiseRefsHook {
    private final AdvertiseRefsHook[] hooks;
    private final int count;

    public static AdvertiseRefsHook newChain(List<? extends AdvertiseRefsHook> hooks) {
        AdvertiseRefsHook[] newHooks = new AdvertiseRefsHook[hooks.size()];
        int i = 0;
        for (AdvertiseRefsHook advertiseRefsHook : hooks) {
            if (advertiseRefsHook == AdvertiseRefsHook.DEFAULT) continue;
            newHooks[i++] = advertiseRefsHook;
        }
        switch (i) {
            case 0: {
                return AdvertiseRefsHook.DEFAULT;
            }
            case 1: {
                return newHooks[0];
            }
        }
        return new AdvertiseRefsHookChain(newHooks, i);
    }

    @Override
    public void advertiseRefs(ReceivePack rp) throws ServiceMayNotContinueException {
        for (int i = 0; i < this.count; ++i) {
            this.hooks[i].advertiseRefs(rp);
        }
    }

    @Override
    public void advertiseRefs(UploadPack rp) throws ServiceMayNotContinueException {
        for (int i = 0; i < this.count; ++i) {
            this.hooks[i].advertiseRefs(rp);
        }
    }

    private AdvertiseRefsHookChain(AdvertiseRefsHook[] hooks, int count) {
        this.hooks = hooks;
        this.count = count;
    }
}

