/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.api;

import com.jxdinfo.hussar.formdesign.jgit.api.GitCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.SubmoduleDeinitResult;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.GitAPIException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.InvalidConfigurationException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.JGitInternalException;
import com.jxdinfo.hussar.formdesign.jgit.errors.ConfigInvalidException;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.lib.StoredConfig;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevWalk;
import com.jxdinfo.hussar.formdesign.jgit.submodule.SubmoduleWalk;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.filter.PathFilter;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.filter.PathFilterGroup;
import com.jxdinfo.hussar.formdesign.jgit.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class SubmoduleDeinitCommand
extends GitCommand<Collection<SubmoduleDeinitResult>> {
    private final Collection<String> paths = new ArrayList<String>();
    private boolean force;

    public SubmoduleDeinitCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Collection<SubmoduleDeinitResult> call() throws GitAPIException {
        this.checkCallable();
        try {
            if (this.paths.isEmpty()) {
                return Collections.emptyList();
            }
            for (String path : this.paths) {
                if (this.submoduleExists(path)) continue;
                throw new NoSuchSubmoduleException(path);
            }
            ArrayList<SubmoduleDeinitResult> results = new ArrayList<SubmoduleDeinitResult>(this.paths.size());
            try (RevWalk revWalk = new RevWalk(this.repo);
                 SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
                generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
                StoredConfig config = this.repo.getConfig();
                while (generator.next()) {
                    String path = generator.getPath();
                    String name = generator.getModuleName();
                    SubmoduleDeinitStatus status = this.checkDirty(revWalk, path);
                    switch (status) {
                        case SUCCESS: {
                            this.deinit(path);
                            break;
                        }
                        case ALREADY_DEINITIALIZED: {
                            break;
                        }
                        case DIRTY: {
                            if (!this.force) break;
                            this.deinit(path);
                            status = SubmoduleDeinitStatus.FORCED;
                            break;
                        }
                        default: {
                            throw new JGitInternalException(MessageFormat.format(JGitText.get().unexpectedSubmoduleStatus, new Object[]{status}));
                        }
                    }
                    config.unsetSection("submodule", name);
                    results.add(new SubmoduleDeinitResult(path, status));
                }
            }
            return results;
        }
        catch (ConfigInvalidException e) {
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    private void deinit(String path) throws IOException {
        File dir = new File(this.repo.getWorkTree(), path);
        if (!dir.isDirectory()) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().expectedDirectoryNotSubmodule, path));
        }
        File[] ls = dir.listFiles();
        if (ls != null) {
            for (File f : ls) {
                FileUtils.delete(f, 1);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private SubmoduleDeinitStatus checkDirty(RevWalk revWalk, String path) throws GitAPIException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean submoduleExists(String path) throws IOException {
        PathFilter filter = PathFilter.create(path);
        try (SubmoduleWalk w = SubmoduleWalk.forIndex(this.repo);){
            boolean bl = w.setFilter(filter).next();
            return bl;
        }
    }

    public SubmoduleDeinitCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    public SubmoduleDeinitCommand setForce(boolean force) {
        this.force = force;
        return this;
    }

    public static enum SubmoduleDeinitStatus {
        ALREADY_DEINITIALIZED,
        SUCCESS,
        FORCED,
        DIRTY;

    }

    public static class NoSuchSubmoduleException
    extends GitAPIException {
        private static final long serialVersionUID = 1L;

        public NoSuchSubmoduleException(String path) {
            super(MessageFormat.format(JGitText.get().noSuchSubmodule, path));
        }
    }
}

