/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.api;

import com.jxdinfo.hussar.formdesign.jgit.api.GitCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.GitAPIException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.JGitInternalException;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.lib.StoredConfig;
import com.jxdinfo.hussar.formdesign.jgit.transport.RefSpec;
import com.jxdinfo.hussar.formdesign.jgit.transport.RemoteConfig;
import com.jxdinfo.hussar.formdesign.jgit.transport.URIish;
import java.io.IOException;
import java.net.URISyntaxException;

public class RemoteAddCommand
extends GitCommand<RemoteConfig> {
    private String name;
    private URIish uri;

    protected RemoteAddCommand(Repository repo) {
        super(repo);
    }

    public RemoteAddCommand setName(String name) {
        this.name = name;
        return this;
    }

    public RemoteAddCommand setUri(URIish uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public RemoteConfig call() throws GitAPIException {
        this.checkCallable();
        try {
            StoredConfig config = this.repo.getConfig();
            RemoteConfig remote = new RemoteConfig(config, this.name);
            RefSpec refSpec = new RefSpec();
            refSpec = refSpec.setForceUpdate(true);
            refSpec = refSpec.setSourceDestination("refs/heads/*", "refs/remotes/" + this.name + "/*");
            remote.addFetchRefSpec(refSpec);
            remote.addURI(this.uri);
            remote.update(config);
            config.save();
            return remote;
        }
        catch (IOException | URISyntaxException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

