/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.api;

import com.jxdinfo.hussar.formdesign.jgit.api.GitCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.FilterFailedException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.GitAPIException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.JGitInternalException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.NoFilepatternException;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCache;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheBuildIterator;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheBuilder;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheEntry;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheIterator;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.lib.FileMode;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectInserter;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.FileTreeIterator;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.NameConflictTreeWalk;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.TreeWalk;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.WorkingTreeIterator;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.filter.PathFilterGroup;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedList;

public class AddCommand
extends GitCommand<DirCache> {
    private Collection<String> filepatterns = new LinkedList<String>();
    private WorkingTreeIterator workingTreeIterator;
    private boolean update = false;

    public AddCommand(Repository repo) {
        super(repo);
    }

    public AddCommand addFilepattern(String filepattern) {
        this.checkCallable();
        this.filepatterns.add(filepattern);
        return this;
    }

    public AddCommand setWorkingTreeIterator(WorkingTreeIterator f) {
        this.workingTreeIterator = f;
        return this;
    }

    @Override
    public DirCache call() throws GitAPIException, NoFilepatternException {
        if (this.filepatterns.isEmpty()) {
            throw new NoFilepatternException(JGitText.get().atLeastOnePatternIsRequired);
        }
        this.checkCallable();
        DirCache dc = null;
        boolean addAll = this.filepatterns.contains(".");
        try (ObjectInserter inserter = this.repo.newObjectInserter();
             NameConflictTreeWalk tw = new NameConflictTreeWalk(this.repo);){
            tw.setOperationType(TreeWalk.OperationType.CHECKIN_OP);
            dc = this.repo.lockDirCache();
            DirCacheBuilder builder = dc.builder();
            tw.addTree(new DirCacheBuildIterator(builder));
            if (this.workingTreeIterator == null) {
                this.workingTreeIterator = new FileTreeIterator(this.repo);
            }
            this.workingTreeIterator.setDirCacheIterator(tw, 0);
            tw.addTree(this.workingTreeIterator);
            if (!addAll) {
                tw.setFilter(PathFilterGroup.createFromStrings(this.filepatterns));
            }
            byte[] lastAdded = null;
            while (tw.next()) {
                DirCacheEntry entry;
                DirCacheIterator c = tw.getTree(0, DirCacheIterator.class);
                WorkingTreeIterator f = tw.getTree(1, WorkingTreeIterator.class);
                if (c == null && f != null && f.isEntryIgnored() || c == null && this.update) continue;
                DirCacheEntry dirCacheEntry = entry = c != null ? c.getDirCacheEntry() : null;
                if (entry != null && entry.getStage() > 0 && lastAdded != null && lastAdded.length == tw.getPathLength() && tw.isPathPrefix(lastAdded, lastAdded.length) == 0) continue;
                if (tw.isSubtree() && !tw.isDirectoryFileConflict()) {
                    tw.enterSubtree();
                    continue;
                }
                if (f == null) {
                    if (entry == null || this.update && FileMode.GITLINK != entry.getFileMode()) continue;
                    builder.add(entry);
                    continue;
                }
                if (entry != null && entry.isAssumeValid()) {
                    builder.add(entry);
                    continue;
                }
                if (f.getEntryRawMode() == 16384 && f.getIndexFileMode(c) != FileMode.GITLINK || f.getEntryRawMode() == 57344 && f.getIndexFileMode(c) == FileMode.TREE) {
                    tw.enterSubtree();
                    continue;
                }
                byte[] path = tw.getRawPath();
                if (entry == null || entry.getStage() > 0) {
                    entry = new DirCacheEntry(path);
                }
                FileMode mode = f.getIndexFileMode(c);
                entry.setFileMode(mode);
                if (FileMode.GITLINK != mode) {
                    entry.setLength(f.getEntryLength());
                    entry.setLastModified(f.getEntryLastModifiedInstant());
                    long len = f.getEntryContentLength();
                    try (InputStream in = f.openEntryStream();){
                        ObjectId id = inserter.insert(3, len, in);
                        entry.setObjectId(id);
                    }
                } else {
                    entry.setLength(0);
                    entry.setLastModified(Instant.ofEpochSecond(0L));
                    entry.setObjectId(f.getEntryObjectId());
                }
                builder.add(entry);
                lastAdded = path;
            }
            inserter.flush();
            builder.commit();
            this.setCallable(false);
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof FilterFailedException) {
                throw (FilterFailedException)cause;
            }
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfAddCommand, e);
        }
        finally {
            if (dc != null) {
                dc.unlock();
            }
        }
        return dc;
    }

    public AddCommand setUpdate(boolean update) {
        this.update = update;
        return this;
    }

    public boolean isUpdate() {
        return this.update;
    }
}

