/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.transport;

import com.jxdinfo.hussar.formdesign.jgit.annotations.NonNull;
import com.jxdinfo.hussar.formdesign.jgit.errors.InvalidObjectIdException;
import com.jxdinfo.hussar.formdesign.jgit.errors.NoRemoteRepositoryException;
import com.jxdinfo.hussar.formdesign.jgit.errors.PackProtocolException;
import com.jxdinfo.hussar.formdesign.jgit.errors.RemoteRepositoryException;
import com.jxdinfo.hussar.formdesign.jgit.errors.TransportException;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectIdRef;
import com.jxdinfo.hussar.formdesign.jgit.lib.Ref;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.lib.SymbolicRef;
import com.jxdinfo.hussar.formdesign.jgit.transport.BaseConnection;
import com.jxdinfo.hussar.formdesign.jgit.transport.PackTransport;
import com.jxdinfo.hussar.formdesign.jgit.transport.PacketLineIn;
import com.jxdinfo.hussar.formdesign.jgit.transport.PacketLineOut;
import com.jxdinfo.hussar.formdesign.jgit.transport.RefSpec;
import com.jxdinfo.hussar.formdesign.jgit.transport.TransferConfig;
import com.jxdinfo.hussar.formdesign.jgit.transport.Transport;
import com.jxdinfo.hussar.formdesign.jgit.transport.URIish;
import com.jxdinfo.hussar.formdesign.jgit.transport.UserAgent;
import com.jxdinfo.hussar.formdesign.jgit.util.StringUtils;
import com.jxdinfo.hussar.formdesign.jgit.util.io.InterruptTimer;
import com.jxdinfo.hussar.formdesign.jgit.util.io.TimeoutInputStream;
import com.jxdinfo.hussar.formdesign.jgit.util.io.TimeoutOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

abstract class BasePackConnection
extends BaseConnection {
    protected static final String CAPABILITY_SYMREF_PREFIX = "symref=";
    protected final Repository local;
    protected final URIish uri;
    protected final Transport transport;
    protected TimeoutInputStream timeoutIn;
    protected TimeoutOutputStream timeoutOut;
    private InterruptTimer myTimer;
    protected InputStream in;
    protected OutputStream out;
    protected PacketLineIn pckIn;
    protected PacketLineOut pckOut;
    protected boolean outNeedsEnd;
    protected boolean statelessRPC;
    private final Map<String, String> remoteCapabilities = new HashMap<String, String>();
    protected final Set<ObjectId> additionalHaves = new HashSet<ObjectId>();
    private TransferConfig.ProtocolVersion protocol = TransferConfig.ProtocolVersion.V0;

    BasePackConnection(PackTransport packTransport) {
        this.transport = (Transport)((Object)packTransport);
        this.local = this.transport.local;
        this.uri = this.transport.uri;
    }

    TransferConfig.ProtocolVersion getProtocolVersion() {
        return this.protocol;
    }

    void setProtocolVersion(@NonNull TransferConfig.ProtocolVersion protocol) {
        this.protocol = protocol;
    }

    protected final void init(InputStream myIn, OutputStream myOut) {
        int timeout = this.transport.getTimeout();
        if (timeout > 0) {
            Thread caller = Thread.currentThread();
            if (this.myTimer == null) {
                this.myTimer = new InterruptTimer(caller.getName() + "-Timer");
            }
            this.timeoutIn = new TimeoutInputStream(myIn, this.myTimer);
            this.timeoutOut = new TimeoutOutputStream(myOut, this.myTimer);
            this.timeoutIn.setTimeout(timeout * 1000);
            this.timeoutOut.setTimeout(timeout * 1000);
            myIn = this.timeoutIn;
            myOut = this.timeoutOut;
        }
        this.in = myIn;
        this.out = myOut;
        this.pckIn = new PacketLineIn(this.in);
        this.pckOut = new PacketLineOut(this.out);
        this.outNeedsEnd = true;
    }

    protected boolean readAdvertisedRefs() throws TransportException {
        try {
            return this.readAdvertisedRefsImpl();
        }
        catch (TransportException err) {
            this.close();
            throw err;
        }
        catch (IOException | RuntimeException err) {
            this.close();
            throw new TransportException(err.getMessage(), err);
        }
    }

    private String readLine() throws IOException {
        String line = this.pckIn.readString();
        if (PacketLineIn.isEnd(line)) {
            return null;
        }
        if (line.startsWith("ERR ")) {
            throw new RemoteRepositoryException(this.uri, line.substring(4));
        }
        return line;
    }

    private boolean readAdvertisedRefsImpl() throws IOException {
        LinkedHashMap<String, Ref> avail = new LinkedHashMap<String, Ref>();
        LinkedHashMap<String, String> symRefs = new LinkedHashMap<String, String>();
        boolean first = true;
        while (true) {
            String line;
            if (first) {
                boolean isV1 = false;
                try {
                    line = this.readLine();
                }
                catch (EOFException e) {
                    throw this.noRepository(e);
                }
                if (line != null && "version 1".equals(line)) {
                    this.setProtocolVersion(TransferConfig.ProtocolVersion.V0);
                    isV1 = true;
                    line = this.readLine();
                }
                if (line == null) break;
                int nul = line.indexOf(0);
                if (nul >= 0) {
                    for (String capability : line.substring(nul + 1).split(" ")) {
                        if (capability.startsWith(CAPABILITY_SYMREF_PREFIX)) {
                            String[] parts = capability.substring(CAPABILITY_SYMREF_PREFIX.length()).split(":", 2);
                            if (parts.length != 2) continue;
                            symRefs.put(parts[0], parts[1]);
                            continue;
                        }
                        this.addCapability(capability);
                    }
                    line = line.substring(0, nul);
                    this.setProtocolVersion(TransferConfig.ProtocolVersion.V0);
                } else {
                    if (!isV1 && "version 2".equals(line)) {
                        this.setProtocolVersion(TransferConfig.ProtocolVersion.V2);
                        this.readCapabilitiesV2();
                        return false;
                    }
                    this.setProtocolVersion(TransferConfig.ProtocolVersion.V0);
                }
            } else {
                line = this.readLine();
                if (line == null) break;
            }
            if (line.length() < 41 || line.charAt(40) != ' ') {
                throw this.invalidRefAdvertisementLine(line);
            }
            String name = line.substring(41, line.length());
            if (!first || !name.equals("capabilities^{}")) {
                ObjectId id = this.toId(line, line.substring(0, 40));
                if (name.equals(".have")) {
                    this.additionalHaves.add(id);
                } else {
                    this.processLineV1(name, id, avail);
                }
            }
            first = false;
        }
        BasePackConnection.updateWithSymRefs(avail, symRefs);
        this.available(avail);
        return true;
    }

    protected void lsRefs(Collection<RefSpec> refSpecs, String ... additionalPatterns) throws TransportException {
        try {
            this.lsRefsImpl(refSpecs, additionalPatterns);
        }
        catch (TransportException err) {
            this.close();
            throw err;
        }
        catch (IOException | RuntimeException err) {
            this.close();
            throw new TransportException(err.getMessage(), err);
        }
    }

    private void lsRefsImpl(Collection<RefSpec> refSpecs, String ... additionalPatterns) throws IOException {
        String line;
        this.pckOut.writeString("command=ls-refs");
        String agent = UserAgent.get();
        if (agent != null && this.isCapableOf("agent")) {
            this.pckOut.writeString("agent=" + agent);
        }
        this.pckOut.writeDelim();
        this.pckOut.writeString("peel");
        this.pckOut.writeString("symrefs");
        for (String refPrefix : this.getRefPrefixes(refSpecs, additionalPatterns)) {
            this.pckOut.writeString("ref-prefix " + refPrefix);
        }
        this.pckOut.end();
        LinkedHashMap<String, Ref> avail = new LinkedHashMap<String, Ref>();
        LinkedHashMap<String, String> symRefs = new LinkedHashMap<String, String>();
        while ((line = this.readLine()) != null) {
            if (line.length() < 41 || line.charAt(40) != ' ') {
                throw this.invalidRefAdvertisementLine(line);
            }
            String name = line.substring(41, line.length());
            ObjectId id = this.toId(line, line.substring(0, 40));
            if (name.equals(".have")) {
                this.additionalHaves.add(id);
                continue;
            }
            this.processLineV2(line, id, name, avail, symRefs);
        }
        BasePackConnection.updateWithSymRefs(avail, symRefs);
        this.available(avail);
    }

    private Collection<String> getRefPrefixes(Collection<RefSpec> refSpecs, String ... additionalPatterns) {
        if (refSpecs.isEmpty() && (additionalPatterns == null || additionalPatterns.length == 0)) {
            return Collections.emptyList();
        }
        HashSet<String> patterns = new HashSet<String>();
        if (additionalPatterns != null) {
            Arrays.stream(additionalPatterns).filter(Objects::nonNull).forEach(patterns::add);
        }
        for (RefSpec spec : refSpecs) {
            String src = spec.getSource();
            if (ObjectId.isId(src)) continue;
            if (spec.isWildcard()) {
                patterns.add(src.substring(0, src.indexOf(42)));
                continue;
            }
            patterns.add(src);
            patterns.add("refs/" + src);
            patterns.add("refs/heads/" + src);
            patterns.add("refs/tags/" + src);
        }
        return patterns;
    }

    private void readCapabilitiesV2() throws IOException {
        String line;
        while ((line = this.readLine()) != null) {
            this.addCapability(line);
        }
    }

    private void addCapability(String capability) {
        String[] parts = capability.split("=", 2);
        if (parts.length == 2) {
            this.remoteCapabilities.put(parts[0], parts[1]);
        }
        this.remoteCapabilities.put(capability, null);
    }

    private ObjectId toId(String line, String value) throws PackProtocolException {
        try {
            return ObjectId.fromString(value);
        }
        catch (InvalidObjectIdException e) {
            PackProtocolException ppe = this.invalidRefAdvertisementLine(line);
            ppe.initCause(e);
            throw ppe;
        }
    }

    private void processLineV1(String name, ObjectId id, Map<String, Ref> avail) throws IOException {
        if (name.endsWith("^{}")) {
            Ref prior = avail.get(name = name.substring(0, name.length() - 3));
            if (prior == null) {
                throw new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().advertisementCameBefore, name, name));
            }
            if (prior.getPeeledObjectId() != null) {
                throw this.duplicateAdvertisement(name + "^{}");
            }
            avail.put(name, new ObjectIdRef.PeeledTag(Ref.Storage.NETWORK, name, prior.getObjectId(), id));
        } else {
            Ref prior = avail.put(name, new ObjectIdRef.PeeledNonTag(Ref.Storage.NETWORK, name, id));
            if (prior != null) {
                throw this.duplicateAdvertisement(name);
            }
        }
    }

    private void processLineV2(String line, ObjectId id, String rest, Map<String, Ref> avail, Map<String, String> symRefs) throws IOException {
        ObjectIdRef idRef;
        Ref prior;
        String[] parts = rest.split(" ");
        String name = parts[0];
        String symRefTarget = null;
        String peeled = null;
        for (int i = 1; i < parts.length; ++i) {
            if (parts[i].startsWith("symref-target:")) {
                if (symRefTarget != null) {
                    throw new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().duplicateRefAttribute, line));
                }
                symRefTarget = parts[i].substring("symref-target:".length());
            } else if (parts[i].startsWith("peeled:")) {
                if (peeled != null) {
                    throw new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().duplicateRefAttribute, line));
                }
                peeled = parts[i].substring("peeled:".length());
            }
            if (peeled != null && symRefTarget != null) break;
        }
        if ((prior = avail.put(name, idRef = peeled != null ? new ObjectIdRef.PeeledTag(Ref.Storage.NETWORK, name, id, this.toId(line, peeled)) : new ObjectIdRef.PeeledNonTag(Ref.Storage.NETWORK, name, id))) != null) {
            throw this.duplicateAdvertisement(name);
        }
        if (!StringUtils.isEmptyOrNull(symRefTarget)) {
            symRefs.put(name, symRefTarget);
        }
    }

    static void updateWithSymRefs(Map<String, Ref> refMap, Map<String, String> symRefs) {
        Ref headRef;
        boolean haveNewRefMapEntries;
        boolean bl = haveNewRefMapEntries = !refMap.isEmpty();
        while (!symRefs.isEmpty() && haveNewRefMapEntries) {
            haveNewRefMapEntries = false;
            Iterator<Map.Entry<String, String>> iterator = symRefs.entrySet().iterator();
            while (iterator.hasNext()) {
                Ref r;
                Map.Entry<String, String> symRef = iterator.next();
                if (symRefs.containsKey(symRef.getValue()) || (r = refMap.get(symRef.getValue())) == null) continue;
                refMap.put(symRef.getKey(), new SymbolicRef(symRef.getKey(), r));
                haveNewRefMapEntries = true;
                iterator.remove();
            }
        }
        String headRefName = symRefs.get("HEAD");
        if (headRefName != null && !refMap.containsKey(headRefName) && (headRef = refMap.get("HEAD")) != null) {
            ObjectId headObj = headRef.getObjectId();
            headRef = new ObjectIdRef.PeeledNonTag(Ref.Storage.NETWORK, headRefName, headObj);
            refMap.put(headRefName, headRef);
            headRef = new SymbolicRef("HEAD", headRef);
            refMap.put("HEAD", headRef);
            symRefs.remove("HEAD");
        }
    }

    protected TransportException noRepository(Throwable cause) {
        return new NoRemoteRepositoryException(this.uri, JGitText.get().notFound, cause);
    }

    protected boolean isCapableOf(String option) {
        return this.remoteCapabilities.containsKey(option);
    }

    protected boolean wantCapability(StringBuilder b, String option) {
        if (!this.isCapableOf(option)) {
            return false;
        }
        b.append(' ');
        b.append(option);
        return true;
    }

    protected String getCapability(String option) {
        return this.remoteCapabilities.get(option);
    }

    protected void addUserAgentCapability(StringBuilder b) {
        String a = UserAgent.get();
        if (a != null && this.remoteCapabilities.get("agent") != null) {
            b.append(' ').append("agent").append('=').append(a);
        }
    }

    @Override
    public String getPeerUserAgent() {
        String agent = this.remoteCapabilities.get("agent");
        return agent != null ? agent : super.getPeerUserAgent();
    }

    private PackProtocolException duplicateAdvertisement(String name) {
        return new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().duplicateAdvertisementsOf, name));
    }

    private PackProtocolException invalidRefAdvertisementLine(String line) {
        return new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().invalidRefAdvertisementLine, line));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.out != null) {
            try {
                if (this.outNeedsEnd) {
                    this.outNeedsEnd = false;
                    this.pckOut.end();
                }
                this.out.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.out = null;
                this.pckOut = null;
            }
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.in = null;
                this.pckIn = null;
            }
        }
        if (this.myTimer != null) {
            try {
                this.myTimer.terminate();
            }
            finally {
                this.myTimer = null;
                this.timeoutIn = null;
                this.timeoutOut = null;
            }
        }
    }

    protected void endOut() {
        if (this.outNeedsEnd && this.out != null) {
            try {
                this.outNeedsEnd = false;
                this.pckOut.end();
            }
            catch (IOException e) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    this.out = null;
                    this.pckOut = null;
                }
            }
        }
    }
}

