/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.internal.storage.file;

import com.jxdinfo.hussar.formdesign.jgit.lib.AnyObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.MutableObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectIdOwnerMap;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectIdSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class LazyObjectIdSetFile
implements ObjectIdSet {
    private final File src;
    private ObjectIdOwnerMap<Entry> set;

    public LazyObjectIdSetFile(File src) {
        this.src = src;
    }

    @Override
    public boolean contains(AnyObjectId objectId) {
        if (this.set == null) {
            this.set = this.load();
        }
        return this.set.contains(objectId);
    }

    private ObjectIdOwnerMap<Entry> load() {
        ObjectIdOwnerMap<Entry> r = new ObjectIdOwnerMap<Entry>();
        try (FileInputStream fin = new FileInputStream(this.src);
             InputStreamReader rin = new InputStreamReader((InputStream)fin, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(rin);){
            String line;
            MutableObjectId id = new MutableObjectId();
            while ((line = br.readLine()) != null) {
                id.fromString(line);
                if (r.contains(id)) continue;
                r.add(new Entry(id));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return r;
    }

    static class Entry
    extends ObjectIdOwnerMap.Entry {
        Entry(AnyObjectId id) {
            super(id);
        }
    }
}

