/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.api;

import com.jxdinfo.hussar.formdesign.jgit.api.AddCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.CloneCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.Git;
import com.jxdinfo.hussar.formdesign.jgit.api.TransportCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.GitAPIException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.JGitInternalException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.NoFilepatternException;
import com.jxdinfo.hussar.formdesign.jgit.errors.ConfigInvalidException;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.internal.submodule.SubmoduleValidator;
import com.jxdinfo.hussar.formdesign.jgit.lib.ProgressMonitor;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.lib.StoredConfig;
import com.jxdinfo.hussar.formdesign.jgit.storage.file.FileBasedConfig;
import com.jxdinfo.hussar.formdesign.jgit.submodule.SubmoduleWalk;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.filter.PathFilter;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;

public class SubmoduleAddCommand
extends TransportCommand<SubmoduleAddCommand, Repository> {
    private String name;
    private String path;
    private String uri;
    private ProgressMonitor monitor;

    public SubmoduleAddCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleAddCommand setName(String name) {
        this.name = name;
        return this;
    }

    public SubmoduleAddCommand setPath(String path) {
        this.path = path;
        return this;
    }

    public SubmoduleAddCommand setURI(String uri) {
        this.uri = uri;
        return this;
    }

    public SubmoduleAddCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    protected boolean submoduleExists() throws IOException {
        PathFilter filter = PathFilter.create(this.path);
        try (SubmoduleWalk w = SubmoduleWalk.forIndex(this.repo);){
            boolean bl = w.setFilter(filter).next();
            return bl;
        }
    }

    @Override
    public Repository call() throws GitAPIException {
        String resolvedUri;
        this.checkCallable();
        if (this.path == null || this.path.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().pathNotConfigured);
        }
        if (this.uri == null || this.uri.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().uriNotConfigured);
        }
        if (this.name == null || this.name.length() == 0) {
            this.name = this.path;
        }
        try {
            SubmoduleValidator.assertValidSubmoduleName(this.name);
            SubmoduleValidator.assertValidSubmodulePath(this.path);
            SubmoduleValidator.assertValidSubmoduleUri(this.uri);
        }
        catch (SubmoduleValidator.SubmoduleValidationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        try {
            if (this.submoduleExists()) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().submoduleExists, this.path));
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        try {
            resolvedUri = SubmoduleWalk.getSubmoduleRemoteUrl(this.repo, this.uri);
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        File moduleDirectory = SubmoduleWalk.getSubmoduleDirectory(this.repo, this.path);
        CloneCommand clone = Git.cloneRepository();
        this.configure(clone);
        clone.setDirectory(moduleDirectory);
        clone.setGitDir(new File(new File(this.repo.getDirectory(), "modules"), this.path));
        clone.setURI(resolvedUri);
        if (this.monitor != null) {
            clone.setProgressMonitor(this.monitor);
        }
        Repository subRepo = null;
        try (Git git = clone.call();){
            subRepo = git.getRepository();
            subRepo.incrementOpen();
        }
        StoredConfig config = this.repo.getConfig();
        config.setString("submodule", this.name, "url", resolvedUri);
        try {
            config.save();
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        FileBasedConfig modulesConfig = new FileBasedConfig(new File(this.repo.getWorkTree(), ".gitmodules"), this.repo.getFS());
        try {
            modulesConfig.load();
            modulesConfig.setString("submodule", this.name, "path", this.path);
            modulesConfig.setString("submodule", this.name, "url", this.uri);
            modulesConfig.save();
        }
        catch (ConfigInvalidException | IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        AddCommand add = new AddCommand(this.repo);
        add.addFilepattern(".gitmodules");
        add.addFilepattern(this.path);
        try {
            add.call();
        }
        catch (NoFilepatternException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        return subRepo;
    }
}

