/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.api;

import com.jxdinfo.hussar.formdesign.jgit.api.GitCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.GitAPIException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.InvalidRefNameException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.RefNotFoundException;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.lib.ReflogEntry;
import com.jxdinfo.hussar.formdesign.jgit.lib.ReflogReader;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;

public class ReflogCommand
extends GitCommand<Collection<ReflogEntry>> {
    private String ref = "HEAD";

    public ReflogCommand(Repository repo) {
        super(repo);
    }

    public ReflogCommand setRef(String ref) {
        this.checkCallable();
        this.ref = ref;
        return this;
    }

    @Override
    public Collection<ReflogEntry> call() throws GitAPIException, InvalidRefNameException {
        this.checkCallable();
        try {
            ReflogReader reader = this.repo.getReflogReader(this.ref);
            if (reader == null) {
                throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.ref));
            }
            return reader.getReverseEntries();
        }
        catch (IOException e) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().cannotRead, this.ref), e);
        }
    }
}

