/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.revplot;

import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.revplot.PlotCommit;
import com.jxdinfo.hussar.formdesign.jgit.revplot.PlotLane;
import com.jxdinfo.hussar.formdesign.jgit.revplot.PlotWalk;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevCommitList;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevWalk;
import java.text.MessageFormat;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;

public class PlotCommitList<L extends PlotLane>
extends RevCommitList<PlotCommit<L>> {
    static final int MAX_LENGTH = 25;
    private int positionsAllocated;
    private final TreeSet<Integer> freePositions = new TreeSet();
    private final HashSet<PlotLane> activeLanes = new HashSet(32);
    private final HashMap<PlotLane, Integer> laneLength = new HashMap(32);

    @Override
    public void clear() {
        super.clear();
        this.positionsAllocated = 0;
        this.freePositions.clear();
        this.activeLanes.clear();
        this.laneLength.clear();
    }

    @Override
    public void source(RevWalk w) {
        if (!(w instanceof PlotWalk)) {
            throw new ClassCastException(MessageFormat.format(JGitText.get().classCastNotA, PlotWalk.class.getName()));
        }
        super.source(w);
    }

    public void findPassingThrough(PlotCommit<L> currCommit, Collection<L> result) {
        for (PlotLane p : currCommit.passingLanes) {
            result.add(p);
        }
    }

    @Override
    protected void enter(int index, PlotCommit<L> currCommit) {
        this.setupChildren(currCommit);
        int nChildren = currCommit.getChildCount();
        if (nChildren == 0) {
            currCommit.lane = this.nextFreeLane();
        } else if (nChildren == 1 && currCommit.children[0].getParentCount() < 2) {
            PlotCommit c = currCommit.children[0];
            currCommit.lane = c.lane;
            Integer len = this.laneLength.get(currCommit.lane);
            len = len != null ? Integer.valueOf(len + 1) : Integer.valueOf(0);
            this.laneLength.put(currCommit.lane, len);
        } else {
            PlotCommit c;
            int i;
            PlotLane reservedLane = null;
            PlotCommit childOnReservedLane = null;
            int lengthOfReservedLane = -1;
            for (i = 0; i < nChildren; ++i) {
                Integer len;
                c = currCommit.children[i];
                if (c.getParent(0) != currCommit || (len = this.laneLength.get(c.lane)) <= lengthOfReservedLane) continue;
                reservedLane = c.lane;
                childOnReservedLane = c;
                lengthOfReservedLane = len;
            }
            if (reservedLane != null) {
                currCommit.lane = reservedLane;
                this.laneLength.put(reservedLane, lengthOfReservedLane + 1);
                this.handleBlockedLanes(index, currCommit, childOnReservedLane);
            } else {
                currCommit.lane = this.nextFreeLane();
                this.handleBlockedLanes(index, currCommit, null);
            }
            for (i = 0; i < nChildren; ++i) {
                c = currCommit.children[i];
                PlotCommit firstParent = (PlotCommit)c.getParent(0);
                if (firstParent.lane == null || firstParent.lane == c.lane) continue;
                this.closeLane(c.lane);
            }
        }
        this.continueActiveLanes(currCommit);
        if (currCommit.getParentCount() == 0) {
            this.closeLane(currCommit.lane);
        }
    }

    private void continueActiveLanes(PlotCommit currCommit) {
        for (PlotLane lane : this.activeLanes) {
            if (lane == currCommit.lane) continue;
            currCommit.addPassingLane(lane);
        }
    }

    private void handleBlockedLanes(int index, PlotCommit currCommit, PlotCommit childOnLane) {
        for (PlotCommit child : currCommit.children) {
            PlotLane laneToUse;
            boolean childIsMerge;
            if (child == childOnLane) continue;
            boolean bl = childIsMerge = child.getParent(0) != currCommit;
            if (childIsMerge) {
                laneToUse = currCommit.lane;
                laneToUse = this.handleMerge(index, currCommit, childOnLane, child, laneToUse);
                child.addMergingLane(laneToUse);
                continue;
            }
            laneToUse = child.lane;
            currCommit.addForkingOffLane(laneToUse);
        }
    }

    private PlotLane handleMerge(int index, PlotCommit currCommit, PlotCommit childOnLane, PlotCommit child, PlotLane laneToUse) {
        int childIndex = index;
        BitSet blockedPositions = new BitSet();
        for (int r = index - 1; r >= 0; --r) {
            PlotCommit rObj = (PlotCommit)this.get(r);
            if (rObj == child) {
                childIndex = r;
                break;
            }
            PlotCommitList.addBlockedPosition(blockedPositions, rObj);
        }
        if (blockedPositions.get(laneToUse.getPosition())) {
            boolean needDetour = false;
            if (childOnLane != null) {
                for (int r = index - 1; r > childIndex; --r) {
                    PlotCommit rObj = (PlotCommit)this.get(r);
                    if (rObj != childOnLane) continue;
                    needDetour = true;
                    break;
                }
            }
            if (needDetour) {
                laneToUse = this.nextFreeLane(blockedPositions);
                currCommit.addForkingOffLane(laneToUse);
                this.closeLane(laneToUse);
            } else {
                int newPos = this.getFreePosition(blockedPositions);
                this.freePositions.add(laneToUse.getPosition());
                laneToUse.position = newPos;
            }
        }
        this.drawLaneToChild(index, child, laneToUse);
        return laneToUse;
    }

    private void drawLaneToChild(int commitIndex, PlotCommit child, PlotLane laneToContinue) {
        PlotCommit rObj;
        for (int r = commitIndex - 1; r >= 0 && (rObj = (PlotCommit)this.get(r)) != child; --r) {
            if (rObj == null) continue;
            rObj.addPassingLane(laneToContinue);
        }
    }

    private static void addBlockedPosition(BitSet blockedPositions, PlotCommit rObj) {
        if (rObj != null) {
            Object lane = rObj.getLane();
            if (lane != null) {
                blockedPositions.set(((PlotLane)lane).getPosition());
            }
            for (PlotLane l : rObj.forkingOffLanes) {
                blockedPositions.set(l.getPosition());
            }
            for (PlotLane l : rObj.mergingLanes) {
                blockedPositions.set(l.getPosition());
            }
        }
    }

    private void closeLane(PlotLane lane) {
        if (this.activeLanes.remove(lane)) {
            this.recycleLane(lane);
            this.laneLength.remove(lane);
            this.freePositions.add(lane.getPosition());
        }
    }

    private void setupChildren(PlotCommit<L> currCommit) {
        int nParents = currCommit.getParentCount();
        for (int i = 0; i < nParents; ++i) {
            ((PlotCommit)currCommit.getParent(i)).addChild(currCommit);
        }
    }

    private PlotLane nextFreeLane() {
        return this.nextFreeLane(null);
    }

    private PlotLane nextFreeLane(BitSet blockedPositions) {
        L p = this.createLane();
        ((PlotLane)p).position = this.getFreePosition(blockedPositions);
        this.activeLanes.add((PlotLane)p);
        this.laneLength.put((PlotLane)p, 1);
        return p;
    }

    private int getFreePosition(BitSet blockedPositions) {
        if (this.freePositions.isEmpty()) {
            return this.positionsAllocated++;
        }
        if (blockedPositions != null) {
            for (Integer pos : this.freePositions) {
                if (blockedPositions.get(pos)) continue;
                this.freePositions.remove(pos);
                return pos;
            }
            return this.positionsAllocated++;
        }
        Integer min = this.freePositions.first();
        this.freePositions.remove(min);
        return min;
    }

    protected L createLane() {
        return (L)new PlotLane();
    }

    protected void recycleLane(L lane) {
    }
}

