/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.api;

import com.jxdinfo.hussar.formdesign.jgit.api.ApplyResult;
import com.jxdinfo.hussar.formdesign.jgit.api.GitCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.FilterFailedException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.GitAPIException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.PatchApplyException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.PatchFormatException;
import com.jxdinfo.hussar.formdesign.jgit.attributes.FilterCommand;
import com.jxdinfo.hussar.formdesign.jgit.attributes.FilterCommandRegistry;
import com.jxdinfo.hussar.formdesign.jgit.diff.DiffEntry;
import com.jxdinfo.hussar.formdesign.jgit.diff.RawText;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCache;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheCheckout;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheIterator;
import com.jxdinfo.hussar.formdesign.jgit.errors.LargeObjectException;
import com.jxdinfo.hussar.formdesign.jgit.errors.MissingObjectException;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.lib.Constants;
import com.jxdinfo.hussar.formdesign.jgit.lib.CoreConfig;
import com.jxdinfo.hussar.formdesign.jgit.lib.FileMode;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectLoader;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectStream;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.patch.FileHeader;
import com.jxdinfo.hussar.formdesign.jgit.patch.HunkHeader;
import com.jxdinfo.hussar.formdesign.jgit.patch.Patch;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.FileTreeIterator;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.TreeWalk;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.filter.AndTreeFilter;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.filter.NotIgnoredFilter;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.filter.PathFilterGroup;
import com.jxdinfo.hussar.formdesign.jgit.util.FS;
import com.jxdinfo.hussar.formdesign.jgit.util.FileUtils;
import com.jxdinfo.hussar.formdesign.jgit.util.IO;
import com.jxdinfo.hussar.formdesign.jgit.util.RawParseUtils;
import com.jxdinfo.hussar.formdesign.jgit.util.StringUtils;
import com.jxdinfo.hussar.formdesign.jgit.util.TemporaryBuffer;
import com.jxdinfo.hussar.formdesign.jgit.util.io.BinaryDeltaInputStream;
import com.jxdinfo.hussar.formdesign.jgit.util.io.BinaryHunkInputStream;
import com.jxdinfo.hussar.formdesign.jgit.util.io.EolStreamTypeUtil;
import com.jxdinfo.hussar.formdesign.jgit.util.sha1.SHA1;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.InflaterInputStream;

public class ApplyCommand
extends GitCommand<ApplyResult> {
    private InputStream in;

    ApplyCommand(Repository repo) {
        super(repo);
    }

    public ApplyCommand setPatch(InputStream in) {
        this.checkCallable();
        this.in = in;
        return this;
    }

    @Override
    public ApplyResult call() throws GitAPIException, PatchFormatException, PatchApplyException {
        this.checkCallable();
        this.setCallable(false);
        ApplyResult r = new ApplyResult();
        try {
            Patch p = new Patch();
            try {
                p.parse(this.in);
            }
            finally {
                this.in.close();
            }
            if (!p.getErrors().isEmpty()) {
                throw new PatchFormatException(p.getErrors());
            }
            Repository repository = this.getRepository();
            DirCache cache = repository.readDirCache();
            for (FileHeader fileHeader : p.getFiles()) {
                DiffEntry.ChangeType type = fileHeader.getChangeType();
                File f = null;
                switch (type) {
                    case ADD: {
                        f = this.getFile(fileHeader.getNewPath(), true);
                        this.apply(repository, fileHeader.getNewPath(), cache, f, fileHeader);
                        break;
                    }
                    case MODIFY: {
                        f = this.getFile(fileHeader.getOldPath(), false);
                        this.apply(repository, fileHeader.getOldPath(), cache, f, fileHeader);
                        break;
                    }
                    case DELETE: {
                        f = this.getFile(fileHeader.getOldPath(), false);
                        if (f.delete()) break;
                        throw new PatchApplyException(MessageFormat.format(JGitText.get().cannotDeleteFile, f));
                    }
                    case RENAME: {
                        f = this.getFile(fileHeader.getOldPath(), false);
                        File dest = this.getFile(fileHeader.getNewPath(), false);
                        try {
                            FileUtils.mkdirs(dest.getParentFile(), true);
                            FileUtils.rename(f, dest, StandardCopyOption.ATOMIC_MOVE);
                        }
                        catch (IOException e) {
                            throw new PatchApplyException(MessageFormat.format(JGitText.get().renameFileFailed, f, dest), e);
                        }
                        this.apply(repository, fileHeader.getOldPath(), cache, dest, fileHeader);
                        break;
                    }
                    case COPY: {
                        f = this.getFile(fileHeader.getOldPath(), false);
                        File target = this.getFile(fileHeader.getNewPath(), false);
                        FileUtils.mkdirs(target.getParentFile(), true);
                        Files.copy(f.toPath(), target.toPath(), new CopyOption[0]);
                        this.apply(repository, fileHeader.getOldPath(), cache, target, fileHeader);
                    }
                }
                r.addUpdatedFile(f);
            }
        }
        catch (IOException e) {
            throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, e.getMessage()), e);
        }
        return r;
    }

    private File getFile(String path, boolean create) throws PatchApplyException {
        File f = new File(this.getRepository().getWorkTree(), path);
        if (create) {
            try {
                File parent = f.getParentFile();
                FileUtils.mkdirs(parent, true);
                FileUtils.createNewFile(f);
            }
            catch (IOException e) {
                throw new PatchApplyException(MessageFormat.format(JGitText.get().createNewFileFailed, f), e);
            }
        }
        return f;
    }

    private void apply(Repository repository, String path, DirCache cache, File f, FileHeader fh) throws IOException, PatchApplyException {
        DirCacheCheckout.CheckoutMetadata checkOut;
        boolean convertCrLf;
        block45: {
            if (FileHeader.PatchType.BINARY.equals((Object)fh.getPatchType())) {
                return;
            }
            convertCrLf = this.needsCrLfConversion(f, fh);
            try (TreeWalk walk = new TreeWalk(repository);){
                walk.setOperationType(TreeWalk.OperationType.CHECKIN_OP);
                FileTreeIterator files = new FileTreeIterator(repository);
                int fileIdx = walk.addTree(files);
                int cacheIdx = walk.addTree(new DirCacheIterator(cache));
                files.setDirCacheIterator(walk, cacheIdx);
                walk.setFilter(AndTreeFilter.create(PathFilterGroup.createFromStrings(path), new NotIgnoredFilter(fileIdx)));
                walk.setRecursive(true);
                if (!walk.next()) break block45;
                CoreConfig.EolStreamType streamType = convertCrLf ? CoreConfig.EolStreamType.TEXT_CRLF : walk.getEolStreamType(TreeWalk.OperationType.CHECKOUT_OP);
                String command = walk.getFilterCommand("smudge");
                DirCacheCheckout.CheckoutMetadata checkOut2 = new DirCacheCheckout.CheckoutMetadata(streamType, command);
                FileTreeIterator file = walk.getTree(fileIdx, FileTreeIterator.class);
                if (file == null) break block45;
                if (FileHeader.PatchType.GIT_BINARY.equals((Object)fh.getPatchType())) {
                    this.applyBinary(repository, path, f, fh, file::openEntryStream, file.getEntryObjectId(), checkOut2);
                } else {
                    RawText raw;
                    command = walk.getFilterCommand("clean");
                    try (InputStream input = this.filterClean(repository, path, new FileInputStream(f), convertCrLf, command);){
                        raw = new RawText(IO.readWholeStream(input, 0).array());
                    }
                    this.applyText(repository, path, raw, f, fh, checkOut2);
                }
                return;
            }
        }
        if (FileHeader.PatchType.GIT_BINARY.equals((Object)fh.getPatchType())) {
            checkOut = new DirCacheCheckout.CheckoutMetadata(CoreConfig.EolStreamType.DIRECT, null);
            this.applyBinary(repository, path, f, fh, () -> new FileInputStream(f), null, checkOut);
        } else {
            RawText raw;
            if (convertCrLf) {
                try (InputStream input = EolStreamTypeUtil.wrapInputStream(new FileInputStream(f), CoreConfig.EolStreamType.TEXT_LF);){
                    raw = new RawText(IO.readWholeStream(input, 0).array());
                }
                checkOut = new DirCacheCheckout.CheckoutMetadata(CoreConfig.EolStreamType.TEXT_CRLF, null);
            } else {
                raw = new RawText(f);
                checkOut = new DirCacheCheckout.CheckoutMetadata(CoreConfig.EolStreamType.DIRECT, null);
            }
            this.applyText(repository, path, raw, f, fh, checkOut);
        }
    }

    private boolean needsCrLfConversion(File f, FileHeader fileHeader) throws IOException {
        if (FileHeader.PatchType.GIT_BINARY.equals((Object)fileHeader.getPatchType())) {
            return false;
        }
        if (!ApplyCommand.hasCrLf(fileHeader)) {
            try (FileInputStream input = new FileInputStream(f);){
                boolean bl = RawText.isCrLfText(input);
                return bl;
            }
        }
        return false;
    }

    private static boolean hasCrLf(FileHeader fileHeader) {
        if (FileHeader.PatchType.GIT_BINARY.equals((Object)fileHeader.getPatchType())) {
            return false;
        }
        block0: for (HunkHeader hunkHeader : fileHeader.getHunks()) {
            byte[] buf = hunkHeader.getBuffer();
            int hunkEnd = hunkHeader.getEndOffset();
            int lineStart = hunkHeader.getStartOffset();
            while (lineStart < hunkEnd) {
                char first;
                int nextLineStart = RawParseUtils.nextLF(buf, lineStart);
                if (nextLineStart > hunkEnd) {
                    nextLineStart = hunkEnd;
                }
                if (nextLineStart <= lineStart) continue block0;
                if (nextLineStart - lineStart > 1 && ((first = (char)(buf[lineStart] & 0xFF)) == ' ' || first == '-') && buf[nextLineStart - 2] == 13) {
                    return true;
                }
                lineStart = nextLineStart;
            }
        }
        return false;
    }

    private InputStream filterClean(Repository repository, String path, InputStream fromFile, boolean convertCrLf, String filterCommand) throws IOException {
        FS.ExecutionResult result;
        InputStream input = fromFile;
        if (convertCrLf) {
            input = EolStreamTypeUtil.wrapInputStream(input, CoreConfig.EolStreamType.TEXT_LF);
        }
        if (StringUtils.isEmptyOrNull(filterCommand)) {
            return input;
        }
        if (FilterCommandRegistry.isRegistered(filterCommand)) {
            TemporaryBuffer.LocalFile buffer = new TemporaryBuffer.LocalFile(null);
            FilterCommand command = FilterCommandRegistry.createFilterCommand(filterCommand, repository, input, buffer);
            while (command.run() != -1) {
            }
            return buffer.openInputStreamWithAutoDestroy();
        }
        FS fs = repository.getFS();
        ProcessBuilder filterProcessBuilder = fs.runInShell(filterCommand, new String[0]);
        filterProcessBuilder.directory(repository.getWorkTree());
        filterProcessBuilder.environment().put("GIT_DIR", repository.getDirectory().getAbsolutePath());
        try {
            result = fs.execute(filterProcessBuilder, this.in);
        }
        catch (IOException | InterruptedException e) {
            throw new IOException(new FilterFailedException(e, filterCommand, path));
        }
        int rc = result.getRc();
        if (rc != 0) {
            throw new IOException(new FilterFailedException(rc, filterCommand, path, result.getStdout().toByteArray(4096), RawParseUtils.decode(result.getStderr().toByteArray(4096))));
        }
        return result.getStdout().openInputStreamWithAutoDestroy();
    }

    private void initHash(SHA1 hash, long size) {
        hash.update(Constants.encodedTypeString(3));
        hash.update((byte)32);
        hash.update(Constants.encodeASCII(size));
        hash.update((byte)0);
    }

    private ObjectId hash(File f) throws IOException {
        SHA1 hash = SHA1.newInstance();
        this.initHash(hash, f.length());
        try (FileInputStream input = new FileInputStream(f);){
            int n;
            byte[] buf = new byte[8192];
            while ((n = ((InputStream)input).read(buf)) >= 0) {
                hash.update(buf, 0, n);
            }
        }
        return hash.toObjectId();
    }

    private void checkOid(ObjectId baseId, ObjectId id, DiffEntry.ChangeType type, File f, String path) throws PatchApplyException, IOException {
        boolean hashOk = false;
        if (id != null) {
            hashOk = baseId.equals(id);
            if (!hashOk && DiffEntry.ChangeType.ADD.equals((Object)type) && ObjectId.zeroId().equals(baseId)) {
                hashOk = Constants.EMPTY_BLOB_ID.equals(id);
            }
        } else {
            hashOk = ObjectId.zeroId().equals(baseId) ? !f.exists() || f.length() == 0L : baseId.equals(this.hash(f));
        }
        if (!hashOk) {
            throw new PatchApplyException(MessageFormat.format(JGitText.get().applyBinaryBaseOidWrong, path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void applyBinary(Repository repository, String path, File f, FileHeader fh, StreamSupplier loader, ObjectId id, DirCacheCheckout.CheckoutMetadata checkOut) throws PatchApplyException, IOException {
        if (!fh.getOldId().isComplete() || !fh.getNewId().isComplete()) {
            throw new PatchApplyException(MessageFormat.format(JGitText.get().applyBinaryOidTooShort, new Object[]{path}));
        }
        hunk = fh.getForwardBinaryHunk();
        start = RawParseUtils.nextLF(hunk.getBuffer(), hunk.getStartOffset());
        length = hunk.getEndOffset() - start;
        hash = SHA1.newInstance();
        buffer = new TemporaryBuffer.LocalFile(null);
        try {
            switch (1.$SwitchMap$com$jxdinfo$hussar$formdesign$jgit$patch$BinaryHunk$Type[hunk.getType().ordinal()]) {
                case 1: {
                    this.checkOid(fh.getOldId().toObjectId(), id, fh.getChangeType(), f, path);
                    this.initHash(hash, hunk.getSize());
                    out = buffer;
                    var14_15 = null;
                    try {
                        inflated = new SHA1InputStream(hash, new InflaterInputStream(new BinaryHunkInputStream(new ByteArrayInputStream(hunk.getBuffer(), start, length))));
                        var16_23 = null;
                        try {
                            DirCacheCheckout.getContent(repository, path, checkOut, new StreamLoader((StreamSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/io/InputStream;, lambda$applyBinary$1(java.io.InputStream ), ()Ljava/io/InputStream;)((InputStream)inflated), hunk.getSize()), null, out);
                            if (!fh.getNewId().toObjectId().equals(hash.toObjectId())) {
                                throw new PatchApplyException(MessageFormat.format(JGitText.get().applyBinaryResultOidWrong, new Object[]{path}));
                            }
                        }
                        catch (Throwable var17_32) {
                            var16_23 = var17_32;
                            throw var17_32;
                        }
                        finally {
                            if (inflated != null) {
                                if (var16_23 != null) {
                                    try {
                                        inflated.close();
                                    }
                                    catch (Throwable var17_31) {
                                        var16_23.addSuppressed(var17_31);
                                    }
                                } else {
                                    inflated.close();
                                }
                            }
                        }
                    }
                    catch (Throwable var15_19) {
                        var14_15 = var15_19;
                        throw var15_19;
                    }
                    finally {
                        if (out != null) {
                            if (var14_15 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable var15_18) {
                                    var14_15.addSuppressed(var15_18);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                    bufIn = buffer.openInputStream();
                    var14_15 = null;
                    Files.copy(bufIn, f.toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    if (bufIn == null) break;
                    if (var14_15 == null) ** GOTO lbl66
                    try {
                        bufIn.close();
                        ** break;
lbl61:
                        // 1 sources

                    }
                    catch (Throwable var15_20) {
                        var14_15.addSuppressed(var15_20);
                        ** break;
                    }
lbl65:
                    // 1 sources

                    break;
lbl66:
                    // 1 sources

                    bufIn.close();
                    ** break;
lbl68:
                    // 1 sources

                    break;
                    catch (Throwable var15_21) {
                        try {
                            var14_15 = var15_21;
                            throw var15_21;
                        }
                        catch (Throwable var22_43) {
                            if (bufIn != null) {
                                if (var14_15 != null) {
                                    try {
                                        bufIn.close();
                                    }
                                    catch (Throwable var23_46) {
                                        var14_15.addSuppressed(var23_46);
                                    }
                                } else {
                                    bufIn.close();
                                }
                            }
                            throw var22_43;
                        }
                    }
                }
                case 2: {
                    input = loader.load();
                    var15_22 = null;
                    try {
                        base = IO.readWholeStream(input, 0).array();
                    }
                    catch (Throwable var16_25) {
                        var15_22 = var16_25;
                        throw var16_25;
                    }
                    finally {
                        if (input != null) {
                            if (var15_22 != null) {
                                try {
                                    input.close();
                                }
                                catch (Throwable var16_24) {
                                    var15_22.addSuppressed(var16_24);
                                }
                            } else {
                                input.close();
                            }
                        }
                    }
                    input = new BinaryDeltaInputStream(base, new InflaterInputStream(new BinaryHunkInputStream(new ByteArrayInputStream(hunk.getBuffer(), start, length))));
                    var15_22 = null;
                    try {
                        finalSize = input.getExpectedResultSize();
                        this.initHash(hash, finalSize);
                        out = buffer;
                        var19_36 = null;
                        try {
                            hashed = new SHA1InputStream(hash, input);
                            var21_42 = null;
                            try {
                                DirCacheCheckout.getContent(repository, path, checkOut, new StreamLoader((StreamSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/io/InputStream;, lambda$applyBinary$2(com.jxdinfo.hussar.formdesign.jgit.api.ApplyCommand$SHA1InputStream ), ()Ljava/io/InputStream;)((SHA1InputStream)hashed), finalSize), null, out);
                                if (!fh.getNewId().toObjectId().equals(hash.toObjectId())) {
                                    throw new PatchApplyException(MessageFormat.format(JGitText.get().applyBinaryResultOidWrong, new Object[]{path}));
                                }
                            }
                            catch (Throwable var22_45) {
                                var21_42 = var22_45;
                                throw var22_45;
                            }
                            finally {
                                if (hashed != null) {
                                    if (var21_42 != null) {
                                        try {
                                            hashed.close();
                                        }
                                        catch (Throwable var22_44) {
                                            var21_42.addSuppressed(var22_44);
                                        }
                                    } else {
                                        hashed.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable var20_40) {
                            var19_36 = var20_40;
                            throw var20_40;
                        }
                        finally {
                            if (out != null) {
                                if (var19_36 != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (Throwable var20_39) {
                                        var19_36.addSuppressed(var20_39);
                                    }
                                } else {
                                    out.close();
                                }
                            }
                        }
                    }
                    catch (Throwable var16_28) {
                        var15_22 = var16_28;
                        throw var16_28;
                    }
                    finally {
                        if (input != null) {
                            if (var15_22 != null) {
                                try {
                                    input.close();
                                }
                                catch (Throwable var16_27) {
                                    var15_22.addSuppressed(var16_27);
                                }
                            } else {
                                input.close();
                            }
                        }
                    }
                    bufIn = buffer.openInputStream();
                    var15_22 = null;
                    Files.copy(bufIn, f.toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    if (bufIn == null) break;
                    if (var15_22 == null) ** GOTO lbl176
                    try {
                        bufIn.close();
                        ** break;
lbl171:
                        // 1 sources

                    }
                    catch (Throwable var16_29) {
                        var15_22.addSuppressed(var16_29);
                        ** break;
                    }
lbl175:
                    // 1 sources

                    break;
lbl176:
                    // 1 sources

                    bufIn.close();
                    ** break;
lbl178:
                    // 1 sources

                    break;
                    catch (Throwable var16_30) {
                        try {
                            var15_22 = var16_30;
                            throw var16_30;
                        }
                        catch (Throwable var32_55) {
                            if (bufIn != null) {
                                if (var15_22 != null) {
                                    try {
                                        bufIn.close();
                                    }
                                    catch (Throwable var33_56) {
                                        var15_22.addSuppressed(var33_56);
                                    }
                                } else {
                                    bufIn.close();
                                }
                            }
                            throw var32_55;
                        }
                    }
                }
                ** default:
lbl195:
                // 1 sources

                break;
            }
        }
        finally {
            buffer.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyText(Repository repository, String path, RawText rt, File f, FileHeader fh, DirCacheCheckout.CheckoutMetadata checkOut) throws IOException, PatchApplyException {
        ArrayList<ByteBuffer> oldLines = new ArrayList<ByteBuffer>(rt.size());
        for (int i = 0; i < rt.size(); ++i) {
            oldLines.add(rt.getRawString(i));
        }
        ArrayList<ByteBuffer> newLines = new ArrayList<ByteBuffer>(oldLines);
        int afterLastHunk = 0;
        int lineNumberShift = 0;
        int lastHunkNewLine = -1;
        for (HunkHeader hunkHeader : fh.getHunks()) {
            boolean applies;
            int applyAt;
            ArrayList<ByteBuffer> hunkLines;
            block54: {
                int shift;
                int oldLinesInHunk;
                block53: {
                    if (hunkHeader.getNewStartLine() <= lastHunkNewLine) {
                        throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, hunkHeader));
                    }
                    lastHunkNewLine = hunkHeader.getNewStartLine();
                    byte[] b = new byte[hunkHeader.getEndOffset() - hunkHeader.getStartOffset()];
                    System.arraycopy(hunkHeader.getBuffer(), hunkHeader.getStartOffset(), b, 0, b.length);
                    RawText hrt = new RawText(b);
                    hunkLines = new ArrayList<ByteBuffer>(hrt.size());
                    for (int i = 0; i < hrt.size(); ++i) {
                        hunkLines.add(hrt.getRawString(i));
                    }
                    if (hunkHeader.getNewStartLine() == 0) {
                        if (fh.getHunks().size() == 1 && this.canApplyAt(hunkLines, newLines, 0)) {
                            newLines.clear();
                            break;
                        }
                        throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, hunkHeader));
                    }
                    applyAt = hunkHeader.getNewStartLine() - 1 + lineNumberShift;
                    if (applyAt < afterLastHunk && lineNumberShift < 0) {
                        applyAt = hunkHeader.getNewStartLine() - 1;
                        lineNumberShift = 0;
                    }
                    if (applyAt < afterLastHunk) {
                        throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, hunkHeader));
                    }
                    applies = false;
                    oldLinesInHunk = hunkHeader.getLinesContext() + hunkHeader.getOldImage().getLinesDeleted();
                    if (oldLinesInHunk > 1) break block53;
                    applies = this.canApplyAt(hunkLines, newLines, applyAt);
                    if (applies || lineNumberShift == 0) break block54;
                    applyAt = hunkHeader.getNewStartLine() - 1;
                    applies = applyAt >= afterLastHunk && this.canApplyAt(hunkLines, newLines, applyAt);
                    break block54;
                }
                int maxShift = applyAt - afterLastHunk;
                for (shift = 0; shift <= maxShift; ++shift) {
                    if (!this.canApplyAt(hunkLines, newLines, applyAt - shift)) continue;
                    applies = true;
                    applyAt -= shift;
                    break;
                }
                if (!applies) {
                    applyAt = hunkHeader.getNewStartLine() - 1 + lineNumberShift;
                    maxShift = newLines.size() - applyAt - oldLinesInHunk;
                    for (shift = 1; shift <= maxShift; ++shift) {
                        if (!this.canApplyAt(hunkLines, newLines, applyAt + shift)) continue;
                        applies = true;
                        applyAt += shift;
                        break;
                    }
                }
            }
            if (!applies) {
                throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, hunkHeader));
            }
            lineNumberShift = applyAt - hunkHeader.getNewStartLine() + 1;
            int sz = hunkLines.size();
            block31: for (int j = 1; j < sz; ++j) {
                ByteBuffer hunkLine = (ByteBuffer)hunkLines.get(j);
                if (!hunkLine.hasRemaining()) {
                    ++applyAt;
                    continue;
                }
                switch (hunkLine.array()[hunkLine.position()]) {
                    case 32: {
                        ++applyAt;
                        continue block31;
                    }
                    case 45: {
                        newLines.remove(applyAt);
                        continue block31;
                    }
                    case 43: {
                        newLines.add(applyAt++, this.slice(hunkLine, 1));
                        continue block31;
                    }
                }
            }
            afterLastHunk = applyAt;
        }
        if (!this.isNoNewlineAtEndOfFile(fh)) {
            newLines.add(null);
        }
        if (!rt.isMissingNewlineAtEnd()) {
            oldLines.add(null);
        }
        if (oldLines.equals(newLines)) {
            return;
        }
        TemporaryBuffer.LocalFile buffer = new TemporaryBuffer.LocalFile(null);
        try {
            try (TemporaryBuffer.LocalFile localFile = buffer;){
                Iterator l = newLines.iterator();
                while (l.hasNext()) {
                    ByteBuffer line = (ByteBuffer)l.next();
                    if (line == null) {
                        break;
                    }
                    ((OutputStream)localFile).write(line.array(), line.position(), line.remaining());
                    if (!l.hasNext()) continue;
                    ((OutputStream)localFile).write(10);
                }
            }
            var14_17 = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(f);){
                DirCacheCheckout.getContent(repository, path, checkOut, new StreamLoader(buffer::openInputStream, ((TemporaryBuffer)buffer).length()), null, fileOutputStream);
            }
            catch (Throwable throwable) {
                var14_17 = throwable;
                throw throwable;
            }
        }
        finally {
            ((TemporaryBuffer)buffer).destroy();
        }
        repository.getFS().setExecute(f, fh.getNewMode() == FileMode.EXECUTABLE_FILE);
    }

    private boolean canApplyAt(List<ByteBuffer> hunkLines, List<ByteBuffer> newLines, int line) {
        int sz = hunkLines.size();
        int limit = newLines.size();
        int pos = line;
        block3: for (int j = 1; j < sz; ++j) {
            ByteBuffer hunkLine = hunkLines.get(j);
            if (!hunkLine.hasRemaining()) {
                if (pos >= limit || newLines.get(pos).hasRemaining()) {
                    return false;
                }
                ++pos;
                continue;
            }
            switch (hunkLine.array()[hunkLine.position()]) {
                case 32: 
                case 45: {
                    if (pos >= limit || !newLines.get(pos).equals(this.slice(hunkLine, 1))) {
                        return false;
                    }
                    ++pos;
                    continue block3;
                }
            }
        }
        return true;
    }

    private ByteBuffer slice(ByteBuffer b, int off) {
        int newOffset = b.position() + off;
        return ByteBuffer.wrap(b.array(), newOffset, b.limit() - newOffset);
    }

    private boolean isNoNewlineAtEndOfFile(FileHeader fh) {
        List<? extends HunkHeader> hunks = fh.getHunks();
        if (hunks == null || hunks.isEmpty()) {
            return false;
        }
        HunkHeader lastHunk = hunks.get(hunks.size() - 1);
        byte[] buf = new byte[lastHunk.getEndOffset() - lastHunk.getStartOffset()];
        System.arraycopy(lastHunk.getBuffer(), lastHunk.getStartOffset(), buf, 0, buf.length);
        RawText lhrt = new RawText(buf);
        return lhrt.getString(lhrt.size() - 1).equals("\\ No newline at end of file");
    }

    private static /* synthetic */ InputStream lambda$applyBinary$2(SHA1InputStream hashed) throws IOException {
        return hashed;
    }

    private static /* synthetic */ InputStream lambda$applyBinary$1(InputStream inflated) throws IOException {
        return inflated;
    }

    private static class SHA1InputStream
    extends InputStream {
        private final SHA1 hash;
        private final InputStream in;

        SHA1InputStream(SHA1 hash, InputStream in) {
            this.hash = hash;
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            int b = this.in.read();
            if (b >= 0) {
                this.hash.update((byte)b);
            }
            return b;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.in.read(b, off, len);
            if (n > 0) {
                this.hash.update(b, off, n);
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }

    private static class StreamLoader
    extends ObjectLoader {
        private StreamSupplier data;
        private long size;

        StreamLoader(StreamSupplier data, long length) {
            this.data = data;
            this.size = length;
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public boolean isLarge() {
            return true;
        }

        @Override
        public byte[] getCachedBytes() throws LargeObjectException {
            throw new LargeObjectException();
        }

        @Override
        public ObjectStream openStream() throws MissingObjectException, IOException {
            return new ObjectStream.Filter(this.getType(), this.getSize(), new BufferedInputStream(this.data.load()));
        }
    }

    private static interface StreamSupplier {
        public InputStream load() throws IOException;
    }
}

