/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.util.io;

import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.util.Base85;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.text.MessageFormat;

public class BinaryHunkInputStream
extends InputStream {
    private final InputStream in;
    private int lineNumber;
    private byte[] buffer;
    private int pos = 0;

    public BinaryHunkInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        if (this.pos < 0) {
            return -1;
        }
        if (this.buffer == null || this.pos == this.buffer.length) {
            this.fillBuffer();
        }
        if (this.pos >= 0) {
            return this.buffer[this.pos++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return super.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.buffer = null;
    }

    private void fillBuffer() throws IOException {
        int length = this.in.read();
        if (length < 0) {
            this.pos = length;
            this.buffer = null;
            return;
        }
        ++this.lineNumber;
        if (65 <= length && length <= 90) {
            length = length - 65 + 1;
        } else if (97 <= length && length <= 122) {
            length = length - 97 + 27;
        } else {
            throw new StreamCorruptedException(MessageFormat.format(JGitText.get().binaryHunkInvalidLength, this.lineNumber, Integer.toHexString(length)));
        }
        byte[] encoded = new byte[Base85.encodedLength(length)];
        for (int i = 0; i < encoded.length; ++i) {
            int b = this.in.read();
            if (b < 0 || b == 10) {
                throw new EOFException(MessageFormat.format(JGitText.get().binaryHunkInvalidLength, this.lineNumber));
            }
            encoded[i] = (byte)b;
        }
        int b = this.in.read();
        if (b >= 0 && b != 10) {
            throw new StreamCorruptedException(MessageFormat.format(JGitText.get().binaryHunkMissingNewline, this.lineNumber));
        }
        try {
            this.buffer = Base85.decode(encoded, length);
        }
        catch (IllegalArgumentException e) {
            StreamCorruptedException ex = new StreamCorruptedException(MessageFormat.format(JGitText.get().binaryHunkDecodeError, this.lineNumber));
            ex.initCause(e);
            throw ex;
        }
        this.pos = 0;
    }
}

