/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.ignore.internal;

import com.jxdinfo.hussar.formdesign.jgit.ignore.internal.AbstractMatcher;
import com.jxdinfo.hussar.formdesign.jgit.ignore.internal.Strings;

public class NameMatcher
extends AbstractMatcher {
    final boolean beginning;
    final char slash;
    final String subPattern;

    NameMatcher(String pattern, Character pathSeparator, boolean dirOnly, boolean deleteBackslash) {
        super(pattern, dirOnly);
        this.slash = Strings.getPathSeparator(pathSeparator);
        if (deleteBackslash) {
            pattern = Strings.deleteBackslash(pattern);
        }
        this.beginning = pattern.length() == 0 ? false : pattern.charAt(0) == this.slash;
        this.subPattern = !this.beginning ? pattern : pattern.substring(1);
    }

    @Override
    public boolean matches(String path, boolean assumeDirectory, boolean pathMatch) {
        int start = 0;
        int stop = path.length();
        if (stop > 0 && path.charAt(0) == this.slash) {
            ++start;
        }
        if (pathMatch) {
            boolean match;
            int lastSlash = path.lastIndexOf(this.slash, stop - 1);
            if (lastSlash == stop - 1) {
                lastSlash = path.lastIndexOf(this.slash, lastSlash - 1);
                --stop;
            }
            if (lastSlash < start) {
                match = this.matches(path, start, stop);
            } else {
                boolean bl = match = !this.beginning && this.matches(path, lastSlash + 1, stop);
            }
            if (match && this.dirOnly) {
                match = assumeDirectory;
            }
            return match;
        }
        while (start < stop) {
            int end = path.indexOf(this.slash, start);
            if (end < 0) {
                end = stop;
            }
            if (end > start && this.matches(path, start, end)) {
                return !this.dirOnly || assumeDirectory || end < stop;
            }
            if (this.beginning) break;
            start = end + 1;
        }
        return false;
    }

    @Override
    public boolean matches(String segment, int startIncl, int endExcl) {
        String s = this.subPattern;
        int length = s.length();
        if (length != endExcl - startIncl) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char c2;
            char c1 = s.charAt(i);
            if (c1 == (c2 = segment.charAt(i + startIncl))) continue;
            return false;
        }
        return true;
    }
}

