/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.lib;

import com.jxdinfo.hussar.formdesign.jgit.lib.BatchingProgressMonitor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class TextProgressMonitor
extends BatchingProgressMonitor {
    private final Writer out;
    private boolean write;

    public TextProgressMonitor() {
        this(new PrintWriter(new OutputStreamWriter((OutputStream)System.err, StandardCharsets.UTF_8)));
    }

    public TextProgressMonitor(Writer out) {
        this.out = out;
        this.write = true;
    }

    @Override
    protected void onUpdate(String taskName, int workCurr) {
        StringBuilder s = new StringBuilder();
        this.format(s, taskName, workCurr);
        this.send(s);
    }

    @Override
    protected void onEndTask(String taskName, int workCurr) {
        StringBuilder s = new StringBuilder();
        this.format(s, taskName, workCurr);
        s.append("\n");
        this.send(s);
    }

    private void format(StringBuilder s, String taskName, int workCurr) {
        s.append("\r");
        s.append(taskName);
        s.append(": ");
        while (s.length() < 25) {
            s.append(' ');
        }
        s.append(workCurr);
    }

    @Override
    protected void onUpdate(String taskName, int cmp, int totalWork, int pcnt) {
        StringBuilder s = new StringBuilder();
        this.format(s, taskName, cmp, totalWork, pcnt);
        this.send(s);
    }

    @Override
    protected void onEndTask(String taskName, int cmp, int totalWork, int pcnt) {
        StringBuilder s = new StringBuilder();
        this.format(s, taskName, cmp, totalWork, pcnt);
        s.append("\n");
        this.send(s);
    }

    private void format(StringBuilder s, String taskName, int cmp, int totalWork, int pcnt) {
        s.append("\r");
        s.append(taskName);
        s.append(": ");
        while (s.length() < 25) {
            s.append(' ');
        }
        String endStr = String.valueOf(totalWork);
        String curStr = String.valueOf(cmp);
        while (curStr.length() < endStr.length()) {
            curStr = " " + curStr;
        }
        if (pcnt < 100) {
            s.append(' ');
        }
        if (pcnt < 10) {
            s.append(' ');
        }
        s.append(pcnt);
        s.append("% (");
        s.append(curStr);
        s.append("/");
        s.append(endStr);
        s.append(")");
    }

    private void send(StringBuilder s) {
        if (this.write) {
            try {
                this.out.write(s.toString());
                this.out.flush();
            }
            catch (IOException err) {
                this.write = false;
            }
        }
    }
}

