/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.internal.transport.parser;

import com.jxdinfo.hussar.formdesign.jgit.annotations.Nullable;
import com.jxdinfo.hussar.formdesign.jgit.errors.PackProtocolException;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class FirstWant {
    private final String line;
    private final Set<String> capabilities;
    @Nullable
    private final String agent;
    private static final String AGENT_PREFIX = "agent=";

    public static FirstWant fromLine(String line) throws PackProtocolException {
        Set<String> capabilities;
        String wantLine;
        String agent = null;
        if (line.length() > 45) {
            String opt = line.substring(45);
            if (!opt.startsWith(" ")) {
                throw new PackProtocolException(JGitText.get().wantNoSpaceWithCapabilities);
            }
            opt = opt.substring(1);
            HashSet<String> opts = new HashSet<String>();
            for (String clientCapability : opt.split(" ")) {
                if (clientCapability.startsWith(AGENT_PREFIX)) {
                    agent = clientCapability.substring(AGENT_PREFIX.length());
                    continue;
                }
                opts.add(clientCapability);
            }
            wantLine = line.substring(0, 45);
            capabilities = Collections.unmodifiableSet(opts);
        } else {
            wantLine = line;
            capabilities = Collections.emptySet();
        }
        return new FirstWant(wantLine, capabilities, agent);
    }

    private FirstWant(String line, Set<String> capabilities, @Nullable String agent) {
        this.line = line;
        this.capabilities = capabilities;
        this.agent = agent;
    }

    public String getLine() {
        return this.line;
    }

    public Set<String> getCapabilities() {
        return this.capabilities;
    }

    @Nullable
    public String getAgent() {
        return this.agent;
    }
}

