/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.internal.storage.file;

import com.jxdinfo.hussar.formdesign.jgit.annotations.Nullable;
import com.jxdinfo.hussar.formdesign.jgit.errors.IncorrectObjectTypeException;
import com.jxdinfo.hussar.formdesign.jgit.errors.MissingObjectException;
import com.jxdinfo.hussar.formdesign.jgit.errors.StoredObjectRepresentationNotAvailableException;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.BitmapIndexImpl;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.ByteArrayWindow;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.ByteWindow;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.DeltaBaseCache;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.FileObjectDatabase;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.LocalCachedPack;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.LocalObjectToPack;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.ObjectDirectoryInserter;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.Pack;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.PackBitmapIndex;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.WindowCache;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.pack.CachedPack;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.pack.ObjectReuseAsIs;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.pack.ObjectToPack;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.pack.PackOutputStream;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.pack.PackWriter;
import com.jxdinfo.hussar.formdesign.jgit.lib.AbbreviatedObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.AnyObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.BitmapIndex;
import com.jxdinfo.hussar.formdesign.jgit.lib.InflaterCache;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectInserter;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectLoader;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectReader;
import com.jxdinfo.hussar.formdesign.jgit.lib.ProgressMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

final class WindowCursor
extends ObjectReader
implements ObjectReuseAsIs {
    final byte[] tempId = new byte[20];
    private Inflater inf;
    private ByteWindow window;
    private DeltaBaseCache baseCache;
    @Nullable
    private final ObjectInserter createdFromInserter;
    final FileObjectDatabase db;

    WindowCursor(FileObjectDatabase db) {
        this.db = db;
        this.createdFromInserter = null;
        this.streamFileThreshold = WindowCache.getStreamFileThreshold();
    }

    WindowCursor(FileObjectDatabase db, @Nullable ObjectDirectoryInserter createdFromInserter) {
        this.db = db;
        this.createdFromInserter = createdFromInserter;
        this.streamFileThreshold = WindowCache.getStreamFileThreshold();
    }

    DeltaBaseCache getDeltaBaseCache() {
        if (this.baseCache == null) {
            this.baseCache = new DeltaBaseCache();
        }
        return this.baseCache;
    }

    @Override
    public ObjectReader newReader() {
        return new WindowCursor(this.db);
    }

    @Override
    public BitmapIndex getBitmapIndex() throws IOException {
        for (Pack pack : this.db.getPacks()) {
            PackBitmapIndex index = pack.getBitmapIndex();
            if (index == null) continue;
            return new BitmapIndexImpl(index);
        }
        return null;
    }

    @Override
    public Collection<CachedPack> getCachedPacksAndUpdate(BitmapIndex.BitmapBuilder needBitmap) throws IOException {
        for (Pack pack : this.db.getPacks()) {
            PackBitmapIndex index = pack.getBitmapIndex();
            if (!needBitmap.removeAllOrNone(index)) continue;
            return Collections.singletonList(new LocalCachedPack(Collections.singletonList(pack)));
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<ObjectId> resolve(AbbreviatedObjectId id) throws IOException {
        if (id.isComplete()) {
            return Collections.singleton(id.toObjectId());
        }
        HashSet<ObjectId> matches = new HashSet<ObjectId>(4);
        this.db.resolve(matches, id);
        return matches;
    }

    @Override
    public boolean has(AnyObjectId objectId) throws IOException {
        return this.db.has(objectId);
    }

    @Override
    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectLoader ldr = this.db.openObject(this, objectId);
        if (ldr == null) {
            if (typeHint == -1) {
                throw new MissingObjectException(objectId.copy(), JGitText.get().unknownObjectType2);
            }
            throw new MissingObjectException(objectId.copy(), typeHint);
        }
        if (typeHint != -1 && ldr.getType() != typeHint) {
            throw new IncorrectObjectTypeException(objectId.copy(), typeHint);
        }
        return ldr;
    }

    @Override
    public Set<ObjectId> getShallowCommits() throws IOException {
        return this.db.getShallowCommits();
    }

    @Override
    public long getObjectSize(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        long sz = this.db.getObjectSize(this, objectId);
        if (sz < 0L) {
            if (typeHint == -1) {
                throw new MissingObjectException(objectId.copy(), JGitText.get().unknownObjectType2);
            }
            throw new MissingObjectException(objectId.copy(), typeHint);
        }
        return sz;
    }

    @Override
    public LocalObjectToPack newObjectToPack(AnyObjectId objectId, int type) {
        return new LocalObjectToPack(objectId, type);
    }

    @Override
    public void selectObjectRepresentation(PackWriter packer, ProgressMonitor monitor, Iterable<ObjectToPack> objects) throws IOException, MissingObjectException {
        for (ObjectToPack otp : objects) {
            this.db.selectObjectRepresentation(packer, otp, this);
            monitor.update(1);
        }
    }

    @Override
    public void copyObjectAsIs(PackOutputStream out, ObjectToPack otp, boolean validate) throws IOException, StoredObjectRepresentationNotAvailableException {
        LocalObjectToPack src = (LocalObjectToPack)otp;
        src.pack.copyAsIs(out, src, validate, this);
    }

    @Override
    public void writeObjects(PackOutputStream out, List<ObjectToPack> list) throws IOException {
        for (ObjectToPack otp : list) {
            out.writeObject(otp);
        }
    }

    int copy(Pack pack, long position, byte[] dstbuf, int dstoff, int cnt) throws IOException {
        int need;
        int r;
        long length = pack.length;
        for (need = cnt; need > 0 && position < length; need -= r) {
            this.pin(pack, position);
            r = this.window.copy(position, dstbuf, dstoff, need);
            position += (long)r;
            dstoff += r;
        }
        return cnt - need;
    }

    @Override
    public void copyPackAsIs(PackOutputStream out, CachedPack pack) throws IOException {
        ((LocalCachedPack)pack).copyAsIs(out, this);
    }

    void copyPackAsIs(Pack pack, long length, PackOutputStream out) throws IOException {
        int n;
        long position = 12L;
        for (long remaining = length - 32L; 0L < remaining; remaining -= (long)n) {
            this.pin(pack, position);
            int ptr = (int)(position - this.window.start);
            n = (int)Math.min((long)(this.window.size() - ptr), remaining);
            this.window.write(out, position, n);
            position += (long)n;
        }
    }

    int inflate(Pack pack, long position, byte[] dstbuf, boolean headerOnly) throws IOException, DataFormatException {
        this.prepareInflater();
        this.pin(pack, position);
        position += (long)this.window.setInput(position, this.inf);
        int dstoff = 0;
        while (true) {
            int n = this.inf.inflate(dstbuf, dstoff, dstbuf.length - dstoff);
            if (this.inf.finished() || headerOnly && (dstoff += n) == dstbuf.length) {
                return dstoff;
            }
            if (this.inf.needsInput()) {
                this.pin(pack, position);
                position += (long)this.window.setInput(position, this.inf);
                continue;
            }
            if (n == 0) break;
        }
        throw new DataFormatException();
    }

    ByteArrayWindow quickCopy(Pack p, long pos, long cnt) throws IOException {
        this.pin(p, pos);
        if (this.window instanceof ByteArrayWindow && this.window.contains(p, pos + (cnt - 1L))) {
            return (ByteArrayWindow)this.window;
        }
        return null;
    }

    Inflater inflater() {
        this.prepareInflater();
        return this.inf;
    }

    private void prepareInflater() {
        if (this.inf == null) {
            this.inf = InflaterCache.get();
        } else {
            this.inf.reset();
        }
    }

    void pin(Pack pack, long position) throws IOException {
        ByteWindow w = this.window;
        if (w == null || !w.contains(pack, position)) {
            this.window = null;
            this.window = WindowCache.get(pack, position);
        }
    }

    @Override
    @Nullable
    public ObjectInserter getCreatedFromInserter() {
        return this.createdFromInserter;
    }

    @Override
    public void close() {
        this.window = null;
        this.baseCache = null;
        try {
            InflaterCache.release(this.inf);
        }
        finally {
            this.inf = null;
        }
    }
}

