/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.api;

import com.jxdinfo.hussar.formdesign.jgit.api.GitCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.GitAPIException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.JGitInternalException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.NoFilepatternException;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCache;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheBuildIterator;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheBuilder;
import com.jxdinfo.hussar.formdesign.jgit.events.WorkingTreeModifiedEvent;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.lib.FileMode;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.TreeWalk;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.filter.PathFilterGroup;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class RmCommand
extends GitCommand<DirCache> {
    private Collection<String> filepatterns = new LinkedList<String>();
    private boolean cached = false;

    public RmCommand(Repository repo) {
        super(repo);
    }

    public RmCommand addFilepattern(String filepattern) {
        this.checkCallable();
        this.filepatterns.add(filepattern);
        return this;
    }

    public RmCommand setCached(boolean cached) {
        this.checkCallable();
        this.cached = cached;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DirCache call() throws GitAPIException, NoFilepatternException {
        if (this.filepatterns.isEmpty()) {
            throw new NoFilepatternException(JGitText.get().atLeastOnePatternIsRequired);
        }
        this.checkCallable();
        DirCache dc = null;
        ArrayList<String> actuallyDeletedFiles = new ArrayList<String>();
        try (TreeWalk tw = new TreeWalk(this.repo);){
            dc = this.repo.lockDirCache();
            DirCacheBuilder builder = dc.builder();
            tw.reset();
            tw.setRecursive(true);
            tw.setFilter(PathFilterGroup.createFromStrings(this.filepatterns));
            tw.addTree(new DirCacheBuildIterator(builder));
            while (tw.next()) {
                FileMode mode;
                if (this.cached || (mode = tw.getFileMode(0)).getObjectType() != 3) continue;
                String relativePath = tw.getPathString();
                File path = new File(this.repo.getWorkTree(), relativePath);
                if (!this.delete(path)) continue;
                actuallyDeletedFiles.add(relativePath);
            }
            builder.commit();
            this.setCallable(false);
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfRmCommand, e);
        }
        finally {
            try {
                if (dc != null) {
                    dc.unlock();
                }
            }
            finally {
                if (!actuallyDeletedFiles.isEmpty()) {
                    this.repo.fireEvent(new WorkingTreeModifiedEvent(null, actuallyDeletedFiles));
                }
            }
        }
        return dc;
    }

    private boolean delete(File p) {
        boolean deleted = false;
        while (p != null && !p.equals(this.repo.getWorkTree()) && p.delete()) {
            deleted = true;
            p = p.getParentFile();
        }
        return deleted;
    }
}

