/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.api;

import com.jxdinfo.hussar.formdesign.jgit.api.GitCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.CheckoutConflictException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.GitAPIException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.JGitInternalException;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCache;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheBuildIterator;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheBuilder;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheCheckout;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheEntry;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheIterator;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.lib.NullProgressMonitor;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ProgressMonitor;
import com.jxdinfo.hussar.formdesign.jgit.lib.Ref;
import com.jxdinfo.hussar.formdesign.jgit.lib.RefUpdate;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.lib.RepositoryState;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevCommit;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevTree;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevWalk;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.AbstractTreeIterator;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.CanonicalTreeParser;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.EmptyTreeIterator;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.TreeWalk;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.filter.PathFilterGroup;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;

public class ResetCommand
extends GitCommand<Ref> {
    private String ref = null;
    private ResetType mode;
    private Collection<String> filepaths = new LinkedList<String>();
    private boolean isReflogDisabled;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    public ResetCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Ref call() throws GitAPIException, CheckoutConflictException {
        this.checkCallable();
        try {
            RepositoryState state = this.repo.getRepositoryState();
            boolean merging = state.equals((Object)RepositoryState.MERGING) || state.equals((Object)RepositoryState.MERGING_RESOLVED);
            boolean cherryPicking = state.equals((Object)RepositoryState.CHERRY_PICKING) || state.equals((Object)RepositoryState.CHERRY_PICKING_RESOLVED);
            boolean reverting = state.equals((Object)RepositoryState.REVERTING) || state.equals((Object)RepositoryState.REVERTING_RESOLVED);
            ObjectId commitId = this.resolveRefToCommitId();
            if (this.ref != null && commitId == null) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().invalidRefName, this.ref));
            }
            RevTree commitTree = commitId != null ? this.parseCommit(commitId).getTree() : null;
            if (!this.filepaths.isEmpty()) {
                this.resetIndexForPaths(commitTree);
                this.setCallable(false);
                return this.repo.exactRef("HEAD");
            }
            if (commitId != null) {
                RefUpdate ru = this.repo.updateRef("HEAD");
                ru.setNewObjectId(commitId);
                String refName = Repository.shortenRefName(this.getRefOrHEAD());
                if (this.isReflogDisabled) {
                    ru.disableRefLog();
                } else {
                    String message = refName + ": updating " + "HEAD";
                    ru.setRefLogMessage(message, false);
                }
                if (ru.forceUpdate() == RefUpdate.Result.LOCK_FAILURE) {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotLock, ru.getName()));
                }
                ObjectId origHead = ru.getOldObjectId();
                if (origHead != null) {
                    this.repo.writeOrigHead(origHead);
                }
            }
            Ref result = this.repo.exactRef("HEAD");
            if (this.mode == null) {
                this.mode = ResetType.MIXED;
            }
            switch (this.mode) {
                case HARD: {
                    this.checkoutIndex(commitTree);
                    break;
                }
                case MIXED: {
                    this.resetIndex(commitTree);
                    break;
                }
                case SOFT: {
                    break;
                }
                case KEEP: 
                case MERGE: {
                    throw new UnsupportedOperationException();
                }
            }
            if (this.mode != ResetType.SOFT) {
                if (merging) {
                    this.resetMerge();
                } else if (cherryPicking) {
                    this.resetCherryPick();
                } else if (reverting) {
                    this.resetRevert();
                } else if (this.repo.readSquashCommitMsg() != null) {
                    this.repo.writeSquashCommitMsg(null);
                }
            }
            this.setCallable(false);
            return result;
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfResetCommand, e.getMessage()), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RevCommit parseCommit(ObjectId commitId) {
        try (RevWalk rw = new RevWalk(this.repo);){
            RevCommit revCommit = rw.parseCommit(commitId);
            return revCommit;
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotReadCommit, commitId.toString()), e);
        }
    }

    private ObjectId resolveRefToCommitId() {
        try {
            return this.repo.resolve(this.getRefOrHEAD() + "^{commit}");
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotRead, this.getRefOrHEAD()), e);
        }
    }

    public ResetCommand setRef(String ref) {
        this.ref = ref;
        return this;
    }

    public ResetCommand setMode(ResetType mode) {
        if (!this.filepaths.isEmpty()) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "[--mixed | --soft | --hard]", "<paths>..."));
        }
        this.mode = mode;
        return this;
    }

    public ResetCommand addPath(String path) {
        if (this.mode != null) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "<paths>...", "[--mixed | --soft | --hard]"));
        }
        this.filepaths.add(path);
        return this;
    }

    public ResetCommand disableRefLog(boolean disable) {
        this.isReflogDisabled = disable;
        return this;
    }

    public boolean isReflogDisabled() {
        return this.isReflogDisabled;
    }

    private String getRefOrHEAD() {
        if (this.ref != null) {
            return this.ref;
        }
        return "HEAD";
    }

    public ResetCommand setProgressMonitor(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }

    private void resetIndexForPaths(ObjectId commitTree) {
        DirCache dc = null;
        try (TreeWalk tw = new TreeWalk(this.repo);){
            dc = this.repo.lockDirCache();
            DirCacheBuilder builder = dc.builder();
            tw.addTree(new DirCacheBuildIterator(builder));
            if (commitTree != null) {
                tw.addTree(commitTree);
            } else {
                tw.addTree(new EmptyTreeIterator());
            }
            tw.setFilter(PathFilterGroup.createFromStrings(this.filepaths));
            tw.setRecursive(true);
            while (tw.next()) {
                CanonicalTreeParser tree = tw.getTree(1, CanonicalTreeParser.class);
                if (tree == null) continue;
                DirCacheEntry entry = new DirCacheEntry(tw.getRawPath());
                entry.setFileMode(tree.getEntryFileMode());
                entry.setObjectId(tree.getEntryObjectId());
                builder.add(entry);
            }
            builder.commit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (dc != null) {
                dc.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetIndex(ObjectId commitTree) throws IOException {
        DirCache dc = this.repo.lockDirCache();
        try (TreeWalk walk = new TreeWalk(this.repo);){
            DirCacheBuilder builder = dc.builder();
            if (commitTree != null) {
                walk.addTree(commitTree);
            } else {
                walk.addTree(new EmptyTreeIterator());
            }
            walk.addTree(new DirCacheIterator(dc));
            walk.setRecursive(true);
            while (walk.next()) {
                AbstractTreeIterator cIter = walk.getTree(0, AbstractTreeIterator.class);
                if (cIter == null) continue;
                DirCacheEntry entry = new DirCacheEntry(walk.getRawPath());
                entry.setFileMode(cIter.getEntryFileMode());
                entry.setObjectIdFromRaw(cIter.idBuffer(), cIter.idOffset());
                DirCacheIterator dcIter = walk.getTree(1, DirCacheIterator.class);
                if (dcIter != null && dcIter.idEqual(cIter)) {
                    DirCacheEntry indexEntry = dcIter.getDirCacheEntry();
                    entry.setLastModified(indexEntry.getLastModifiedInstant());
                    entry.setLength(indexEntry.getLength());
                }
                builder.add(entry);
            }
            builder.commit();
        }
        finally {
            dc.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkoutIndex(ObjectId commitTree) throws IOException, GitAPIException {
        DirCache dc = this.repo.lockDirCache();
        try {
            DirCacheCheckout checkout = new DirCacheCheckout(this.repo, dc, commitTree);
            checkout.setFailOnConflict(false);
            checkout.setProgressMonitor(this.monitor);
            try {
                checkout.checkout();
            }
            catch (com.jxdinfo.hussar.formdesign.jgit.errors.CheckoutConflictException cce) {
                throw new CheckoutConflictException(checkout.getConflicts(), cce);
            }
        }
        finally {
            dc.unlock();
        }
    }

    private void resetMerge() throws IOException {
        this.repo.writeMergeHeads(null);
        this.repo.writeMergeCommitMsg(null);
    }

    private void resetCherryPick() throws IOException {
        this.repo.writeCherryPickHead(null);
        this.repo.writeMergeCommitMsg(null);
    }

    private void resetRevert() throws IOException {
        this.repo.writeRevertHead(null);
        this.repo.writeMergeCommitMsg(null);
    }

    public String toString() {
        return "ResetCommand [repo=" + this.repo + ", ref=" + this.ref + ", mode=" + (Object)((Object)this.mode) + ", isReflogDisabled=" + this.isReflogDisabled + ", filepaths=" + this.filepaths + "]";
    }

    public static enum ResetType {
        SOFT,
        MIXED,
        HARD,
        MERGE,
        KEEP;

    }
}

