/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.transport;

import com.jxdinfo.hussar.formdesign.jgit.annotations.NonNull;
import com.jxdinfo.hussar.formdesign.jgit.annotations.Nullable;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.transport.FetchRequest;
import com.jxdinfo.hussar.formdesign.jgit.transport.FilterSpec;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

final class FetchV0Request
extends FetchRequest {
    FetchV0Request(@NonNull Set<ObjectId> wantIds, int depth, @NonNull Set<ObjectId> clientShallowCommits, @NonNull FilterSpec filterSpec, @NonNull Set<String> clientCapabilities, @Nullable String agent) {
        super(wantIds, depth, clientShallowCommits, filterSpec, clientCapabilities, 0, Collections.emptyList(), agent);
    }

    static final class Builder {
        int depth;
        final Set<ObjectId> wantIds = new HashSet<ObjectId>();
        final Set<ObjectId> clientShallowCommits = new HashSet<ObjectId>();
        FilterSpec filterSpec = FilterSpec.NO_FILTER;
        final Set<String> clientCaps = new HashSet<String>();
        String agent;

        Builder() {
        }

        Builder addWantId(ObjectId objectId) {
            this.wantIds.add(objectId);
            return this;
        }

        Builder setDepth(int d) {
            this.depth = d;
            return this;
        }

        Builder addClientShallowCommit(ObjectId shallowOid) {
            this.clientShallowCommits.add(shallowOid);
            return this;
        }

        Builder addClientCapabilities(Collection<String> clientCapabilities) {
            this.clientCaps.addAll(clientCapabilities);
            return this;
        }

        Builder setAgent(String clientAgent) {
            this.agent = clientAgent;
            return this;
        }

        Builder setFilterSpec(@NonNull FilterSpec filter) {
            this.filterSpec = Objects.requireNonNull(filter);
            return this;
        }

        FetchV0Request build() {
            return new FetchV0Request(this.wantIds, this.depth, this.clientShallowCommits, this.filterSpec, this.clientCaps, this.agent);
        }
    }
}

