/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.revwalk;

import com.jxdinfo.hussar.formdesign.jgit.diff.DiffConfig;
import com.jxdinfo.hussar.formdesign.jgit.diff.DiffEntry;
import com.jxdinfo.hussar.formdesign.jgit.diff.RenameDetector;
import com.jxdinfo.hussar.formdesign.jgit.errors.CorruptObjectException;
import com.jxdinfo.hussar.formdesign.jgit.errors.IncorrectObjectTypeException;
import com.jxdinfo.hussar.formdesign.jgit.errors.MissingObjectException;
import com.jxdinfo.hussar.formdesign.jgit.errors.StopWalkException;
import com.jxdinfo.hussar.formdesign.jgit.lib.AnyObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.FollowFilter;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RenameCallback;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevCommit;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevWalk;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.filter.RevFilter;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.TreeWalk;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.filter.TreeFilter;
import java.io.IOException;
import java.util.List;

public class TreeRevFilter
extends RevFilter {
    private static final int PARSED = 1;
    private static final int UNINTERESTING = 4;
    private final int rewriteFlag;
    private final TreeWalk pathFilter;

    public TreeRevFilter(RevWalk walker, TreeFilter t) {
        this(walker, t, 0);
    }

    TreeRevFilter(RevWalk walker, TreeFilter t, int rewriteFlag) {
        this.pathFilter = new TreeWalk(walker.reader);
        this.pathFilter.setFilter(t);
        this.pathFilter.setRecursive(t.shouldBeRecursive());
        this.rewriteFlag = rewriteFlag;
    }

    @Override
    public RevFilter clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean include(RevWalk walker, RevCommit c) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit[] pList = c.parents;
        int nParents = pList.length;
        TreeWalk tw = this.pathFilter;
        AnyObjectId[] trees = new ObjectId[nParents + 1];
        for (int i = 0; i < nParents; ++i) {
            RevCommit p = c.parents[i];
            if ((p.flags & 1) == 0) {
                p.parseHeaders(walker);
            }
            trees[i] = p.getTree();
        }
        trees[nParents] = c.getTree();
        tw.reset(trees);
        if (nParents == 1) {
            int chgs = 0;
            int adds = 0;
            while (tw.next()) {
                ++chgs;
                if (tw.getRawMode(0) != 0 || tw.getRawMode(1) == 0) break;
                ++adds;
            }
            if (chgs == 0) {
                c.flags |= this.rewriteFlag;
                return false;
            }
            if (adds > 0 && tw.getFilter() instanceof FollowFilter) {
                this.updateFollowFilter((ObjectId[])trees, ((FollowFilter)tw.getFilter()).cfg);
            }
            return true;
        }
        if (nParents == 0) {
            if (tw.next()) {
                return true;
            }
            c.flags |= this.rewriteFlag;
            return false;
        }
        int[] chgs = new int[nParents];
        int[] adds = new int[nParents];
        while (tw.next()) {
            int myMode = tw.getRawMode(nParents);
            for (int i = 0; i < nParents; ++i) {
                int pMode = tw.getRawMode(i);
                if (myMode == pMode && tw.idEqual(i, nParents)) continue;
                int n = i;
                chgs[n] = chgs[n] + 1;
                if (pMode != 0 || myMode == 0) continue;
                int n2 = i;
                adds[n2] = adds[n2] + 1;
            }
        }
        boolean same = false;
        boolean diff = false;
        for (int i = 0; i < nParents; ++i) {
            if (chgs[i] == 0) {
                RevCommit p = pList[i];
                if ((p.flags & 4) != 0) {
                    same = true;
                    continue;
                }
                c.flags |= this.rewriteFlag;
                c.parents = new RevCommit[]{p};
                return false;
            }
            if (chgs[i] == adds[i]) {
                tw.reset((AnyObjectId)pList[i].getTree());
                if (!tw.next()) {
                    pList[i].parents = RevCommit.NO_PARENTS;
                }
            }
            diff = true;
        }
        if (diff && !same) {
            return true;
        }
        c.flags |= this.rewriteFlag;
        return false;
    }

    @Override
    public boolean requiresCommitBody() {
        return false;
    }

    private void updateFollowFilter(ObjectId[] trees, DiffConfig cfg) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        TreeWalk tw = this.pathFilter;
        FollowFilter oldFilter = (FollowFilter)tw.getFilter();
        tw.setFilter(TreeFilter.ANY_DIFF);
        tw.reset(trees);
        List<DiffEntry> files = DiffEntry.scan(tw);
        RenameDetector rd = new RenameDetector(tw.getObjectReader(), cfg);
        rd.addAll(files);
        files = rd.compute();
        FollowFilter newFilter = oldFilter;
        for (DiffEntry ent : files) {
            if (!TreeRevFilter.isRename(ent) || !ent.getNewPath().equals(oldFilter.getPath())) continue;
            newFilter = FollowFilter.create(ent.getOldPath(), cfg);
            RenameCallback callback = oldFilter.getRenameCallback();
            if (callback == null) break;
            callback.renamed(ent);
            newFilter.setRenameCallback(callback);
            break;
        }
        tw.setFilter(newFilter);
    }

    private static boolean isRename(DiffEntry ent) {
        return ent.getChangeType() == DiffEntry.ChangeType.RENAME || ent.getChangeType() == DiffEntry.ChangeType.COPY;
    }
}

