/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.transport;

import com.jxdinfo.hussar.formdesign.jgit.errors.PackProtocolException;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.internal.transport.parser.FirstWant;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.transport.FetchV0Request;
import com.jxdinfo.hussar.formdesign.jgit.transport.FilterSpec;
import com.jxdinfo.hussar.formdesign.jgit.transport.PacketLineIn;
import com.jxdinfo.hussar.formdesign.jgit.transport.TransferConfig;
import java.io.EOFException;
import java.io.IOException;
import java.text.MessageFormat;

final class ProtocolV0Parser {
    private final TransferConfig transferConfig;

    ProtocolV0Parser(TransferConfig transferConfig) {
        this.transferConfig = transferConfig;
    }

    FetchV0Request recvWants(PacketLineIn pckIn) throws PackProtocolException, IOException {
        FetchV0Request.Builder reqBuilder = new FetchV0Request.Builder();
        boolean isFirst = true;
        boolean filterReceived = false;
        while (true) {
            String line;
            try {
                line = pckIn.readString();
            }
            catch (EOFException eof) {
                if (isFirst) break;
                throw eof;
            }
            if (PacketLineIn.isEnd(line)) break;
            if (line.startsWith("deepen ")) {
                int depth = Integer.parseInt(line.substring(7));
                if (depth <= 0) {
                    throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidDepth, depth));
                }
                reqBuilder.setDepth(depth);
                continue;
            }
            if (line.startsWith("shallow ")) {
                reqBuilder.addClientShallowCommit(ObjectId.fromString(line.substring(8)));
                continue;
            }
            if (this.transferConfig.isAllowFilter() && line.startsWith("filter ")) {
                String arg = line.substring("filter".length() + 1);
                if (filterReceived) {
                    throw new PackProtocolException(JGitText.get().tooManyFilters);
                }
                filterReceived = true;
                reqBuilder.setFilterSpec(FilterSpec.fromFilterLine(arg));
                continue;
            }
            if (!line.startsWith("want ") || line.length() < 45) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "want", line));
            }
            if (isFirst && line.length() > 45) {
                FirstWant firstLine = FirstWant.fromLine(line);
                reqBuilder.addClientCapabilities(firstLine.getCapabilities());
                reqBuilder.setAgent(firstLine.getAgent());
                line = firstLine.getLine();
            }
            reqBuilder.addWantId(ObjectId.fromString(line.substring(5)));
            isFirst = false;
        }
        return reqBuilder.build();
    }
}

