/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.transport;

import com.jxdinfo.hussar.formdesign.jgit.errors.UnsupportedCredentialItem;
import com.jxdinfo.hussar.formdesign.jgit.transport.CredentialItem;
import com.jxdinfo.hussar.formdesign.jgit.transport.CredentialsProvider;
import com.jxdinfo.hussar.formdesign.jgit.transport.URIish;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ChainingCredentialsProvider
extends CredentialsProvider {
    private List<CredentialsProvider> credentialProviders;

    public ChainingCredentialsProvider(CredentialsProvider ... providers) {
        this.credentialProviders = new ArrayList<CredentialsProvider>(Arrays.asList(providers));
    }

    @Override
    public boolean isInteractive() {
        for (CredentialsProvider p : this.credentialProviders) {
            if (!p.isInteractive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supports(CredentialItem ... items) {
        for (CredentialsProvider p : this.credentialProviders) {
            if (!p.supports(items)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        for (CredentialsProvider p : this.credentialProviders) {
            if (!p.supports(items)) continue;
            if (!p.get(uri, items)) {
                if (!p.isInteractive()) continue;
                return false;
            }
            if (ChainingCredentialsProvider.isAnyNull(items)) continue;
            return true;
        }
        return false;
    }
}

