/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.internal.storage.file;

import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.internal.storage.file.FileSnapshot;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.util.FS;
import com.jxdinfo.hussar.formdesign.jgit.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockFile {
    private static final Logger LOG = LoggerFactory.getLogger(LockFile.class);
    static final FilenameFilter FILTER = (dir, name) -> !name.endsWith(".lock");
    private final File ref;
    private final File lck;
    private boolean haveLck;
    private FileOutputStream os;
    private boolean needSnapshot;
    private boolean fsync;
    private boolean isAppend;
    private boolean written;
    private boolean snapshotNoConfig;
    private FileSnapshot commitSnapshot;
    private FS.LockToken token;

    public static boolean unlock(File file) {
        File lockFile = LockFile.getLockFile(file);
        int flags = 6;
        try {
            FileUtils.delete(lockFile, 6);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return !lockFile.exists();
    }

    static File getLockFile(File file) {
        return new File(file.getParentFile(), file.getName() + ".lock");
    }

    public LockFile(File f) {
        this.ref = f;
        this.lck = LockFile.getLockFile(this.ref);
    }

    public boolean lock() throws IOException {
        if (this.haveLck) {
            throw new IllegalStateException(MessageFormat.format(JGitText.get().lockAlreadyHeld, this.ref));
        }
        FileUtils.mkdirs(this.lck.getParentFile(), true);
        try {
            this.token = FS.DETECTED.createNewFileAtomic(this.lck);
        }
        catch (IOException e) {
            LOG.error(JGitText.get().failedCreateLockFile, (Object)this.lck, (Object)e);
            throw e;
        }
        boolean obtainedLock = this.token.isCreated();
        if (obtainedLock) {
            this.haveLck = true;
            this.isAppend = false;
            this.written = false;
        } else {
            this.closeToken();
        }
        return obtainedLock;
    }

    public boolean lockForAppend() throws IOException {
        if (!this.lock()) {
            return false;
        }
        this.copyCurrentContent();
        this.isAppend = true;
        this.written = false;
        return true;
    }

    boolean isLocked() {
        return this.haveLck;
    }

    private FileOutputStream getStream() throws IOException {
        return new FileOutputStream(this.lck, this.isAppend);
    }

    public void copyCurrentContent() throws IOException {
        this.requireLock();
        try (FileOutputStream out = this.getStream();){
            try (FileInputStream fis = new FileInputStream(this.ref);){
                if (this.fsync) {
                    long r;
                    FileChannel in = fis.getChannel();
                    long pos = 0L;
                    for (long cnt = in.size(); 0L < cnt; cnt -= r) {
                        r = out.getChannel().transferFrom(in, pos, cnt);
                        pos += r;
                    }
                } else {
                    int r;
                    byte[] buf = new byte[2048];
                    while ((r = fis.read(buf)) >= 0) {
                        out.write(buf, 0, r);
                    }
                }
            }
            catch (FileNotFoundException fnfe) {
                if (this.ref.exists()) {
                    throw fnfe;
                }
            }
        }
        catch (IOException | Error | RuntimeException ioe) {
            this.unlock();
            throw ioe;
        }
    }

    public void write(ObjectId id) throws IOException {
        byte[] buf = new byte[41];
        id.copyTo(buf, 0);
        buf[40] = 10;
        this.write(buf);
    }

    public void write(byte[] content) throws IOException {
        this.requireLock();
        try (FileOutputStream out = this.getStream();){
            if (this.written) {
                throw new IOException(MessageFormat.format(JGitText.get().lockStreamClosed, this.ref));
            }
            if (this.fsync) {
                FileChannel fc = out.getChannel();
                ByteBuffer buf = ByteBuffer.wrap(content);
                while (0 < buf.remaining()) {
                    fc.write(buf);
                }
                fc.force(true);
            } else {
                out.write(content);
            }
            this.written = true;
        }
        catch (IOException | Error | RuntimeException ioe) {
            this.unlock();
            throw ioe;
        }
    }

    public OutputStream getOutputStream() {
        this.requireLock();
        if (this.written || this.os != null) {
            throw new IllegalStateException(MessageFormat.format(JGitText.get().lockStreamMultiple, this.ref));
        }
        return new OutputStream(){
            private OutputStream out;
            private boolean closed;

            private OutputStream get() throws IOException {
                if (LockFile.this.written) {
                    throw new IOException(MessageFormat.format(JGitText.get().lockStreamMultiple, LockFile.this.ref));
                }
                if (this.out == null) {
                    LockFile.this.os = LockFile.this.getStream();
                    this.out = LockFile.this.fsync ? Channels.newOutputStream(LockFile.this.os.getChannel()) : LockFile.this.os;
                }
                return this.out;
            }

            @Override
            public void write(byte[] b, int o, int n) throws IOException {
                this.get().write(b, o, n);
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.get().write(b);
            }

            @Override
            public void write(int b) throws IOException {
                this.get().write(b);
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    if (LockFile.this.written) {
                        throw new IOException(MessageFormat.format(JGitText.get().lockStreamClosed, LockFile.this.ref));
                    }
                    if (this.out != null) {
                        if (LockFile.this.fsync) {
                            LockFile.this.os.getChannel().force(true);
                        }
                        this.out.close();
                        LockFile.this.os = null;
                    }
                    LockFile.this.written = true;
                }
                catch (IOException | Error | RuntimeException ioe) {
                    LockFile.this.unlock();
                    throw ioe;
                }
            }
        };
    }

    void requireLock() {
        if (!this.haveLck) {
            this.unlock();
            throw new IllegalStateException(MessageFormat.format(JGitText.get().lockOnNotHeld, this.ref));
        }
    }

    public void setNeedStatInformation(boolean on) {
        this.setNeedSnapshot(on);
    }

    public void setNeedSnapshot(boolean on) {
        this.needSnapshot = on;
    }

    public void setNeedSnapshotNoConfig(boolean on) {
        this.needSnapshot = on;
        this.snapshotNoConfig = on;
    }

    public void setFSync(boolean on) {
        this.fsync = on;
    }

    public void waitForStatChange() throws InterruptedException {
        FileSnapshot o = FileSnapshot.save(this.ref);
        FileSnapshot n = FileSnapshot.save(this.lck);
        long fsTimeResolution = FS.getFileStoreAttributes(this.lck.toPath()).getFsTimestampResolution().toNanos();
        while (o.equals(n)) {
            TimeUnit.NANOSECONDS.sleep(fsTimeResolution);
            try {
                Files.setLastModifiedTime(this.lck.toPath(), FileTime.from(Instant.now()));
            }
            catch (IOException e) {
                n.waitUntilNotRacy();
            }
            n = FileSnapshot.save(this.lck);
        }
    }

    public boolean commit() {
        if (this.os != null) {
            this.unlock();
            throw new IllegalStateException(MessageFormat.format(JGitText.get().lockOnNotClosed, this.ref));
        }
        this.saveStatInformation();
        try {
            FileUtils.rename(this.lck, this.ref, StandardCopyOption.ATOMIC_MOVE);
            this.haveLck = false;
            this.isAppend = false;
            this.written = false;
            this.closeToken();
            return true;
        }
        catch (IOException e) {
            this.unlock();
            return false;
        }
    }

    private void closeToken() {
        if (this.token != null) {
            this.token.close();
            this.token = null;
        }
    }

    private void saveStatInformation() {
        if (this.needSnapshot) {
            this.commitSnapshot = this.snapshotNoConfig ? FileSnapshot.saveNoConfig(this.lck) : FileSnapshot.save(this.lck);
        }
    }

    @Deprecated
    public long getCommitLastModified() {
        return this.commitSnapshot.lastModified();
    }

    public Instant getCommitLastModifiedInstant() {
        return this.commitSnapshot.lastModifiedInstant();
    }

    public FileSnapshot getCommitSnapshot() {
        return this.commitSnapshot;
    }

    public void createCommitSnapshot() {
        this.saveStatInformation();
    }

    public void unlock() {
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException e) {
                LOG.error(MessageFormat.format(JGitText.get().unlockLockFileFailed, this.lck), (Throwable)e);
            }
            this.os = null;
        }
        if (this.haveLck) {
            this.haveLck = false;
            try {
                FileUtils.delete(this.lck, 2);
            }
            catch (IOException e) {
                LOG.error(MessageFormat.format(JGitText.get().unlockLockFileFailed, this.lck), (Throwable)e);
            }
            finally {
                this.closeToken();
            }
        }
        this.isAppend = false;
        this.written = false;
    }

    public String toString() {
        return "LockFile[" + this.lck + ", haveLck=" + this.haveLck + "]";
    }
}

