/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.blame;

import com.jxdinfo.hussar.formdesign.jgit.annotations.Nullable;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.NoHeadException;
import com.jxdinfo.hussar.formdesign.jgit.blame.BlameResult;
import com.jxdinfo.hussar.formdesign.jgit.blame.Candidate;
import com.jxdinfo.hussar.formdesign.jgit.blame.Region;
import com.jxdinfo.hussar.formdesign.jgit.blame.ReverseWalk;
import com.jxdinfo.hussar.formdesign.jgit.diff.DiffAlgorithm;
import com.jxdinfo.hussar.formdesign.jgit.diff.DiffEntry;
import com.jxdinfo.hussar.formdesign.jgit.diff.EditList;
import com.jxdinfo.hussar.formdesign.jgit.diff.HistogramDiff;
import com.jxdinfo.hussar.formdesign.jgit.diff.RawText;
import com.jxdinfo.hussar.formdesign.jgit.diff.RawTextComparator;
import com.jxdinfo.hussar.formdesign.jgit.diff.RenameDetector;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCache;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheEntry;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheIterator;
import com.jxdinfo.hussar.formdesign.jgit.errors.NoWorkTreeException;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.lib.AnyObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.MutableObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectLoader;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectReader;
import com.jxdinfo.hussar.formdesign.jgit.lib.PersonIdent;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevCommit;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevFlag;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevWalk;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.FileTreeIterator;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.TreeWalk;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.filter.PathFilter;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.filter.TreeFilter;
import com.jxdinfo.hussar.formdesign.jgit.util.IO;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class BlameGenerator
implements AutoCloseable {
    private final Repository repository;
    private final PathFilter resultPath;
    private final MutableObjectId idBuf;
    private RevWalk revPool;
    private RevFlag SEEN;
    private ObjectReader reader;
    private TreeWalk treeWalk;
    private DiffAlgorithm diffAlgorithm = new HistogramDiff();
    private RawTextComparator textComparator = RawTextComparator.DEFAULT;
    private RenameDetector renameDetector;
    private Candidate queue;
    private int remaining;
    private Candidate outCandidate;
    private Region outRegion;

    public BlameGenerator(Repository repository, String path) {
        this.repository = repository;
        this.resultPath = PathFilter.create(path);
        this.idBuf = new MutableObjectId();
        this.setFollowFileRenames(true);
        this.initRevPool(false);
        this.remaining = -1;
    }

    private void initRevPool(boolean reverse) {
        if (this.queue != null) {
            throw new IllegalStateException();
        }
        if (this.revPool != null) {
            this.revPool.close();
        }
        this.revPool = reverse ? new ReverseWalk(this.getRepository()) : new RevWalk(this.getRepository());
        this.SEEN = this.revPool.newFlag("SEEN");
        this.reader = this.revPool.getObjectReader();
        this.treeWalk = new TreeWalk(this.reader);
        this.treeWalk.setRecursive(true);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getResultPath() {
        return this.resultPath.getPath();
    }

    public BlameGenerator setDiffAlgorithm(DiffAlgorithm algorithm) {
        this.diffAlgorithm = algorithm;
        return this;
    }

    public BlameGenerator setTextComparator(RawTextComparator comparator) {
        this.textComparator = comparator;
        return this;
    }

    public BlameGenerator setFollowFileRenames(boolean follow) {
        this.renameDetector = follow ? new RenameDetector(this.getRepository()) : null;
        return this;
    }

    @Nullable
    public RenameDetector getRenameDetector() {
        return this.renameDetector;
    }

    public BlameGenerator push(String description, byte[] contents) throws IOException {
        return this.push(description, new RawText(contents));
    }

    public BlameGenerator push(String description, RawText contents) throws IOException {
        if (description == null) {
            description = JGitText.get().blameNotCommittedYet;
        }
        Candidate.BlobCandidate c = new Candidate.BlobCandidate(this.getRepository(), description, this.resultPath);
        c.sourceText = contents;
        c.regionList = new Region(0, 0, contents.size());
        this.remaining = contents.size();
        this.push(c);
        return this;
    }

    public BlameGenerator prepareHead() throws NoHeadException, IOException {
        Repository repo = this.getRepository();
        ObjectId head = repo.resolve("HEAD");
        if (head == null) {
            throw new NoHeadException(MessageFormat.format(JGitText.get().noSuchRefKnown, "HEAD"));
        }
        if (repo.isBare()) {
            return this.push(null, head);
        }
        DirCache dc = repo.readDirCache();
        try (TreeWalk walk = new TreeWalk(repo);){
            RawText inTree;
            walk.setOperationType(TreeWalk.OperationType.CHECKIN_OP);
            FileTreeIterator iter = new FileTreeIterator(repo);
            int fileTree = walk.addTree(iter);
            int indexTree = walk.addTree(new DirCacheIterator(dc));
            iter.setDirCacheIterator(walk, indexTree);
            walk.setFilter(this.resultPath);
            walk.setRecursive(true);
            if (!walk.next()) {
                BlameGenerator blameGenerator = this;
                return blameGenerator;
            }
            DirCacheIterator dcIter = walk.getTree(indexTree, DirCacheIterator.class);
            if (dcIter == null) {
                BlameGenerator blameGenerator = this;
                return blameGenerator;
            }
            iter = walk.getTree(fileTree, FileTreeIterator.class);
            if (iter == null || !BlameGenerator.isFile(iter.getEntryRawMode())) {
                BlameGenerator blameGenerator = this;
                return blameGenerator;
            }
            long filteredLength = iter.getEntryContentLength();
            try (InputStream stream = iter.openEntryStream();){
                inTree = new RawText(BlameGenerator.getBytes(iter.getEntryFile().getPath(), stream, filteredLength));
            }
            DirCacheEntry indexEntry = dcIter.getDirCacheEntry();
            if (indexEntry.getStage() == 0) {
                this.push(null, head);
                this.push(null, indexEntry.getObjectId());
                this.push(null, inTree);
            } else {
                Candidate.HeadCandidate c = new Candidate.HeadCandidate(this.getRepository(), this.resultPath, this.getHeads(repo, head));
                c.sourceText = inTree;
                c.regionList = new Region(0, 0, inTree.size());
                this.remaining = inTree.size();
                this.push(c);
            }
        }
        return this;
    }

    private List<RevCommit> getHeads(Repository repo, ObjectId head) throws NoWorkTreeException, IOException {
        List<ObjectId> mergeIds = repo.readMergeHeads();
        if (mergeIds == null || mergeIds.isEmpty()) {
            return Collections.singletonList(this.revPool.parseCommit(head));
        }
        ArrayList<RevCommit> heads = new ArrayList<RevCommit>(mergeIds.size() + 1);
        heads.add(this.revPool.parseCommit(head));
        for (ObjectId id : mergeIds) {
            heads.add(this.revPool.parseCommit(id));
        }
        return heads;
    }

    private static byte[] getBytes(String path, InputStream in, long maxLength) throws IOException {
        if (maxLength > Integer.MAX_VALUE) {
            throw new IOException(MessageFormat.format(JGitText.get().fileIsTooLarge, path));
        }
        int max = (int)maxLength;
        byte[] buffer = new byte[max];
        int read = IO.readFully(in, buffer, 0);
        if (read == max) {
            return buffer;
        }
        byte[] copy = new byte[read];
        System.arraycopy(buffer, 0, copy, 0, read);
        return copy;
    }

    public BlameGenerator push(String description, AnyObjectId id) throws IOException {
        ObjectLoader ldr = this.reader.open(id);
        if (ldr.getType() == 3) {
            if (description == null) {
                description = JGitText.get().blameNotCommittedYet;
            }
            Candidate.BlobCandidate c = new Candidate.BlobCandidate(this.getRepository(), description, this.resultPath);
            c.sourceBlob = id.toObjectId();
            c.sourceText = new RawText(ldr.getCachedBytes(Integer.MAX_VALUE));
            c.regionList = new Region(0, 0, c.sourceText.size());
            this.remaining = c.sourceText.size();
            this.push(c);
            return this;
        }
        RevCommit commit = this.revPool.parseCommit(id);
        if (!this.find(commit, this.resultPath)) {
            return this;
        }
        Candidate c = new Candidate(this.getRepository(), commit, this.resultPath);
        c.sourceBlob = this.idBuf.toObjectId();
        c.loadText(this.reader);
        c.regionList = new Region(0, 0, c.sourceText.size());
        this.remaining = c.sourceText.size();
        this.push(c);
        return this;
    }

    public BlameGenerator reverse(AnyObjectId start, AnyObjectId end) throws IOException {
        return this.reverse(start, Collections.singleton(end.toObjectId()));
    }

    public BlameGenerator reverse(AnyObjectId start, Collection<? extends ObjectId> end) throws IOException {
        this.initRevPool(true);
        ReverseWalk.ReverseCommit result = (ReverseWalk.ReverseCommit)this.revPool.parseCommit(start);
        if (!this.find(result, this.resultPath)) {
            return this;
        }
        this.revPool.markUninteresting(result);
        for (ObjectId objectId : end) {
            this.revPool.markStart(this.revPool.parseCommit(objectId));
        }
        while (this.revPool.next() != null) {
        }
        Candidate.ReverseCandidate c = new Candidate.ReverseCandidate(this.getRepository(), result, this.resultPath);
        c.sourceBlob = this.idBuf.toObjectId();
        c.loadText(this.reader);
        c.regionList = new Region(0, 0, c.sourceText.size());
        this.remaining = c.sourceText.size();
        this.push(c);
        return this;
    }

    public RevFlag newFlag(String name) {
        return this.revPool.newFlag(name);
    }

    public BlameResult computeBlameResult() throws IOException {
        try {
            BlameResult r = BlameResult.create(this);
            if (r != null) {
                r.computeAll();
            }
            BlameResult blameResult = r;
            return blameResult;
        }
        finally {
            this.close();
        }
    }

    public boolean next() throws IOException {
        Candidate n;
        if (this.outRegion != null) {
            Region r = this.outRegion;
            this.remaining -= r.length;
            if (r.next != null) {
                this.outRegion = r.next;
                return true;
            }
            if (this.outCandidate.queueNext != null) {
                return this.result(this.outCandidate.queueNext);
            }
            this.outCandidate = null;
            this.outRegion = null;
        }
        if (this.remaining == 0) {
            return this.done();
        }
        while (true) {
            if ((n = this.pop()) == null) {
                return this.done();
            }
            int pCnt = n.getParentCount();
            if (pCnt == 1) {
                if (!this.processOne(n)) continue;
                return true;
            }
            if (1 < pCnt) {
                if (!this.processMerge(n)) continue;
                return true;
            }
            if (!(n instanceof Candidate.ReverseCandidate)) break;
        }
        return this.result(n);
    }

    private boolean done() {
        this.close();
        return false;
    }

    private boolean result(Candidate n) throws IOException {
        n.beginResult(this.revPool);
        this.outCandidate = n;
        this.outRegion = n.regionList;
        return this.outRegion != null;
    }

    private boolean reverseResult(Candidate parent, Candidate source) throws IOException {
        Candidate res = parent.copy(parent.sourceCommit);
        res.regionList = source.regionList;
        return this.result(res);
    }

    private Candidate pop() {
        Candidate n = this.queue;
        if (n != null) {
            this.queue = n.queueNext;
            n.queueNext = null;
        }
        return n;
    }

    private void push(Candidate.BlobCandidate toInsert) {
        Candidate c = this.queue;
        if (c != null) {
            c.remove(this.SEEN);
            c.regionList = null;
            toInsert.parent = c;
        }
        this.queue = toInsert;
    }

    private void push(Candidate toInsert) {
        if (toInsert.has(this.SEEN)) {
            Candidate p = this.queue;
            while (p != null) {
                if (p.canMergeRegions(toInsert)) {
                    p.mergeRegions(toInsert);
                    return;
                }
                p = p.queueNext;
            }
        }
        toInsert.add(this.SEEN);
        int time = toInsert.getTime();
        Candidate n = this.queue;
        if (n == null || time >= n.getTime()) {
            toInsert.queueNext = n;
            this.queue = toInsert;
            return;
        }
        Candidate p = n;
        while (true) {
            if ((n = p.queueNext) == null || time >= n.getTime()) {
                toInsert.queueNext = n;
                p.queueNext = toInsert;
                return;
            }
            p = n;
        }
    }

    private boolean processOne(Candidate n) throws IOException {
        RevCommit parent = n.getParent(0);
        if (parent == null) {
            return this.split(n.getNextCandidate(0), n);
        }
        this.revPool.parseHeaders(parent);
        if (this.find(parent, n.sourcePath)) {
            if (this.idBuf.equals(n.sourceBlob)) {
                return this.blameEntireRegionOnParent(n, parent);
            }
            return this.splitBlameWithParent(n, parent);
        }
        if (n.sourceCommit == null) {
            return this.result(n);
        }
        DiffEntry r = this.findRename(parent, n.sourceCommit, n.sourcePath);
        if (r == null) {
            return this.result(n);
        }
        if (0 == r.getOldId().prefixCompare(n.sourceBlob)) {
            n.sourceCommit = parent;
            n.sourcePath = PathFilter.create(r.getOldPath());
            this.push(n);
            return false;
        }
        Candidate next = n.create(this.getRepository(), parent, PathFilter.create(r.getOldPath()));
        next.sourceBlob = r.getOldId().toObjectId();
        next.renameScore = r.getScore();
        next.loadText(this.reader);
        return this.split(next, n);
    }

    private boolean blameEntireRegionOnParent(Candidate n, RevCommit parent) {
        n.sourceCommit = parent;
        this.push(n);
        return false;
    }

    private boolean splitBlameWithParent(Candidate n, RevCommit parent) throws IOException {
        Candidate next = n.create(this.getRepository(), parent, n.sourcePath);
        next.sourceBlob = this.idBuf.toObjectId();
        next.loadText(this.reader);
        return this.split(next, n);
    }

    private boolean split(Candidate parent, Candidate source) throws IOException {
        EditList editList = this.diffAlgorithm.diff(this.textComparator, parent.sourceText, source.sourceText);
        if (editList.isEmpty()) {
            parent.regionList = source.regionList;
            this.push(parent);
            return false;
        }
        parent.takeBlame(editList, source);
        if (parent.regionList != null) {
            this.push(parent);
        }
        if (source.regionList != null) {
            if (source instanceof Candidate.ReverseCandidate) {
                return this.reverseResult(parent, source);
            }
            return this.result(source);
        }
        return false;
    }

    private boolean processMerge(Candidate n) throws IOException {
        Object r;
        int pIdx;
        int pCnt = n.getParentCount();
        ObjectId[] ids = null;
        for (int pIdx2 = 0; pIdx2 < pCnt; ++pIdx2) {
            RevCommit parent = n.getParent(pIdx2);
            this.revPool.parseHeaders(parent);
            if (!this.find(parent, n.sourcePath)) continue;
            if (!(n instanceof Candidate.ReverseCandidate) && this.idBuf.equals(n.sourceBlob)) {
                return this.blameEntireRegionOnParent(n, parent);
            }
            if (ids == null) {
                ids = new ObjectId[pCnt];
            }
            ids[pIdx2] = this.idBuf.toObjectId();
        }
        DiffEntry[] renames = null;
        if (this.renameDetector != null) {
            renames = new DiffEntry[pCnt];
            for (int pIdx3 = 0; pIdx3 < pCnt; ++pIdx3) {
                DiffEntry r2;
                RevCommit parent = n.getParent(pIdx3);
                if (ids != null && ids[pIdx3] != null || (r2 = this.findRename(parent, n.sourceCommit, n.sourcePath)) == null) continue;
                if (n instanceof Candidate.ReverseCandidate) {
                    if (ids == null) {
                        ids = new ObjectId[pCnt];
                    }
                    ids[pCnt] = r2.getOldId().toObjectId();
                } else if (0 == r2.getOldId().prefixCompare(n.sourceBlob)) {
                    n.sourcePath = PathFilter.create(r2.getOldPath());
                    return this.blameEntireRegionOnParent(n, parent);
                }
                renames[pIdx3] = r2;
            }
        }
        Candidate[] parents = new Candidate[pCnt];
        for (pIdx = 0; pIdx < pCnt; ++pIdx) {
            EditList editList;
            Candidate p;
            RevCommit parent = n.getParent(pIdx);
            if (renames != null && renames[pIdx] != null) {
                p = n.create(this.getRepository(), parent, PathFilter.create(renames[pIdx].getOldPath()));
                p.renameScore = renames[pIdx].getScore();
                p.sourceBlob = renames[pIdx].getOldId().toObjectId();
            } else {
                if (ids == null || ids[pIdx] == null) continue;
                p = n.create(this.getRepository(), parent, n.sourcePath);
                p.sourceBlob = ids[pIdx];
            }
            if (n instanceof Candidate.ReverseCandidate && p.sourceBlob.equals(n.sourceBlob)) {
                p.sourceText = n.sourceText;
                editList = new EditList(0);
            } else {
                p.loadText(this.reader);
                editList = this.diffAlgorithm.diff(this.textComparator, p.sourceText, n.sourceText);
            }
            if (editList.isEmpty()) {
                if (n instanceof Candidate.ReverseCandidate) {
                    parents[pIdx] = p;
                    continue;
                }
                p.regionList = n.regionList;
                n.regionList = null;
                parents[pIdx] = p;
                break;
            }
            p.takeBlame(editList, n);
            if (p.regionList == null) continue;
            if (n instanceof Candidate.ReverseCandidate) {
                r = p.regionList;
                p.regionList = n.regionList;
                n.regionList = r;
            }
            parents[pIdx] = p;
        }
        if (n instanceof Candidate.ReverseCandidate) {
            Candidate resultHead = null;
            Candidate resultTail = null;
            for (int pIdx4 = 0; pIdx4 < pCnt; ++pIdx4) {
                Candidate p = parents[pIdx4];
                if (p == null) continue;
                if (p.regionList != null) {
                    r = p.copy(p.sourceCommit);
                    if (resultTail != null) {
                        resultTail.queueNext = r;
                        resultTail = r;
                    } else {
                        resultHead = r;
                        resultTail = r;
                    }
                }
                if (n.regionList == null) continue;
                p.regionList = n.regionList.deepCopy();
                this.push(p);
            }
            if (resultHead != null) {
                return this.result(resultHead);
            }
            return false;
        }
        for (pIdx = 0; pIdx < pCnt; ++pIdx) {
            if (parents[pIdx] == null) continue;
            this.push(parents[pIdx]);
        }
        if (n.regionList != null) {
            return this.result(n);
        }
        return false;
    }

    public RevCommit getSourceCommit() {
        return this.outCandidate.sourceCommit;
    }

    public PersonIdent getSourceAuthor() {
        return this.outCandidate.getAuthor();
    }

    public PersonIdent getSourceCommitter() {
        RevCommit c = this.getSourceCommit();
        return c != null ? c.getCommitterIdent() : null;
    }

    public String getSourcePath() {
        return this.outCandidate.sourcePath.getPath();
    }

    public int getRenameScore() {
        return this.outCandidate.renameScore;
    }

    public int getSourceStart() {
        return this.outRegion.sourceStart;
    }

    public int getSourceEnd() {
        Region r = this.outRegion;
        return r.sourceStart + r.length;
    }

    public int getResultStart() {
        return this.outRegion.resultStart;
    }

    public int getResultEnd() {
        Region r = this.outRegion;
        return r.resultStart + r.length;
    }

    public int getRegionLength() {
        return this.outRegion.length;
    }

    public RawText getSourceContents() {
        return this.outCandidate.sourceText;
    }

    public RawText getResultContents() throws IOException {
        return this.queue != null ? this.queue.sourceText : null;
    }

    @Override
    public void close() {
        this.revPool.close();
        this.queue = null;
        this.outCandidate = null;
        this.outRegion = null;
    }

    private boolean find(RevCommit commit, PathFilter path) throws IOException {
        this.treeWalk.setFilter(path);
        this.treeWalk.reset((AnyObjectId)commit.getTree());
        if (this.treeWalk.next() && BlameGenerator.isFile(this.treeWalk.getRawMode(0))) {
            this.treeWalk.getObjectId(this.idBuf, 0);
            return true;
        }
        return false;
    }

    private static final boolean isFile(int rawMode) {
        return (rawMode & 0xF000) == 32768;
    }

    private DiffEntry findRename(RevCommit parent, RevCommit commit, PathFilter path) throws IOException {
        if (this.renameDetector == null) {
            return null;
        }
        this.treeWalk.setFilter(TreeFilter.ANY_DIFF);
        this.treeWalk.reset(parent.getTree(), commit.getTree());
        this.renameDetector.reset();
        this.renameDetector.addAll(DiffEntry.scan(this.treeWalk));
        for (DiffEntry ent : this.renameDetector.compute()) {
            if (!BlameGenerator.isRename(ent) || !ent.getNewPath().equals(path.getPath())) continue;
            return ent;
        }
        return null;
    }

    private static boolean isRename(DiffEntry ent) {
        return ent.getChangeType() == DiffEntry.ChangeType.RENAME || ent.getChangeType() == DiffEntry.ChangeType.COPY;
    }
}

