/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.api;

import com.jxdinfo.hussar.formdesign.jgit.annotations.Nullable;
import com.jxdinfo.hussar.formdesign.jgit.api.FetchCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.MergeCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.MergeResult;
import com.jxdinfo.hussar.formdesign.jgit.api.PullResult;
import com.jxdinfo.hussar.formdesign.jgit.api.RebaseCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.RebaseResult;
import com.jxdinfo.hussar.formdesign.jgit.api.TransportCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.CanceledException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.GitAPIException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.InvalidConfigurationException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.InvalidRemoteException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.JGitInternalException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.NoHeadException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.RefNotAdvertisedException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.RefNotFoundException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.TransportException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.WrongRepositoryStateException;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheCheckout;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.lib.BranchConfig;
import com.jxdinfo.hussar.formdesign.jgit.lib.Config;
import com.jxdinfo.hussar.formdesign.jgit.lib.NullProgressMonitor;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ProgressMonitor;
import com.jxdinfo.hussar.formdesign.jgit.lib.Ref;
import com.jxdinfo.hussar.formdesign.jgit.lib.RefUpdate;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.lib.RepositoryState;
import com.jxdinfo.hussar.formdesign.jgit.lib.StoredConfig;
import com.jxdinfo.hussar.formdesign.jgit.lib.SubmoduleConfig;
import com.jxdinfo.hussar.formdesign.jgit.merge.ContentMergeStrategy;
import com.jxdinfo.hussar.formdesign.jgit.merge.MergeStrategy;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevCommit;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevWalk;
import com.jxdinfo.hussar.formdesign.jgit.transport.FetchResult;
import com.jxdinfo.hussar.formdesign.jgit.transport.OperationResult;
import com.jxdinfo.hussar.formdesign.jgit.transport.TagOpt;
import java.io.IOException;
import java.text.MessageFormat;

public class PullCommand
extends TransportCommand<PullCommand, PullResult> {
    private static final String DOT = ".";
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private BranchConfig.BranchRebaseMode pullRebaseMode = null;
    private String remote;
    private String remoteBranchName;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private ContentMergeStrategy contentStrategy;
    private TagOpt tagOption;
    private MergeCommand.FastForwardMode fastForwardMode;
    private SubmoduleConfig.FetchRecurseSubmodulesMode submoduleRecurseMode = null;

    protected PullCommand(Repository repo) {
        super(repo);
    }

    public PullCommand setProgressMonitor(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }

    public PullCommand setRebase(boolean useRebase) {
        this.checkCallable();
        this.pullRebaseMode = useRebase ? BranchConfig.BranchRebaseMode.REBASE : BranchConfig.BranchRebaseMode.NONE;
        return this;
    }

    public PullCommand setRebase(BranchConfig.BranchRebaseMode rebaseMode) {
        this.checkCallable();
        this.pullRebaseMode = rebaseMode;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PullResult call() throws GitAPIException, WrongRepositoryStateException, InvalidConfigurationException, InvalidRemoteException, CanceledException, RefNotFoundException, RefNotAdvertisedException, NoHeadException, TransportException {
        PullResult result;
        ObjectId commitToMerge;
        OperationResult fetchRes;
        String remoteUri;
        boolean isRemote;
        this.checkCallable();
        this.monitor.beginTask(JGitText.get().pullTaskName, 2);
        StoredConfig repoConfig = this.repo.getConfig();
        String branchName = null;
        try {
            String fullBranch = this.repo.getFullBranch();
            if (fullBranch != null && fullBranch.startsWith("refs/heads/")) {
                branchName = fullBranch.substring("refs/heads/".length());
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPullCommand, e);
        }
        if (this.remoteBranchName == null && branchName != null) {
            this.remoteBranchName = repoConfig.getString("branch", branchName, "merge");
        }
        if (this.remoteBranchName == null) {
            this.remoteBranchName = branchName;
        }
        if (this.remoteBranchName == null) {
            throw new NoHeadException(JGitText.get().cannotCheckoutFromUnbornBranch);
        }
        if (!this.repo.getRepositoryState().equals((Object)RepositoryState.SAFE)) {
            throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().cannotPullOnARepoWithState, this.repo.getRepositoryState().name()));
        }
        if (this.remote == null && branchName != null) {
            this.remote = repoConfig.getString("branch", branchName, "remote");
        }
        if (this.remote == null) {
            this.remote = "origin";
        }
        if (this.pullRebaseMode == null && branchName != null) {
            this.pullRebaseMode = PullCommand.getRebaseMode(branchName, repoConfig);
        }
        boolean bl = isRemote = !this.remote.equals(DOT);
        if (isRemote) {
            remoteUri = repoConfig.getString("remote", this.remote, "url");
            if (remoteUri == null) {
                String missingKey = "remote." + this.remote + DOT + "url";
                throw new InvalidConfigurationException(MessageFormat.format(JGitText.get().missingConfigurationForKey, missingKey));
            }
            if (this.monitor.isCancelled()) {
                throw new CanceledException(MessageFormat.format(JGitText.get().operationCanceled, JGitText.get().pullTaskName));
            }
            FetchCommand fetch = new FetchCommand(this.repo).setRemote(this.remote).setProgressMonitor(this.monitor).setTagOpt(this.tagOption).setRecurseSubmodules(this.submoduleRecurseMode);
            this.configure(fetch);
            fetchRes = fetch.call();
        } else {
            remoteUri = JGitText.get().localRepository;
            fetchRes = null;
        }
        this.monitor.update(1);
        if (this.monitor.isCancelled()) {
            throw new CanceledException(MessageFormat.format(JGitText.get().operationCanceled, JGitText.get().pullTaskName));
        }
        if (isRemote) {
            Ref r = null;
            if (fetchRes != null && (r = fetchRes.getAdvertisedRef(this.remoteBranchName)) == null) {
                r = fetchRes.getAdvertisedRef("refs/heads/" + this.remoteBranchName);
            }
            if (r == null) {
                throw new RefNotAdvertisedException(MessageFormat.format(JGitText.get().couldNotGetAdvertisedRef, this.remote, this.remoteBranchName));
            }
            commitToMerge = r.getObjectId();
        } else {
            try {
                commitToMerge = this.repo.resolve(this.remoteBranchName);
                if (commitToMerge == null) {
                    throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.remoteBranchName));
                }
            }
            catch (IOException e) {
                throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPullCommand, e);
            }
        }
        String upstreamName = MessageFormat.format(JGitText.get().upstreamBranchName, Repository.shortenRefName(this.remoteBranchName), remoteUri);
        if (this.pullRebaseMode != BranchConfig.BranchRebaseMode.NONE) {
            try {
                Ref head = this.repo.exactRef("HEAD");
                if (head == null) {
                    throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                ObjectId headId = head.getObjectId();
                if (headId == null) {
                    try (RevWalk revWalk = new RevWalk(this.repo);){
                        RevCommit srcCommit = revWalk.parseCommit(commitToMerge);
                        DirCacheCheckout dco = new DirCacheCheckout(this.repo, this.repo.lockDirCache(), srcCommit.getTree());
                        dco.setFailOnConflict(true);
                        dco.setProgressMonitor(this.monitor);
                        dco.checkout();
                        RefUpdate refUpdate = this.repo.updateRef(head.getTarget().getName());
                        refUpdate.setNewObjectId(commitToMerge);
                        refUpdate.setExpectedOldObjectId(null);
                        refUpdate.setRefLogMessage("initial pull", false);
                        if (refUpdate.update() != RefUpdate.Result.NEW) {
                            throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                        }
                        this.monitor.endTask();
                        PullResult pullResult = new PullResult((FetchResult)fetchRes, this.remote, RebaseResult.result(RebaseResult.Status.FAST_FORWARD, srcCommit));
                        return pullResult;
                    }
                }
            }
            catch (NoHeadException e) {
                throw e;
            }
            catch (IOException e) {
                throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPullCommand, e);
            }
            RebaseCommand rebase = new RebaseCommand(this.repo);
            RebaseResult rebaseRes = rebase.setUpstream(commitToMerge).setProgressMonitor(this.monitor).setUpstreamName(upstreamName).setOperation(RebaseCommand.Operation.BEGIN).setStrategy(this.strategy).setContentMergeStrategy(this.contentStrategy).setPreserveMerges(this.pullRebaseMode == BranchConfig.BranchRebaseMode.PRESERVE).call();
            result = new PullResult((FetchResult)fetchRes, this.remote, rebaseRes);
        } else {
            MergeCommand merge = new MergeCommand(this.repo);
            MergeResult mergeRes = merge.include(upstreamName, commitToMerge).setProgressMonitor(this.monitor).setStrategy(this.strategy).setContentMergeStrategy(this.contentStrategy).setFastForward(this.getFastForwardMode()).call();
            this.monitor.update(1);
            result = new PullResult((FetchResult)fetchRes, this.remote, mergeRes);
        }
        this.monitor.endTask();
        return result;
    }

    public PullCommand setRemote(String remote) {
        this.checkCallable();
        this.remote = remote;
        return this;
    }

    public PullCommand setRemoteBranchName(String remoteBranchName) {
        this.checkCallable();
        this.remoteBranchName = remoteBranchName;
        return this;
    }

    public String getRemote() {
        return this.remote;
    }

    public String getRemoteBranchName() {
        return this.remoteBranchName;
    }

    public PullCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public PullCommand setContentMergeStrategy(ContentMergeStrategy strategy) {
        this.contentStrategy = strategy;
        return this;
    }

    public PullCommand setTagOpt(TagOpt tagOpt) {
        this.checkCallable();
        this.tagOption = tagOpt;
        return this;
    }

    public PullCommand setFastForward(@Nullable MergeCommand.FastForwardMode fastForwardMode) {
        this.checkCallable();
        this.fastForwardMode = fastForwardMode;
        return this;
    }

    public PullCommand setRecurseSubmodules(@Nullable SubmoduleConfig.FetchRecurseSubmodulesMode recurse) {
        this.submoduleRecurseMode = recurse;
        return this;
    }

    public static BranchConfig.BranchRebaseMode getRebaseMode(String branchName, Config config) {
        BranchConfig.BranchRebaseMode mode = (BranchConfig.BranchRebaseMode)config.getEnum(BranchConfig.BranchRebaseMode.values(), "branch", branchName, "rebase", null);
        if (mode == null) {
            mode = (BranchConfig.BranchRebaseMode)config.getEnum(BranchConfig.BranchRebaseMode.values(), "pull", null, "rebase", BranchConfig.BranchRebaseMode.NONE);
        }
        return mode;
    }

    private MergeCommand.FastForwardMode getFastForwardMode() {
        if (this.fastForwardMode != null) {
            return this.fastForwardMode;
        }
        StoredConfig config = this.repo.getConfig();
        MergeCommand.FastForwardMode.Merge ffMode = (MergeCommand.FastForwardMode.Merge)config.getEnum(MergeCommand.FastForwardMode.Merge.values(), "pull", null, "ff", null);
        return ffMode != null ? MergeCommand.FastForwardMode.valueOf(ffMode) : null;
    }
}

