/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.util;

import com.jxdinfo.hussar.formdesign.jgit.annotations.Nullable;
import com.jxdinfo.hussar.formdesign.jgit.errors.CommandFailedException;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.transport.CredentialsProvider;
import com.jxdinfo.hussar.formdesign.jgit.transport.RemoteSession;
import com.jxdinfo.hussar.formdesign.jgit.transport.SshSessionFactory;
import com.jxdinfo.hussar.formdesign.jgit.transport.URIish;
import com.jxdinfo.hussar.formdesign.jgit.util.FS;
import com.jxdinfo.hussar.formdesign.jgit.util.io.MessageWriter;
import com.jxdinfo.hussar.formdesign.jgit.util.io.StreamCopyThread;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;

public class SshSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String runSshCommand(URIish sshUri, @Nullable CredentialsProvider provider, FS fs, String command, int timeout) throws IOException, CommandFailedException {
        String out;
        MessageWriter stdout;
        MessageWriter stderr;
        CommandFailedException failure;
        StreamCopyThread outThread;
        Process process;
        RemoteSession session;
        block42: {
            session = null;
            process = null;
            StreamCopyThread errorThread = null;
            outThread = null;
            failure = null;
            stderr = new MessageWriter();
            stdout = new MessageWriter();
            try {
                long start = System.nanoTime();
                session = SshSessionFactory.getInstance().getSession(sshUri, provider, fs, 1000 * timeout);
                int commandTimeout = timeout;
                if (timeout > 0) {
                    commandTimeout = SshSupport.checkTimeout(command, timeout, start);
                }
                process = session.exec(command, commandTimeout);
                if (timeout > 0) {
                    commandTimeout = SshSupport.checkTimeout(command, timeout, start);
                }
                errorThread = new StreamCopyThread(process.getErrorStream(), stderr.getRawStream());
                errorThread.start();
                outThread = new StreamCopyThread(process.getInputStream(), stdout.getRawStream());
                outThread.start();
                try {
                    boolean finished = false;
                    if (timeout <= 0) {
                        process.waitFor();
                        finished = true;
                    } else {
                        finished = process.waitFor(commandTimeout, TimeUnit.SECONDS);
                    }
                    out = finished ? stdout.toString() : null;
                }
                catch (InterruptedException e) {
                    out = null;
                }
                if (errorThread == null) break block42;
            }
            catch (Throwable throwable) {
                if (errorThread != null) {
                    try {
                        errorThread.halt();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        errorThread = null;
                    }
                }
                if (outThread != null) {
                    try {
                        outThread.halt();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        outThread = null;
                    }
                }
                if (process != null) {
                    try {
                        if (process.exitValue() != 0) {
                            failure = new CommandFailedException(process.exitValue(), MessageFormat.format(JGitText.get().sshCommandFailed, command, stderr.toString()));
                        }
                        String out2 = stdout.toString();
                    }
                    catch (IllegalThreadStateException e) {
                        failure = new CommandFailedException(0, MessageFormat.format(JGitText.get().sshCommandTimeout, command, timeout));
                    }
                    process.destroy();
                }
                stderr.close();
                stdout.close();
                if (session != null) {
                    SshSessionFactory.getInstance().releaseSession(session);
                }
                throw throwable;
            }
            try {
                errorThread.halt();
            }
            catch (InterruptedException start) {
            }
            finally {
                errorThread = null;
            }
        }
        if (outThread != null) {
            try {
                outThread.halt();
            }
            catch (InterruptedException start) {
            }
            finally {
                outThread = null;
            }
        }
        if (process != null) {
            try {
                if (process.exitValue() != 0) {
                    failure = new CommandFailedException(process.exitValue(), MessageFormat.format(JGitText.get().sshCommandFailed, command, stderr.toString()));
                }
                out = stdout.toString();
            }
            catch (IllegalThreadStateException e) {
                failure = new CommandFailedException(0, MessageFormat.format(JGitText.get().sshCommandTimeout, command, timeout));
            }
            process.destroy();
        }
        stderr.close();
        stdout.close();
        if (session != null) {
            SshSessionFactory.getInstance().releaseSession(session);
        }
        if (failure != null) {
            throw failure;
        }
        return out;
    }

    private static int checkTimeout(String command, int timeout, long since) throws CommandFailedException {
        long elapsed = System.nanoTime() - since;
        int newTimeout = timeout - (int)TimeUnit.NANOSECONDS.toSeconds(elapsed);
        if (newTimeout <= 0) {
            throw new CommandFailedException(0, MessageFormat.format(JGitText.get().sshCommandTimeout, command, timeout));
        }
        return newTimeout;
    }
}

