/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.api;

import com.jxdinfo.hussar.formdesign.jgit.api.GitCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.ConcurrentRefUpdateException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.GitAPIException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.InvalidTagNameException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.JGitInternalException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.NoHeadException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.RefAlreadyExistsException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.ServiceUnavailableException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.UnsupportedSigningFormatException;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.lib.GpgConfig;
import com.jxdinfo.hussar.formdesign.jgit.lib.GpgObjectSigner;
import com.jxdinfo.hussar.formdesign.jgit.lib.GpgSigner;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.PersonIdent;
import com.jxdinfo.hussar.formdesign.jgit.lib.Ref;
import com.jxdinfo.hussar.formdesign.jgit.lib.RefUpdate;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.lib.RepositoryState;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevObject;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevWalk;
import com.jxdinfo.hussar.formdesign.jgit.transport.CredentialsProvider;
import java.io.IOException;
import java.text.MessageFormat;

public class TagCommand
extends GitCommand<Ref> {
    private RevObject id;
    private String name;
    private String message;
    private PersonIdent tagger;
    private Boolean signed;
    private boolean forceUpdate;
    private Boolean annotated;
    private String signingKey;
    private GpgConfig gpgConfig;
    private GpgObjectSigner gpgSigner;
    private CredentialsProvider credentialsProvider = CredentialsProvider.getDefault();

    protected TagCommand(Repository repo) {
        super(repo);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Ref call() throws GitAPIException, ConcurrentRefUpdateException, InvalidTagNameException, NoHeadException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Ref updateTagRef(ObjectId tagId, RevWalk revWalk, String tagName, String newTagToString) throws IOException, ConcurrentRefUpdateException, RefAlreadyExistsException {
        String refName = "refs/tags/" + tagName;
        RefUpdate tagRef = this.repo.updateRef(refName);
        tagRef.setNewObjectId(tagId);
        tagRef.setForceUpdate(this.forceUpdate);
        tagRef.setRefLogMessage("tagged " + this.name, false);
        RefUpdate.Result updateResult = tagRef.update(revWalk);
        switch (updateResult) {
            case NEW: 
            case FORCED: {
                return this.repo.exactRef(refName);
            }
            case LOCK_FAILURE: {
                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, tagRef.getRef(), updateResult);
            }
            case NO_CHANGE: {
                if (this.forceUpdate) {
                    return this.repo.exactRef(refName);
                }
                throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().tagAlreadyExists, newTagToString), updateResult);
            }
            case REJECTED: {
                throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().tagAlreadyExists, newTagToString), updateResult);
            }
        }
        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{refName, newTagToString, updateResult}));
    }

    private void processOptions(RepositoryState state) throws InvalidTagNameException, ServiceUnavailableException, UnsupportedSigningFormatException {
        if (this.name == null || !Repository.isValidRefName("refs/tags/" + this.name)) {
            throw new InvalidTagNameException(MessageFormat.format(JGitText.get().tagNameInvalid, this.name == null ? "<null>" : this.name));
        }
        if (!this.isAnnotated()) {
            if (this.message != null && !this.message.isEmpty() || this.tagger != null) {
                throw new JGitInternalException(JGitText.get().messageAndTaggerNotAllowedInUnannotatedTags);
            }
        } else {
            if (this.tagger == null) {
                this.tagger = new PersonIdent(this.repo);
            }
            if (!Boolean.FALSE.equals(this.signed) || this.signingKey != null) {
                boolean doSign;
                if (this.gpgConfig == null) {
                    this.gpgConfig = new GpgConfig(this.repo.getConfig());
                }
                boolean bl = doSign = this.isSigned() || this.gpgConfig.isSignAllTags();
                if (!Boolean.TRUE.equals(this.annotated) && !doSign) {
                    doSign = this.gpgConfig.isSignAnnotated();
                }
                if (doSign) {
                    if (this.signingKey == null) {
                        this.signingKey = this.gpgConfig.getSigningKey();
                    }
                    if (this.gpgSigner == null) {
                        GpgSigner signer = GpgSigner.getDefault();
                        if (!(signer instanceof GpgObjectSigner)) {
                            throw new ServiceUnavailableException(JGitText.get().signingServiceUnavailable);
                        }
                        this.gpgSigner = (GpgObjectSigner)((Object)signer);
                    }
                    if (this.message != null && !this.message.isEmpty() && !this.message.endsWith("\n")) {
                        this.message = this.message + '\n';
                    }
                }
            }
        }
    }

    public TagCommand setName(String name) {
        this.checkCallable();
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public TagCommand setMessage(String message) {
        this.checkCallable();
        this.message = message;
        return this;
    }

    public boolean isSigned() {
        return Boolean.TRUE.equals(this.signed) || this.signingKey != null;
    }

    public TagCommand setSigned(boolean signed) {
        this.checkCallable();
        this.signed = signed;
        return this;
    }

    public TagCommand setGpgSigner(GpgObjectSigner signer) {
        this.checkCallable();
        this.gpgSigner = signer;
        return this;
    }

    public TagCommand setGpgConfig(GpgConfig config) {
        this.checkCallable();
        this.gpgConfig = config;
        return this;
    }

    public TagCommand setTagger(PersonIdent tagger) {
        this.checkCallable();
        this.tagger = tagger;
        return this;
    }

    public PersonIdent getTagger() {
        return this.tagger;
    }

    public RevObject getObjectId() {
        return this.id;
    }

    public TagCommand setObjectId(RevObject id) {
        this.checkCallable();
        this.id = id;
        return this;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public TagCommand setForceUpdate(boolean forceUpdate) {
        this.checkCallable();
        this.forceUpdate = forceUpdate;
        return this;
    }

    public TagCommand setAnnotated(boolean annotated) {
        this.checkCallable();
        this.annotated = annotated;
        return this;
    }

    public boolean isAnnotated() {
        boolean setExplicitly;
        boolean bl = setExplicitly = Boolean.TRUE.equals(this.annotated) || this.isSigned();
        if (setExplicitly) {
            return true;
        }
        return this.annotated == null;
    }

    public TagCommand setSigningKey(String signingKey) {
        this.checkCallable();
        this.signingKey = signingKey;
        return this;
    }

    public String getSigningKey() {
        return this.signingKey;
    }

    public TagCommand setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.checkCallable();
        this.credentialsProvider = credentialsProvider;
        return this;
    }
}

