/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.api;

import com.jxdinfo.hussar.formdesign.jgit.api.GitCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.Status;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.GitAPIException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.JGitInternalException;
import com.jxdinfo.hussar.formdesign.jgit.errors.NoWorkTreeException;
import com.jxdinfo.hussar.formdesign.jgit.lib.IndexDiff;
import com.jxdinfo.hussar.formdesign.jgit.lib.ProgressMonitor;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.submodule.SubmoduleWalk;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.FileTreeIterator;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.WorkingTreeIterator;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.filter.PathFilterGroup;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class StatusCommand
extends GitCommand<Status> {
    private WorkingTreeIterator workingTreeIt;
    private List<String> paths = null;
    private ProgressMonitor progressMonitor = null;
    private SubmoduleWalk.IgnoreSubmoduleMode ignoreSubmoduleMode = null;

    protected StatusCommand(Repository repo) {
        super(repo);
    }

    public StatusCommand setIgnoreSubmodules(SubmoduleWalk.IgnoreSubmoduleMode mode) {
        this.ignoreSubmoduleMode = mode;
        return this;
    }

    public StatusCommand addPath(String path) {
        if (this.paths == null) {
            this.paths = new LinkedList<String>();
        }
        this.paths.add(path);
        return this;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    @Override
    public Status call() throws GitAPIException, NoWorkTreeException {
        if (this.workingTreeIt == null) {
            this.workingTreeIt = new FileTreeIterator(this.repo);
        }
        try {
            IndexDiff diff = new IndexDiff(this.repo, "HEAD", this.workingTreeIt);
            if (this.ignoreSubmoduleMode != null) {
                diff.setIgnoreSubmoduleMode(this.ignoreSubmoduleMode);
            }
            if (this.paths != null) {
                diff.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            if (this.progressMonitor == null) {
                diff.diff();
            } else {
                diff.diff(this.progressMonitor, 0, 0, "");
            }
            return new Status(diff);
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public StatusCommand setWorkingTreeIt(WorkingTreeIterator workingTreeIt) {
        this.workingTreeIt = workingTreeIt;
        return this;
    }

    public StatusCommand setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
        return this;
    }
}

