/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.api;

import com.jxdinfo.hussar.formdesign.jgit.api.GitCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.GitAPIException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.JGitInternalException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.NoHeadException;
import com.jxdinfo.hussar.formdesign.jgit.errors.IncorrectObjectTypeException;
import com.jxdinfo.hussar.formdesign.jgit.errors.MissingObjectException;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.lib.AnyObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.Ref;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevCommit;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevWalk;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.filter.AndRevFilter;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.filter.MaxCountRevFilter;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.filter.RevFilter;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.filter.SkipRevFilter;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.filter.AndTreeFilter;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.filter.PathFilter;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.filter.PathFilterGroup;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.filter.TreeFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class LogCommand
extends GitCommand<Iterable<RevCommit>> {
    private RevWalk walk;
    private boolean startSpecified = false;
    private RevFilter revFilter;
    private final List<PathFilter> pathFilters = new ArrayList<PathFilter>();
    private final List<TreeFilter> excludeTreeFilters = new ArrayList<TreeFilter>();
    private int maxCount = -1;
    private int skip = -1;

    protected LogCommand(Repository repo) {
        super(repo);
        this.walk = new RevWalk(repo);
    }

    @Override
    public Iterable<RevCommit> call() throws GitAPIException, NoHeadException {
        this.checkCallable();
        ArrayList<TreeFilter> filters = new ArrayList<TreeFilter>();
        if (!this.pathFilters.isEmpty()) {
            filters.add(AndTreeFilter.create(PathFilterGroup.create(this.pathFilters), TreeFilter.ANY_DIFF));
        }
        if (!this.excludeTreeFilters.isEmpty()) {
            for (TreeFilter f : this.excludeTreeFilters) {
                filters.add(AndTreeFilter.create(f, TreeFilter.ANY_DIFF));
            }
        }
        if (!filters.isEmpty()) {
            if (filters.size() == 1) {
                filters.add(TreeFilter.ANY_DIFF);
            }
            this.walk.setTreeFilter(AndTreeFilter.create(filters));
        }
        if (this.skip > -1 && this.maxCount > -1) {
            this.walk.setRevFilter(AndRevFilter.create(SkipRevFilter.create(this.skip), MaxCountRevFilter.create(this.maxCount)));
        } else if (this.skip > -1) {
            this.walk.setRevFilter(SkipRevFilter.create(this.skip));
        } else if (this.maxCount > -1) {
            this.walk.setRevFilter(MaxCountRevFilter.create(this.maxCount));
        }
        if (!this.startSpecified) {
            try {
                ObjectId headId = this.repo.resolve("HEAD");
                if (headId == null) {
                    throw new NoHeadException(JGitText.get().noHEADExistsAndNoExplicitStartingRevisionWasSpecified);
                }
                this.add(headId);
            }
            catch (IOException e) {
                throw new JGitInternalException(JGitText.get().anExceptionOccurredWhileTryingToAddTheIdOfHEAD, e);
            }
        }
        if (this.revFilter != null) {
            this.walk.setRevFilter(this.revFilter);
        }
        this.setCallable(false);
        return this.walk;
    }

    public LogCommand add(AnyObjectId start) throws MissingObjectException, IncorrectObjectTypeException {
        return this.add(true, start);
    }

    public LogCommand not(AnyObjectId start) throws MissingObjectException, IncorrectObjectTypeException {
        return this.add(false, start);
    }

    public LogCommand addRange(AnyObjectId since, AnyObjectId until) throws MissingObjectException, IncorrectObjectTypeException {
        return this.not(since).add(until);
    }

    public LogCommand all() throws IOException {
        for (Ref ref : this.getRepository().getRefDatabase().getRefs()) {
            ObjectId objectId;
            if (!ref.isPeeled()) {
                ref = this.getRepository().getRefDatabase().peel(ref);
            }
            if ((objectId = ref.getPeeledObjectId()) == null) {
                objectId = ref.getObjectId();
            }
            RevCommit commit = null;
            try {
                commit = this.walk.parseCommit(objectId);
            }
            catch (IncorrectObjectTypeException | MissingObjectException iOException) {
                // empty catch block
            }
            if (commit == null) continue;
            this.add(commit);
        }
        return this;
    }

    public LogCommand addPath(String path) {
        this.checkCallable();
        this.pathFilters.add(PathFilter.create(path));
        return this;
    }

    public LogCommand excludePath(String path) {
        this.checkCallable();
        this.excludeTreeFilters.add(PathFilter.create(path).negate());
        return this;
    }

    public LogCommand setSkip(int skip) {
        this.checkCallable();
        this.skip = skip;
        return this;
    }

    public LogCommand setMaxCount(int maxCount) {
        this.checkCallable();
        this.maxCount = maxCount;
        return this;
    }

    private LogCommand add(boolean include, AnyObjectId start) throws MissingObjectException, IncorrectObjectTypeException, JGitInternalException {
        this.checkCallable();
        try {
            if (include) {
                this.walk.markStart(this.walk.lookupCommit(start));
                this.startSpecified = true;
            } else {
                this.walk.markUninteresting(this.walk.lookupCommit(start));
            }
            return this;
        }
        catch (IncorrectObjectTypeException | MissingObjectException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringAddingOfOptionToALogCommand, start), e);
        }
    }

    public LogCommand setRevFilter(RevFilter aFilter) {
        this.checkCallable();
        this.revFilter = aFilter;
        return this;
    }
}

