/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.api;

import com.jxdinfo.hussar.formdesign.jgit.api.Git;
import com.jxdinfo.hussar.formdesign.jgit.api.GitCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.AbortedByHookException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.CanceledException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.ConcurrentRefUpdateException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.EmptyCommitException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.GitAPIException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.JGitInternalException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.NoFilepatternException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.NoHeadException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.NoMessageException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.ServiceUnavailableException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.UnmergedPathsException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.UnsupportedSigningFormatException;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.WrongRepositoryStateException;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCache;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheBuildIterator;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheBuilder;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheEntry;
import com.jxdinfo.hussar.formdesign.jgit.dircache.DirCacheIterator;
import com.jxdinfo.hussar.formdesign.jgit.errors.IncorrectObjectTypeException;
import com.jxdinfo.hussar.formdesign.jgit.errors.MissingObjectException;
import com.jxdinfo.hussar.formdesign.jgit.errors.UnmergedPathException;
import com.jxdinfo.hussar.formdesign.jgit.hooks.Hooks;
import com.jxdinfo.hussar.formdesign.jgit.internal.JGitText;
import com.jxdinfo.hussar.formdesign.jgit.lib.CommitBuilder;
import com.jxdinfo.hussar.formdesign.jgit.lib.FileMode;
import com.jxdinfo.hussar.formdesign.jgit.lib.GpgConfig;
import com.jxdinfo.hussar.formdesign.jgit.lib.GpgObjectSigner;
import com.jxdinfo.hussar.formdesign.jgit.lib.GpgSigner;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectId;
import com.jxdinfo.hussar.formdesign.jgit.lib.ObjectInserter;
import com.jxdinfo.hussar.formdesign.jgit.lib.PersonIdent;
import com.jxdinfo.hussar.formdesign.jgit.lib.Ref;
import com.jxdinfo.hussar.formdesign.jgit.lib.RefUpdate;
import com.jxdinfo.hussar.formdesign.jgit.lib.Repository;
import com.jxdinfo.hussar.formdesign.jgit.lib.RepositoryState;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevCommit;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevObject;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevTag;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevWalk;
import com.jxdinfo.hussar.formdesign.jgit.transport.CredentialsProvider;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.CanonicalTreeParser;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.FileTreeIterator;
import com.jxdinfo.hussar.formdesign.jgit.treewalk.TreeWalk;
import com.jxdinfo.hussar.formdesign.jgit.util.ChangeIdUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitCommand
extends GitCommand<RevCommit> {
    private static final Logger log = LoggerFactory.getLogger(CommitCommand.class);
    private PersonIdent author;
    private PersonIdent committer;
    private String message;
    private boolean all;
    private List<String> only = new ArrayList<String>();
    private boolean[] onlyProcessed;
    private boolean amend;
    private boolean insertChangeId;
    private List<ObjectId> parents = new LinkedList<ObjectId>();
    private String reflogComment;
    private boolean useDefaultReflogMessage = true;
    private boolean noVerify;
    private HashMap<String, PrintStream> hookOutRedirect = new HashMap(3);
    private HashMap<String, PrintStream> hookErrRedirect = new HashMap(3);
    private Boolean allowEmpty;
    private Boolean signCommit;
    private String signingKey;
    private GpgSigner gpgSigner;
    private GpgConfig gpgConfig;
    private CredentialsProvider credentialsProvider = CredentialsProvider.getDefault();

    protected CommitCommand(Repository repo) {
        super(repo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RevCommit call() throws GitAPIException, AbortedByHookException, ConcurrentRefUpdateException, NoHeadException, NoMessageException, ServiceUnavailableException, UnmergedPathsException, WrongRepositoryStateException {
        this.checkCallable();
        Collections.sort(this.only);
        try (RevWalk rw = new RevWalk(this.repo);){
            RevCommit revCommit;
            Ref head;
            RepositoryState state = this.repo.getRepositoryState();
            if (!state.canCommit()) {
                throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().cannotCommitOnARepoWithState, state.name()));
            }
            if (!this.noVerify) {
                Hooks.preCommit(this.repo, this.hookOutRedirect.get("pre-commit"), this.hookErrRedirect.get("pre-commit")).call();
            }
            this.processOptions(state, rw);
            if (this.all && !this.repo.isBare()) {
                try (Git git = new Git(this.repo);){
                    git.add().addFilepattern(".").setUpdate(true).call();
                }
                catch (NoFilepatternException e) {
                    throw new JGitInternalException(e.getMessage(), e);
                }
            }
            if ((head = this.repo.exactRef("HEAD")) == null) {
                throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
            }
            ObjectId headId = this.repo.resolve("HEAD^{commit}");
            if (headId == null && this.amend) {
                throw new WrongRepositoryStateException(JGitText.get().commitAmendOnInitialNotPossible);
            }
            if (headId != null) {
                if (this.amend) {
                    RevCommit previousCommit = rw.parseCommit(headId);
                    for (RevCommit p : previousCommit.getParents()) {
                        this.parents.add(p.getId());
                    }
                    if (this.author == null) {
                        this.author = previousCommit.getAuthorIdent();
                    }
                } else {
                    this.parents.add(0, headId);
                }
            }
            if (!this.noVerify) {
                this.message = Hooks.commitMsg(this.repo, this.hookOutRedirect.get("commit-msg"), this.hookErrRedirect.get("commit-msg")).setCommitMessage(this.message).call();
            }
            DirCache index = this.repo.lockDirCache();
            try (ObjectInserter odi = this.repo.newObjectInserter();){
                if (!this.only.isEmpty()) {
                    index = this.createTemporaryIndex(headId, index, rw);
                }
                ObjectId indexTreeId = index.writeTree(odi);
                if (this.insertChangeId) {
                    this.insertChangeId(indexTreeId);
                }
                this.checkIfEmpty(rw, headId, indexTreeId);
                CommitBuilder commit = new CommitBuilder();
                commit.setCommitter(this.committer);
                commit.setAuthor(this.author);
                commit.setMessage(this.message);
                commit.setParentIds(this.parents);
                commit.setTreeId(indexTreeId);
                if (this.signCommit.booleanValue()) {
                    this.sign(commit);
                }
                ObjectId commitId = odi.insert(commit);
                odi.flush();
                revCommit = rw.parseCommit(commitId);
                this.updateRef(state, headId, revCommit, commitId);
            }
            finally {
                index.unlock();
            }
            try {
                Hooks.postCommit(this.repo, this.hookOutRedirect.get("post-commit"), this.hookErrRedirect.get("post-commit")).call();
            }
            catch (Exception e) {
                log.error(MessageFormat.format(JGitText.get().postCommitHookFailed, e.getMessage()), (Throwable)e);
            }
            RevCommit revCommit2 = revCommit;
            return revCommit2;
        }
        catch (UnmergedPathException e) {
            throw new UnmergedPathsException(e);
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfCommitCommand, e);
        }
    }

    private void checkIfEmpty(RevWalk rw, ObjectId headId, ObjectId indexTreeId) throws EmptyCommitException, MissingObjectException, IncorrectObjectTypeException, IOException {
        if (headId != null && !this.allowEmpty.booleanValue()) {
            RevCommit headCommit = rw.parseCommit(headId);
            headCommit.getTree();
            if (indexTreeId.equals(headCommit.getTree())) {
                throw new EmptyCommitException(JGitText.get().emptyCommit);
            }
        }
    }

    private void sign(CommitBuilder commit) throws ServiceUnavailableException, CanceledException, UnsupportedSigningFormatException {
        if (this.gpgSigner == null) {
            throw new ServiceUnavailableException(JGitText.get().signingServiceUnavailable);
        }
        if (this.gpgSigner instanceof GpgObjectSigner) {
            ((GpgObjectSigner)((Object)this.gpgSigner)).signObject(commit, this.signingKey, this.committer, this.credentialsProvider, this.gpgConfig);
        } else {
            if (this.gpgConfig.getKeyFormat() != GpgConfig.GpgFormat.OPENPGP) {
                throw new UnsupportedSigningFormatException(JGitText.get().onlyOpenPgpSupportedForSigning);
            }
            this.gpgSigner.sign(commit, this.signingKey, this.committer, this.credentialsProvider);
        }
    }

    private void updateRef(RepositoryState state, ObjectId headId, RevCommit revCommit, ObjectId commitId) throws ConcurrentRefUpdateException, IOException {
        RefUpdate ru = this.repo.updateRef("HEAD");
        ru.setNewObjectId(commitId);
        if (!this.useDefaultReflogMessage) {
            ru.setRefLogMessage(this.reflogComment, false);
        } else {
            String prefix = this.amend ? "commit (amend): " : (this.parents.isEmpty() ? "commit (initial): " : "commit: ");
            ru.setRefLogMessage(prefix + revCommit.getShortMessage(), false);
        }
        if (headId != null) {
            ru.setExpectedOldObjectId(headId);
        } else {
            ru.setExpectedOldObjectId(ObjectId.zeroId());
        }
        RefUpdate.Result rc = ru.forceUpdate();
        switch (rc) {
            case NEW: 
            case FORCED: 
            case FAST_FORWARD: {
                this.setCallable(false);
                if (state == RepositoryState.MERGING_RESOLVED || this.isMergeDuringRebase(state)) {
                    this.repo.writeMergeCommitMsg(null);
                    this.repo.writeMergeHeads(null);
                    break;
                }
                if (state == RepositoryState.CHERRY_PICKING_RESOLVED) {
                    this.repo.writeMergeCommitMsg(null);
                    this.repo.writeCherryPickHead(null);
                    break;
                }
                if (state != RepositoryState.REVERTING_RESOLVED) break;
                this.repo.writeMergeCommitMsg(null);
                this.repo.writeRevertHead(null);
                break;
            }
            case REJECTED: 
            case LOCK_FAILURE: {
                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, ru.getRef(), rc);
            }
            default: {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{"HEAD", commitId.toString(), rc}));
            }
        }
    }

    private void insertChangeId(ObjectId treeId) {
        ObjectId firstParentId = null;
        if (!this.parents.isEmpty()) {
            firstParentId = this.parents.get(0);
        }
        ObjectId changeId = ChangeIdUtil.computeChangeId(treeId, firstParentId, this.author, this.committer, this.message);
        this.message = ChangeIdUtil.insertId(this.message, changeId);
        if (changeId != null) {
            this.message = this.message.replaceAll("\nChange-Id: I" + ObjectId.zeroId().getName() + "\n", "\nChange-Id: I" + changeId.getName() + "\n");
        }
    }

    private DirCache createTemporaryIndex(ObjectId headId, DirCache index, RevWalk rw) throws IOException {
        ObjectInserter inserter = null;
        DirCacheBuilder existingBuilder = index.builder();
        DirCache inCoreIndex = DirCache.newInCore();
        DirCacheBuilder tempBuilder = inCoreIndex.builder();
        this.onlyProcessed = new boolean[this.only.size()];
        boolean emptyCommit = true;
        try (TreeWalk treeWalk = new TreeWalk(this.repo);){
            treeWalk.setOperationType(TreeWalk.OperationType.CHECKIN_OP);
            int dcIdx = treeWalk.addTree(new DirCacheBuildIterator(existingBuilder));
            FileTreeIterator fti = new FileTreeIterator(this.repo);
            fti.setDirCacheIterator(treeWalk, 0);
            int fIdx = treeWalk.addTree(fti);
            int hIdx = -1;
            if (headId != null) {
                hIdx = treeWalk.addTree(rw.parseTree(headId));
            }
            treeWalk.setRecursive(true);
            String lastAddedFile = null;
            while (treeWalk.next()) {
                String path = treeWalk.getPathString();
                int pos = this.lookupOnly(path);
                CanonicalTreeParser hTree = null;
                if (hIdx != -1) {
                    hTree = treeWalk.getTree(hIdx, CanonicalTreeParser.class);
                }
                DirCacheIterator dcTree = treeWalk.getTree(dcIdx, DirCacheIterator.class);
                if (pos >= 0) {
                    FileTreeIterator fTree = treeWalk.getTree(fIdx, FileTreeIterator.class);
                    boolean tracked = dcTree != null || hTree != null;
                    if (!tracked || path.equals(lastAddedFile)) continue;
                    lastAddedFile = path;
                    if (fTree != null) {
                        boolean objectExists;
                        DirCacheEntry dcEntry = new DirCacheEntry(path);
                        long entryLength = fTree.getEntryLength();
                        dcEntry.setLength(entryLength);
                        dcEntry.setLastModified(fTree.getEntryLastModifiedInstant());
                        dcEntry.setFileMode(fTree.getIndexFileMode(dcTree));
                        boolean bl = objectExists = dcTree != null && fTree.idEqual(dcTree) || hTree != null && fTree.idEqual(hTree);
                        if (objectExists) {
                            dcEntry.setObjectId(fTree.getEntryObjectId());
                        } else if (FileMode.GITLINK.equals(dcEntry.getFileMode())) {
                            dcEntry.setObjectId(fTree.getEntryObjectId());
                        } else {
                            if (inserter == null) {
                                inserter = this.repo.newObjectInserter();
                            }
                            long contentLength = fTree.getEntryContentLength();
                            try (InputStream inputStream = fTree.openEntryStream();){
                                dcEntry.setObjectId(inserter.insert(3, contentLength, inputStream));
                            }
                        }
                        existingBuilder.add(dcEntry);
                        tempBuilder.add(dcEntry);
                        if (emptyCommit && (hTree == null || !hTree.idEqual(fTree) || hTree.getEntryRawMode() != fTree.getEntryRawMode())) {
                            emptyCommit = false;
                        }
                    } else if (emptyCommit && hTree != null) {
                        emptyCommit = false;
                    }
                    this.onlyProcessed[pos] = true;
                    continue;
                }
                if (hTree != null) {
                    DirCacheEntry dcEntry = new DirCacheEntry(path);
                    dcEntry.setObjectId(hTree.getEntryObjectId());
                    dcEntry.setFileMode(hTree.getEntryFileMode());
                    tempBuilder.add(dcEntry);
                }
                if (dcTree == null) continue;
                existingBuilder.add(dcTree.getDirCacheEntry());
            }
        }
        for (int i = 0; i < this.onlyProcessed.length; ++i) {
            if (this.onlyProcessed[i]) continue;
            throw new JGitInternalException(MessageFormat.format(JGitText.get().entryNotFoundByPath, this.only.get(i)));
        }
        if (emptyCommit && !this.allowEmpty.booleanValue()) {
            throw new JGitInternalException(JGitText.get().emptyCommit);
        }
        existingBuilder.commit();
        tempBuilder.finish();
        return inCoreIndex;
    }

    private int lookupOnly(String pathString) {
        String p = pathString;
        while (true) {
            int position;
            if ((position = Collections.binarySearch(this.only, p)) >= 0) {
                return position;
            }
            int l = p.lastIndexOf(47);
            if (l < 1) break;
            p = p.substring(0, l);
        }
        return -1;
    }

    private void processOptions(RepositoryState state, RevWalk rw) throws NoMessageException, UnsupportedSigningFormatException {
        if (this.committer == null) {
            this.committer = new PersonIdent(this.repo);
        }
        if (this.author == null && !this.amend) {
            this.author = this.committer;
        }
        if (this.allowEmpty == null) {
            Boolean bl = this.allowEmpty = this.only.isEmpty() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (state == RepositoryState.MERGING_RESOLVED || this.isMergeDuringRebase(state)) {
            try {
                this.parents = this.repo.readMergeHeads();
                if (this.parents != null) {
                    for (int i = 0; i < this.parents.size(); ++i) {
                        RevObject ro = rw.parseAny(this.parents.get(i));
                        if (!(ro instanceof RevTag)) continue;
                        this.parents.set(i, rw.peel(ro));
                    }
                }
            }
            catch (IOException e) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_HEAD", e), e);
            }
            if (this.message == null) {
                try {
                    this.message = this.repo.readMergeCommitMsg();
                }
                catch (IOException e) {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_MSG", e), e);
                }
            }
        } else if (state == RepositoryState.SAFE && this.message == null) {
            try {
                this.message = this.repo.readSquashCommitMsg();
                if (this.message != null) {
                    this.repo.writeSquashCommitMsg(null);
                }
            }
            catch (IOException e) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_MSG", e), e);
            }
        }
        if (this.message == null) {
            throw new NoMessageException(JGitText.get().commitMessageNotSpecified);
        }
        if (this.gpgConfig == null) {
            this.gpgConfig = new GpgConfig(this.repo.getConfig());
        }
        if (this.signCommit == null) {
            Boolean bl = this.signCommit = this.gpgConfig.isSignCommits() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.signingKey == null) {
            this.signingKey = this.gpgConfig.getSigningKey();
        }
        if (this.gpgSigner == null) {
            this.gpgSigner = GpgSigner.getDefault();
        }
    }

    private boolean isMergeDuringRebase(RepositoryState state) {
        if (state != RepositoryState.REBASING_INTERACTIVE && state != RepositoryState.REBASING_MERGE) {
            return false;
        }
        try {
            return this.repo.readMergeHeads() != null;
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_HEAD", e), e);
        }
    }

    public CommitCommand setMessage(String message) {
        this.checkCallable();
        this.message = message;
        return this;
    }

    public CommitCommand setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public CommitCommand setCommitter(PersonIdent committer) {
        this.checkCallable();
        this.committer = committer;
        return this;
    }

    public CommitCommand setCommitter(String name, String email) {
        this.checkCallable();
        return this.setCommitter(new PersonIdent(name, email));
    }

    public PersonIdent getCommitter() {
        return this.committer;
    }

    public CommitCommand setAuthor(PersonIdent author) {
        this.checkCallable();
        this.author = author;
        return this;
    }

    public CommitCommand setAuthor(String name, String email) {
        this.checkCallable();
        return this.setAuthor(new PersonIdent(name, email));
    }

    public PersonIdent getAuthor() {
        return this.author;
    }

    public CommitCommand setAll(boolean all) {
        this.checkCallable();
        if (all && !this.only.isEmpty()) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "--all", "--only"));
        }
        this.all = all;
        return this;
    }

    public CommitCommand setAmend(boolean amend) {
        this.checkCallable();
        this.amend = amend;
        return this;
    }

    public CommitCommand setOnly(String only) {
        String o;
        this.checkCallable();
        if (this.all) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "--only", "--all"));
        }
        String string = o = only.endsWith("/") ? only.substring(0, only.length() - 1) : only;
        if (!this.only.contains(o)) {
            this.only.add(o);
        }
        return this;
    }

    public CommitCommand setInsertChangeId(boolean insertChangeId) {
        this.checkCallable();
        this.insertChangeId = insertChangeId;
        return this;
    }

    public CommitCommand setReflogComment(String reflogComment) {
        this.reflogComment = reflogComment;
        this.useDefaultReflogMessage = false;
        return this;
    }

    public CommitCommand setNoVerify(boolean noVerify) {
        this.noVerify = noVerify;
        return this;
    }

    public CommitCommand setHookOutputStream(PrintStream hookStdOut) {
        this.setHookOutputStream("pre-commit", hookStdOut);
        this.setHookOutputStream("commit-msg", hookStdOut);
        this.setHookOutputStream("post-commit", hookStdOut);
        return this;
    }

    public CommitCommand setHookErrorStream(PrintStream hookStdErr) {
        this.setHookErrorStream("pre-commit", hookStdErr);
        this.setHookErrorStream("commit-msg", hookStdErr);
        this.setHookErrorStream("post-commit", hookStdErr);
        return this;
    }

    public CommitCommand setHookOutputStream(String hookName, PrintStream hookStdOut) {
        if (!("pre-commit".equals(hookName) || "commit-msg".equals(hookName) || "post-commit".equals(hookName))) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().illegalHookName, hookName));
        }
        this.hookOutRedirect.put(hookName, hookStdOut);
        return this;
    }

    public CommitCommand setHookErrorStream(String hookName, PrintStream hookStdErr) {
        if (!("pre-commit".equals(hookName) || "commit-msg".equals(hookName) || "post-commit".equals(hookName))) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().illegalHookName, hookName));
        }
        this.hookErrRedirect.put(hookName, hookStdErr);
        return this;
    }

    public CommitCommand setSigningKey(String signingKey) {
        this.checkCallable();
        this.signingKey = signingKey;
        return this;
    }

    public CommitCommand setSign(Boolean sign) {
        this.checkCallable();
        this.signCommit = sign;
        return this;
    }

    public CommitCommand setGpgSigner(GpgSigner signer) {
        this.checkCallable();
        this.gpgSigner = signer;
        return this;
    }

    public CommitCommand setGpgConfig(GpgConfig config) {
        this.checkCallable();
        this.gpgConfig = config;
        return this;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }
}

