<#--高度自适应时，监听最外层容器滚动条；否则监听web列表滚动条-->
<#if isAutoHeight?? && isAutoHeight>
    const elem = document.getElementById('${instanceKey!}Id').parentNode;
<#else>
    const elem = document.getElementById('${instanceKey!}Id');
</#if>
// 节流函数
const throttle = (fun, delay) => {
    let last = 0;
    let timer = null;
    return function throttled(...args) {
        const now = Date.now();
        if (now - last >= delay) {
            clearTimeout(timer); // 清除之前可能存在的定时器
            fun.apply(this, args);
            last = now;
        } else if (!timer) { // 如果在delay时间内再次触发，重新设置定时器
            timer = setTimeout(() => {
                fun.apply(this, args);
                timer = null;
            }, delay - (now - last));
        }
    };
};
// 监听滚动条触底
const handleScroll = function () {
    const scrollTop = elem.scrollTop;
    const vHeight = elem.clientHeight;
    const pageHeight = elem.scrollHeight;
    if (vHeight + scrollTop >= pageHeight - 10 && !self.${instanceKey!}Finished) {
        // -10是为了在滚动到底部前提前获取数据，提高用户体验
        self.${instanceKey!}LoadingMore = false;
        self.${instanceKey!}Loading = true;
        self.${instanceKey!}ListLoad(true);
    }
};
elem.addEventListener('scroll', throttle(handleScroll, 1000));