<#macro colTree colList>
    <#list colList as item>
        tableHead.push({
            "title" : '${item.title?js_string!}',
            "horizontal" : 'center',
            "colspan" : 1,
            "rowspan" : 1,
            "level" : level
        });
        const ${item.field!}Index = tableField.indexOf('${item.field!}');
        const ${item.field!}Letter = self.${listKey!}ExcelExportForArea(${item.field!}Index);
        colArray.push({
            "letter": ${item.field!}Letter,
            "horizontal": 'center',
            "dataType": "string",
            "length": 0
        });
    </#list>
    --level;
</#macro>
<#macro tableHead>
    for (let i = 0; i < tableHead.length; i++){
        if (tableHead[i].rowspan + tableHead[i].level - 1> maxLevel){
            tableHead[i].rowspan = maxLevel - tableHead[i].level + 1;
        }
    }
    const excelCell = [];
    const rows = [];
    for (let i = 0;i < tableField.length; i++){
        for (let j = 0; j < maxLevel; j++){
            const cell = {"xAxis":i,"yAxis":j,isEdit:false};
            excelCell.push(cell);
        }
    }
    for (let i = 0;i < maxLevel; i++){
        let x = 0;
        const row = [];
        for (let j=0;j < tableHead.length; j++){
            const index = excelCell.findIndex(function(value, index, arr) {
                return value.isEdit == false && value.yAxis == i;
            });
            if (index != -1) {
                x = excelCell.find(function(value, index, arr) {
                    return value.isEdit == false && value.yAxis == i;
                }).xAxis;
            }
            if ( tableHead[j].level - 1 == i){
        const startArea = self.${listKey!}ExcelExportForArea(x) + (1 + i);
        const endArea = self.${listKey!}ExcelExportForArea(x + tableHead[j].colspan - 1) + (tableHead[j].rowspan + i);
        for (let k = x; k < x + tableHead[j].colspan; k++){
                    for (let m = i;m < tableHead[j].rowspan + i; m++){
                        excelCell.find(function(value, index, arr) {
                            return value.xAxis == k && value.yAxis == m;
                        }).isEdit = true;
                    }
                }
                while (row.length < x){
                    row.push("");
                }
                row[x] = tableHead[j].title;
                tableHead[j].merge = startArea + ":" + endArea;
            }
        }
        rows.push(row);
    }
    worksheet.insertRows(1, rows);
    for (let j=0;j < tableHead.length; j++){
        worksheet.mergeCells(tableHead[j].merge);
        worksheet.getCell(tableHead[j].merge.split(":")[0]).alignment = {
            vertical: 'middle',
            horizontal: tableHead[j].horizontal
        };
    }
    for (let i = 0; i < colArray.length; i++){
        for (let j = maxLevel + 1; j < 1000; j++) {
            worksheet.getCell(colArray[i].letter + j).alignment = { horizontal: colArray[i].horizontal };
            if (colArray[i].dataType == "date"){
                const cell = worksheet.getCell(colArray[i].letter+j)
                cell.value = cell.value != null ? cell.value.substr(0,colArray[i].length) : null;
            }
        }
    }
</#macro>

const tableData = [
    <#list component_cols! as item>
        <#if (item_index != (component_cols?size-1))>
            "${item.title}",
        <#else>
            "${item.title}"
        </#if>
    </#list>
];
const tableField = [
    <#list component_cols! as item>
        <#if (item_index != (component_cols?size-1))>
            "${item.field}",
        <#else>
            "${item.field}"
        </#if>
    </#list>
];
const columns = [];
for (let i=0; i<tableData.length ; i++){
    const excelCol = {};
    // excelCol.header = tableData[0][i];
    excelCol.key = tableField[i];
    excelCol.width = 30;
    columns.push(excelCol);
}
const Excel = require("exceljs");
const workbook = new Excel.Workbook();
const worksheet = workbook.addWorksheet("sheet1");
const fileName = "data.xlsx";
workbook.created = new Date();
workbook.modified = new Date();
worksheet.columns = columns;
const dicts = [];
const relates = [];
worksheet.insertRows(1, ${dataName!});
const colArray = [];
const tableHead = [];
let level = 1;
const maxLevel = 1;
<@colTree colList=component_cols!></@colTree>
<@tableHead></@tableHead>
workbook.xlsx.writeBuffer().then(function (buffer) {
    saveAs(new Blob([buffer], {
        type: 'application/octet-stream'
    }), fileName);
});