<#macro tableHead>
    for (let i = 0; i < realTableHead.length; i++){
        if (realTableHead[i].field){
            realTableHead[i].rowspan = maxLevel - realTableHead[i].level + 1;
        }
    }
    const excelCell = [];
    const rows = [];
    for (let i = 0;i < tableField.length; i++){
        for (let j = 0; j < maxLevel; j++){
            const cell = {"xAxis":i,"yAxis":j,isEdit:false};
            excelCell.push(cell);
        }
    }
    for (let i = 0;i < maxLevel; i++){
        let x = 0;
        const row = [];
        for (let j=0;j < realTableHead.length; j++){
            const index = excelCell.findIndex(function(value, index, arr) {
                return value.isEdit === false && value.yAxis === i;
            });
            if (index !== -1) {
                x = excelCell.find(function(value, index, arr) {    
                    return value.isEdit === false && value.yAxis === i;
                }).xAxis;
            }
            if ( realTableHead[j].level - 1 === i){
                const startArea = excelDownloadForArea(x) + (1 + i);
                const endArea = excelDownloadForArea(x + realTableHead[j].colspan - 1) + (realTableHead[j].rowspan + i);
                for (let k = x; k < x + realTableHead[j].colspan; k++){
                    for (let m = i;m < realTableHead[j].rowspan + i; m++){
                        excelCell.find(function(value, index, arr) {
                            return value.xAxis === k && value.yAxis === m;
                        }).isEdit = true;
                    }
                }
                while (row.length < x){
                    row.push("");
                }
                row[x] = realTableHead[j].title;
                realTableHead[j].merge = startArea + ":" + endArea;
            }
        }
        rows.push(row);
    }
    worksheet.insertRows(1, rows);
    for (let j=0;j < realTableHead.length; j++){
        worksheet.mergeCells(realTableHead[j].merge);
        const headCell = worksheet.getCell(realTableHead[j].merge.split(":")[0]);
        headCell.alignment = {
            vertical: 'middle',
            horizontal: realTableHead[j].horizontal
        };
        headCell.fill = {
            type: 'pattern',
            pattern: 'solid',
            fgColor: { argb: 'FFBFBFBF'},
            bgColor: { argb: 'FFBFBFBF' }
        };
        headCell.border = {
            top: {style:'thin'},
            left: {style:'thin'},
            bottom: {style:'thin'},
            right: {style:'thin'}
        };
    }
    for (let i = 0; i < realColArray.length; i++){
        for (let j = maxLevel + 1; j < ${dataName!}.length + 100; j++) { // 设置行样式
            worksheet.getCell(realColArray[i].letter + j).alignment = { horizontal: realColArray[i].horizontal };
            if (realColArray[i].dataType === "date"){
                const cell = worksheet.getCell(realColArray[i].letter+j)
                cell.value = cell.value !== null ? cell.value.substr(0,realColArray[i].length) : null;
            }
        }
    }
</#macro>

HussarRouter.showMsg(self, "正在导出数据...", 'success');
const {columns: list, filename } = options;
<#--  列表头-列名 -->
const tableData = [];
<#-- 列表头-字段值 -->
const tableField = [];
// 根据导出设置列获取要导出的真正的列
list.forEach((item) => {
    tableData.push(item.label);
    tableField.push(item.prop);
});
const columns = [];
for (let i=0; i<tableData.length ; i++){
  const excelCol = {};
  excelCol.key = tableField[i];
  excelCol.width = 30;
  columns.push(excelCol);
}
const Excel = require("exceljs");
const workbook = new Excel.Workbook();
const worksheet = workbook.addWorksheet("sheet1");
const fileName = (filename || 'data') + '.xlsx';
workbook.created = new Date();
workbook.modified = new Date();
worksheet.columns = columns;

const exportDataFun = function() {
  const convert = [];
  ${dataName!}.forEach((item) => {
    // 查到的数据转换为字符串
    convert.push({
      <#assign map=colFields/>
      <#assign  keys=map?keys/>
      <#list keys! as key>
          ${key}: ((item.${map[key]} + '') === 'null' || (item.${map[key]} + '') === 'undefined' ? '': (item.${map[key]} + '').trim()),
      </#list>
    })
  });
  worksheet.insertRows(1, convert);
  const colArray = [];
  const tableHead = [];
  // eslint-disable-next-line
  let maxLevel = 1;
  const realTableHead = [];
  const realColArray = [];
  const getRealHeadAndCol = function (arr) {
    arr.forEach((child) => {
      if (child.children && child.children.length > 0) {
        getRealHeadAndCol(child.children);
        child.colspan = child.children.reduce((prev, cur) => prev + (cur.colspan || 1), 0);
      }
      realTableHead.push({
        title: child.label,
        field: child.prop,
        level: child.level || 1,
        rowspan: 1,
        colspan: child.colspan || 1,
        ...(child.align && child.align !== 'noConfig' ? { horizontal: child.align } : { horizontal: 'center' })
      });
      if (!child.prop) return;
      const currentIndex = tableField.indexOf(child.prop);
      const letter = excelDownloadForArea(currentIndex);
      realColArray.push({
        letter,
        field: child.prop,
        length: 0,
        dataType: 'string',
        ...(child.align && child.align !== 'noConfig' ? { horizontal: child.align } : { horizontal: 'center' })
      });
    });
  };

  // 获取需要导出的列配置项
  getRealHeadAndCol(list);
  // 获取表格最大层级
  for (let i = 0; i < realTableHead.length; i++){
      if (realTableHead[i].level > maxLevel){
          maxLevel = realTableHead[i].level;
      }
  }
  // 处理表头占用单元格以及样式
  <@tableHead></@tableHead>
  // 调用exceljs导出方法
  workbook.xlsx.writeBuffer().then(function (buffer) {
    saveAs(new Blob([buffer], {
        type: 'application/octet-stream'
    }), fileName);
  });
  ${asyncBodyCode!}
}

exportDataFun();
