/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.internet.visitor.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.dataitem.reference.QuoteBO;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.defaultvalue.DefaultValueAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.formcheck.ELFormCheckAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.formcheck.ELFormCheckItemAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.showconfig.ShowConfigAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.showconfig.ShowConfigItemInfo;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.table.TableOptColsAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.AsyncActionUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.DefaultValueUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.ElementCheckUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.ReplaceDataUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.common.constant.TriggerType;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.runner.formcheck.FormCheckInfo;
import com.jxdinfo.hussar.formdesign.common.runner.formcheck.FormCheckObject;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.BaseProvideVisitor;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class NetXFormVisitor
implements VoidVisitor {
    private final FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("/template/internet/component/form/form.ftl");
        this.renderMethod(lcdpComponent, ctx);
        this.renderFormData(lcdpComponent, ctx);
    }

    private void renderLoad(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        List showConfigAnalyses = ReplaceDataUtil.getReplaceDataInfo((LcdpComponent)lcdpComponent, (String)"dataLoadConfig");
        HashMap<String, Object> replaceDataMap = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty((Object)showConfigAnalyses) && ToolUtil.isNotEmpty((Object)((ShowConfigAnalysis)showConfigAnalyses.get(0)).getDataModelId())) {
            List showConfigItemInfos = ReplaceDataUtil.handlerShowConfigs((Ctx)ctx, (List)showConfigAnalyses);
            showConfigItemInfos.forEach(itemInfo -> {
                if (ToolUtil.isNotEmpty((Object)itemInfo.getQueryObjectAttr())) {
                    itemInfo.setQueryObjectAttrList(ToolUtil.stringToList((String)itemInfo.getQueryObjectAttr()));
                }
            });
            replaceDataMap.put("showConfigItemInfos", showConfigItemInfos.get(0));
            replaceDataMap.put("instanceKey", lcdpComponent.getInstanceKey());
            replaceDataMap.put("importName", ((ShowConfigItemInfo)showConfigItemInfos.get(0)).getImportName());
            replaceDataMap.put("queryObjectAttrList", ((ShowConfigItemInfo)showConfigItemInfos.get(0)).getQueryObjectAttrList());
            replaceDataMap.put("importMethod", ((ShowConfigItemInfo)showConfigItemInfos.get(0)).getImportMethod());
            replaceDataMap.put("mappingMap", ((ShowConfigItemInfo)showConfigItemInfos.get(0)).getMappingRelates());
            ValueVisitor valueVisitor = (ValueVisitor)lcdpComponent.getProvideVisitor("value");
            valueVisitor.visit(lcdpComponent, ctx, null);
            replaceDataMap.put("insValue", valueVisitor.getDataItemValue(null).getRenderValue());
            ArrayList<String> callbackParamS = new ArrayList<String>();
            callbackParamS.add("customExceptionCallback");
            callbackParamS.add("sysExceptionCallback");
            callbackParamS.add("callback");
            String returnValue = lcdpComponent.getInstanceKey() + CodeSuffix._DATA_LOAD.getType() + CodeSuffix._RETURN_DATA.getType();
            replaceDataMap.put("returnValue", returnValue);
            ctx.addMethod(lcdpComponent.getInstanceKey() + "DataLoad", callbackParamS, RenderUtil.renderTemplate((String)"/template/internet/component/form/elForm_dataLoad.ftl", replaceDataMap));
            ctx.addMounted("this." + lcdpComponent.getInstanceKey() + "DataLoad()");
            ctx.addData(returnValue + ":{}");
        }
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        List showConfigAnalyses = ReplaceDataUtil.getReplaceDataInfo((LcdpComponent)lcdpComponent, (String)"showConfigs");
        this.renderFormQuery(lcdpComponent, ctx, showConfigAnalyses);
        this.renderReplaceData(lcdpComponent, ctx, showConfigAnalyses);
        this.renderLoad(lcdpComponent, ctx);
        this.renderCheckRule(lcdpComponent, ctx);
    }

    private void renderCheckRule(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        List elFormCheckAnalyses;
        Object formCheckInfo = lcdpComponent.getProps().get("formCheck");
        if (ToolUtil.isNotEmpty(formCheckInfo) && (elFormCheckAnalyses = (List)JSON.parseObject((String)JSON.toJSONString(formCheckInfo), (TypeReference)new TypeReference<List<ELFormCheckAnalysis>>(){}, (Feature[])new Feature[0])).size() > 0) {
            Map formCheckMap = FormCheckInfo.formCheckMap;
            ArrayList<JSONObject> checkFunctions = new ArrayList<JSONObject>();
            for (ELFormCheckAnalysis elFormCheckAnalysis : elFormCheckAnalyses) {
                HashMap<String, Object> ruleMap = new HashMap<String, Object>();
                String methodName = lcdpComponent.getInstanceKey() + StringUtils.capitalize((String)elFormCheckAnalysis.getId());
                ArrayList<JSONObject> formCheckObjects = new ArrayList<JSONObject>();
                for (ELFormCheckItemAnalysis elFormCheckItemAnalysis : elFormCheckAnalysis.getCheckTypes()) {
                    List customFunctionRes;
                    FormCheckObject formCheckObject = (FormCheckObject)formCheckMap.get(elFormCheckItemAnalysis.getCheckType());
                    if (!ToolUtil.isNotEmpty((Object)formCheckObject)) continue;
                    JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)formCheckObject));
                    if (ToolUtil.isNotEmpty((Object)elFormCheckItemAnalysis.getErrorMsg())) {
                        String errorMsg = elFormCheckItemAnalysis.getErrorMsg();
                        if (errorMsg.contains("${\u5217\u540d}")) {
                            String title = this.getTitleByField(lcdpComponent, elFormCheckAnalysis.getCheckFormCol());
                            errorMsg = errorMsg.replaceAll("\\$\\{\u5217\u540d}", title);
                        }
                        jsonObject.put("errorMsg", (Object)errorMsg);
                    } else {
                        jsonObject.put("errorMsg", (Object)"");
                    }
                    jsonObject.put("customValue", (Object)elFormCheckItemAnalysis.getCheckValue());
                    if (ToolUtil.isNotEmpty((Object)elFormCheckItemAnalysis.getCustomFunction()) && (customFunctionRes = ElementCheckUtil.dealCustomFunction((List)elFormCheckItemAnalysis.getCustomFunction(), (Ctx)ctx)).size() > 0) {
                        jsonObject.putAll((Map)customFunctionRes.get(0));
                    }
                    formCheckObjects.add(jsonObject);
                }
                ruleMap.put("checkList", formCheckObjects);
                ruleMap.put("field", elFormCheckAnalysis.getCheckFormCol());
                RenderCore renderCore = new RenderCore();
                renderCore.registerParam(ruleMap);
                renderCore.registerTemplatePath("/template/internet/component/form/form_checkMethod.ftl");
                RenderResult renderResult = renderCore.render();
                if (!renderResult.isStatus()) continue;
                ArrayList<String> args = new ArrayList<String>();
                args.add("value");
                String str = "async " + methodName;
                ctx.addMethod(str, args, renderResult.getRenderString());
                JSONObject singleFunc = new JSONObject();
                singleFunc.put("field", (Object)elFormCheckAnalysis.getCheckFormCol());
                singleFunc.put("methodName", (Object)methodName);
                JSONArray componentCols = (JSONArray)lcdpComponent.getProps().get("component_cols");
                for (Object col : componentCols) {
                    if (!elFormCheckAnalysis.getCheckFormCol().equals(((JSONObject)col).getString("field"))) continue;
                    singleFunc.put("id", (Object)((JSONObject)col).getString("id"));
                }
                Map<String, List<String>> referComponents = this.dealAllComponentReference(lcdpComponent, ctx);
                if (ToolUtil.isNotEmpty(referComponents) && ToolUtil.isNotEmpty(referComponents.get(elFormCheckAnalysis.getCheckFormCol()))) {
                    singleFunc.put("verifyKeys", referComponents.get(elFormCheckAnalysis.getCheckFormCol()));
                }
                checkFunctions.add(singleFunc);
            }
            HashMap<String, Object> resultMethod = new HashMap<String, Object>();
            resultMethod.put("checkArray", checkFunctions);
            resultMethod.put("formIns", lcdpComponent.getInstanceKey());
            RenderCore renderCore = new RenderCore();
            renderCore.registerParam(resultMethod);
            renderCore.registerTemplatePath("/template/internet/component/form/form_checkResultHandler.ftl");
            RenderResult renderResult = renderCore.render();
            if (renderResult.isStatus()) {
                ArrayList<String> args = new ArrayList<String>(2);
                args.add("name");
                ctx.addMethod(lcdpComponent.getInstanceKey() + CodeSuffix._FORM_VERIFY, args, renderResult.getRenderString());
            }
        }
    }

    private Map<String, List<String>> dealAllComponentReference(LcdpComponent formComponent, Ctx ctx) {
        HashMap<String, List<String>> resMap = new HashMap<String, List<String>>();
        if (ToolUtil.isNotEmpty((Object)ctx.getComponentMap())) {
            ctx.getComponentMap().values().forEach(curComponent -> {
                if (ToolUtil.isNotEmpty((Object)curComponent.getProps()) && ToolUtil.isNotEmpty(curComponent.getProps().get("reference"))) {
                    JSONArray quotes = (JSONArray)curComponent.getProps().get("reference");
                    ValueVisitor quoteVisitor = (ValueVisitor)formComponent.getProvideVisitor("value");
                    try {
                        formComponent.accept((BaseProvideVisitor)quoteVisitor, ctx, null);
                        Map colMappings = quoteVisitor.getComponentColMapping();
                        List quoteBOS = JSON.parseArray((String)quotes.toJSONString(), QuoteBO.class);
                        if (ToolUtil.isNotEmpty((Object)quoteBOS)) {
                            quoteBOS.forEach(quoteBO -> {
                                String quoteKey;
                                if (ToolUtil.isNotEmpty((Object)quoteBO.getComponentQuote()) && ToolUtil.isNotEmpty((Object)quoteBO.getComponentQuote().getInstanceKey()) && (quoteKey = quoteBO.getComponentQuote().getInstanceKey()).equals(formComponent.getInstanceKey()) && quoteBO.getComponentQuote().getInstanceData().size() == 2) {
                                    String fieldId = (String)quoteBO.getComponentQuote().getInstanceData().get(1);
                                    String field = (String)colMappings.get(fieldId);
                                    if (ToolUtil.isEmpty(resMap.get(field))) {
                                        resMap.put(field, new ArrayList());
                                    }
                                    ((List)resMap.get(field)).add(curComponent.getInstanceKey());
                                }
                            });
                        }
                    }
                    catch (LcdpException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return resMap;
    }

    private JSONObject getVerifyComponent(List<JSONObject> componentList, String id) {
        for (JSONObject lcdpComponent : componentList) {
            boolean haveReference = ToolUtil.isNotEmpty((Object)lcdpComponent.getJSONObject("props")) && ToolUtil.isNotEmpty((Object)lcdpComponent.getJSONObject("props").get((Object)"reference"));
            if (!haveReference) continue;
            JSONArray referenceArr = (JSONArray)lcdpComponent.getJSONObject("props").get((Object)"reference");
            for (Object referenceItem : referenceArr) {
                JSONObject componentQuote = ((JSONObject)referenceItem).getJSONObject("componentQuote");
                JSONObject specialQuote = ((JSONObject)referenceItem).getJSONObject("specialQuote");
                JSONArray componentQuoteData = componentQuote.getJSONArray("instanceData");
                JSONArray specialQuoteData = specialQuote.getJSONArray("instanceData");
                boolean canReturn = componentQuoteData.size() == 2 && "data".equals(componentQuoteData.get(0)) && id.equals(componentQuoteData.get(1)) || specialQuoteData.size() == 2 && "data".equals(specialQuoteData.get(0)) && id.equals(specialQuoteData.get(1));
                if (!canReturn) continue;
                return lcdpComponent;
            }
        }
        return null;
    }

    public String getTitleByField(LcdpComponent lcdpComponent, String field) {
        List tableOptColsAnalyses;
        JSONArray optColsJSONArray = (JSONArray)lcdpComponent.getProps().get("component_cols");
        if (ToolUtil.isNotEmpty((Object)optColsJSONArray) && ToolUtil.isNotEmpty((Object)(tableOptColsAnalyses = JSON.parseArray((String)optColsJSONArray.toJSONString(), TableOptColsAnalysis.class)))) {
            for (TableOptColsAnalysis col : tableOptColsAnalyses) {
                if (!ToolUtil.isNotEmpty((Object)col.getField()) || !col.getField().equals(field)) continue;
                return col.getTitle();
            }
        }
        return "";
    }

    private void renderFormQuery(LcdpComponent lcdpComponent, Ctx ctx, List<ShowConfigAnalysis> showConfigAnalyses) throws Exception {
        String formDataModelID;
        DataSModelAnalysis formDataModel;
        DataSAnalysis formDataS;
        ComponentReference componentReference;
        ComponentData data;
        Map datamodel;
        JSONObject reference;
        HashMap<String, Object> map = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/internet/component/form/form_load.ftl");
        String apiFilePath = "";
        String operationName = "formQuery";
        String apiFileName = "";
        String dataModelPrimary = "businessId";
        JSONObject datas = JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()));
        if (ToolUtil.isNotEmpty((Object)datas) && ToolUtil.isNotEmpty((Object)datas.get((Object)"datamodel")) && ToolUtil.isNotEmpty((Object)(reference = (JSONObject)(datamodel = (Map)datas.get((Object)"datamodel")).get("businessIdData"))) && null != (data = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)(componentReference = (ComponentReference)JSON.parseObject((String)reference.toString(), ComponentReference.class))))) {
            map.put("componentReference", data.getRenderValue());
        }
        if (ToolUtil.isNotEmpty((Object)(formDataS = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class))) && ToolUtil.isNotEmpty((Object)(formDataModel = formDataS.getDatamodel())) && ToolUtil.isNotEmpty((Object)(formDataModelID = formDataModel.getDataModelId())) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)formDataModelID))) {
            apiFilePath = this.fileMappingService.getImportPath(formDataModelID);
            apiFileName = this.fileMappingService.getFileName(formDataModelID);
        }
        if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
            ctx.addImports("*", apiFileName, apiFilePath);
        }
        map.put("importName", apiFileName);
        map.put("importMethod", operationName);
        map.put("insForm", lcdpComponent.getInstanceKey() + CodeSuffix._FORM_DATA.getType());
        map.put("oldForm", lcdpComponent.getInstanceKey() + CodeSuffix._FORM_DATA.getType() + "OLD");
        map.put("instanceKey", lcdpComponent.getInstanceKey());
        map.put("dataModelPrimary", dataModelPrimary);
        map.put("callbackCodeWithoutData", AsyncActionUtil.getCallbackCodeWithoutData((String)"\u8868\u5355"));
        map.put("callbackCode", "if (callback && typeof callback === 'function') {callback();}");
        if (lcdpComponent.haveTriggerByTriggerName(TriggerType._FORM_LOADED.getType())) {
            map.put("isLoadedEvent", true);
        }
        if (ToolUtil.isNotEmpty(showConfigAnalyses) && showConfigAnalyses.get(0).isConfigComplete()) {
            map.put("isShowConfig", true);
        }
        renderCore.registerParam(map);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ArrayList<String> callbacks = new ArrayList<String>();
            callbacks.add("callback");
            callbacks.add("formId");
            ctx.addMethod(lcdpComponent.getInstanceKey() + "FormLoad", callbacks, renderResult.getRenderString());
        }
    }

    private static boolean isReferenceConfig(ComponentReference reference) {
        if (DataFromEnum.INSTANCE.getValue().equals(reference.getType())) {
            return ToolUtil.isNotEmpty((Object)reference.getInstanceKey()) && ToolUtil.isNotEmpty((Object)reference.getInstanceData());
        }
        if (DataFromEnum.CALCULATE.getValue().equals(reference.getType())) {
            if (ToolUtil.isEmpty((Object)reference.getFormula())) {
                return false;
            }
            List referIds = reference.getCalData();
            if (ToolUtil.isNotEmpty((Object)referIds)) {
                for (ComponentReference calculateAttribute : referIds) {
                    if (ToolUtil.isEmpty((Object)calculateAttribute.getType())) {
                        return false;
                    }
                    if (!(DataFromEnum.INSTANCE.getValue().equals(calculateAttribute.getType()) ? ToolUtil.isEmpty((Object)calculateAttribute.getInstanceData()) || ToolUtil.isEmpty((Object)calculateAttribute.getInstanceKey()) : ToolUtil.isEmpty((Object)calculateAttribute.getConfigData()))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private void renderFormData(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        HashMap<String, List> params = new HashMap<String, List>();
        ArrayList<String> fields = new ArrayList<String>();
        JSONArray optColsJSONArray = (JSONArray)lcdpComponent.getProps().get("component_cols");
        if (ToolUtil.isNotEmpty((Object)optColsJSONArray)) {
            HashMap nameMap = new HashMap();
            for (Object o : optColsJSONArray) {
                Map map = (Map)o;
                LcdpComponent myLcdpComponent = (LcdpComponent)ctx.getComponentMap().get(map.get("instanceKey"));
                if (!ToolUtil.isNotEmpty((Object)myLcdpComponent)) continue;
                nameMap.put(map.get("id"), myLcdpComponent.getName());
            }
            List tableOptColsAnalyses = JSON.parseArray((String)optColsJSONArray.toJSONString(), TableOptColsAnalysis.class);
            if (ToolUtil.isNotEmpty((Object)tableOptColsAnalyses)) {
                for (TableOptColsAnalysis col : tableOptColsAnalyses) {
                    if (!ToolUtil.isNotEmpty((Object)col.getField())) continue;
                    if (ToolUtil.isNotEmpty(nameMap) && "com.jxdinfo.elementui.JXDElDateTimePicker".equals(nameMap.get(col.getId())) && ToolUtil.isNotEmpty((Object)col.getDefaultValue()) && "time".equals(col.getDefaultValue().getValue())) {
                        col.getDefaultValue().setValue("datetime");
                    }
                    fields.add(col.getField() + " :" + this.getDefaultValue(col, ctx));
                }
            }
            params.put("optCols", tableOptColsAnalyses);
        }
        params.put("relateInsFields", fields);
        RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._FORM_DATA.getType(), Collections.singletonList("data"), (String)RenderUtil.renderTemplate((String)"/template/internet/component/form/form_data.ftl", params));
        ctx.addData(lcdpComponent.getInstanceKey() + "FormCheck:" + RenderUtil.renderTemplate((String)"/template/internet/component/form/form_check.ftl", params));
    }

    private Object getDefaultValue(TableOptColsAnalysis col, Ctx ctx) throws Exception {
        Object result = "''";
        String defaultValue = "''";
        if (ToolUtil.isNotEmpty((Object)col)) {
            DefaultValueAnalysis defaultValueAnalysis = col.getDefaultValue();
            defaultValue = DefaultValueUtil.renderDefaultValue((DefaultValueAnalysis)defaultValueAnalysis, (String)col.getDataType(), (Ctx)ctx);
            if (ToolUtil.isNotEmpty((Object)defaultValueAnalysis) && defaultValueAnalysis.isDefaultValue()) {
                String defaultFrom = defaultValueAnalysis.getDefaultValueType();
                if (ToolUtil.isNotEmpty((Object)defaultFrom) && DataFromEnum.SYSTEM.getValue().equals(defaultFrom)) {
                    if (!ctx.getMethods().containsKey("format")) {
                        HashMap params = new HashMap();
                        ArrayList<String> param = new ArrayList<String>();
                        param.add("data");
                        param.add("type");
                        ctx.addImports("dateFormatPublic", "@/pages/index/utils/lowcode/dateFormatUtil");
                        ctx.addMethod("format", param, RenderUtil.renderTemplate((String)"/template/internet/component/datePicker/initDate.ftl", params), true);
                    }
                    result = defaultValue;
                } else if (DataFromEnum.INPUT.getValue().equals(defaultFrom)) {
                    result = "true".equals(defaultValue = defaultValue.replace("'", "")) || "false".equals(defaultValue) ? Boolean.valueOf(Boolean.parseBoolean(defaultValue)) : "'" + defaultValue + "'";
                } else if (DataFromEnum.SESSION.getValue().equals(defaultFrom)) {
                    result = defaultValue;
                } else if ("formula".equals(defaultFrom)) {
                    result = defaultValue;
                }
            } else {
                result = defaultValue;
            }
        }
        if ("null".equals(defaultValue)) {
            result = "''";
        }
        return result;
    }

    private void renderReplaceData(LcdpComponent lcdpComponent, Ctx ctx, List<ShowConfigAnalysis> showConfigAnalyses) throws Exception {
        HashMap<String, Object> replaceDataMap = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty(showConfigAnalyses) && showConfigAnalyses.get(0).isConfigComplete()) {
            List showConfigItemInfos = ReplaceDataUtil.handlerShowConfigs((Ctx)ctx, showConfigAnalyses);
            replaceDataMap.put("showConfigItemInfos", showConfigItemInfos);
            replaceDataMap.put("instanceKey", lcdpComponent.getInstanceKey());
            ValueVisitor valueVisitor = (ValueVisitor)lcdpComponent.getProvideVisitor("value");
            valueVisitor.visit(lcdpComponent, ctx, null);
            String formValue = valueVisitor.getDataItemValue(null).getRenderValue();
            replaceDataMap.put("formData", formValue);
            for (ShowConfigItemInfo showConfigItemInfo : showConfigItemInfos) {
                if (!ToolUtil.isNotEmpty((Object)showConfigItemInfo.getTableFieldWhere())) continue;
                HashMap<String, String> replaceWatchData = new HashMap<String, String>();
                replaceWatchData.put("formIns", lcdpComponent.getInstanceKey());
                String methodName = "\"" + formValue.replace(CodePrefix._THIS.getType(), "") + CodeSuffix._POINT.getType() + showConfigItemInfo.getTableFieldWhere() + "\"";
                String dataName = valueVisitor.getDataItemValue(null).getRenderValue();
                replaceDataMap.put("dataName", dataName);
                ctx.addWatch(methodName, RenderUtil.renderTemplate((String)"/template/internet/component/form/form_watchReplace.ftl", replaceWatchData));
            }
            String dataName = valueVisitor.getDataItemValue(null).getRenderValue();
            replaceDataMap.put("dataName", dataName);
            ArrayList<String> convert = new ArrayList<String>();
            convert.add("convert");
            ctx.addAsyncMethod(lcdpComponent.getInstanceKey() + CodeSuffix._REPLACE_DATA.getType(), convert, RenderUtil.renderTemplate((String)"/template/internet/component/form/form_replaceDataMethod.ftl", replaceDataMap));
        }
    }
}

