/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.internet.event;

import com.jxdinfo.hussar.formdesign.base.common.analysismodel.showconfig.ShowConfigAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.ReplaceDataUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionVisitor;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.internetcomponent.LoadTableAction")
public class InitTable
implements ActionVisitor {
    public void visitor(Action action, Ctx ctx) throws Exception {
        HashMap<String, String> encapsulationValueMap = new HashMap<String, String>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/internet/event/initTable.ftl");
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        encapsulationValueMap.put("trigger", triggerName);
        Map params = action.getParamValues();
        String tableId = String.valueOf(params.get("loadTable"));
        if (ToolUtil.isNotEmpty((Object)tableId)) {
            encapsulationValueMap.put("tableIns", tableId);
        }
        renderCore.registerParam(encapsulationValueMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod(trigger, triggerName, renderResult.getRenderString());
        }
        String currentableEditInstanceKey = action.getParamValues().entrySet().iterator().next().getValue().toString();
        Map lcdpComponent = ctx.getComponentMap();
        for (Map.Entry entry : lcdpComponent.entrySet()) {
            LcdpComponent entryLcdpComponent = (LcdpComponent)entry.getValue();
            if (!currentableEditInstanceKey.equals(entryLcdpComponent.getInstanceKey())) continue;
            List showConfigAnalyses = ReplaceDataUtil.getReplaceDataInfo((LcdpComponent)entryLcdpComponent, (String)"showConfigs");
            this.renderTableInit(entryLcdpComponent, ctx, showConfigAnalyses);
        }
    }

    private void renderTableInit(LcdpComponent lcdpComponent, Ctx ctx, List<ShowConfigAnalysis> showConfigAnalyses) throws LcdpException {
        HashMap<String, Object> tableInitMap = new HashMap<String, Object>();
        tableInitMap.put("instanceKey", lcdpComponent.getInstanceKey());
        ArrayList<String> valueItem = new ArrayList<String>();
        valueItem.add("value");
        if (!ComponentDataUtil.ComponentValueStatusEnum.NONE.equals((Object)ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, valueItem))) {
            tableInitMap.put("referenceData", "exist");
        }
        if (ToolUtil.isNotEmpty(showConfigAnalyses) && showConfigAnalyses.get(0).isConfigComplete()) {
            tableInitMap.put("replaceData", true);
            LcdpComponent editTableIns = (LcdpComponent)ctx.getComponentMap().get(lcdpComponent.getInstanceKey());
            ValueVisitor valueVisitor = (ValueVisitor)editTableIns.getProvideVisitor("value");
            valueVisitor.visit(editTableIns, ctx, null);
            String dataName = valueVisitor.getDataItemValue(null).getRenderValue();
            tableInitMap.put("dataName", dataName);
        }
        ctx.addMethod(lcdpComponent.getInstanceKey() + CodeSuffix._TABLE_INTI.getType(), RenderUtil.renderTemplate((String)"/template/internet/component/table/initTable.ftl", tableInitMap));
    }
}

