<#macro colTree colList>
    <#list colList as item>
        <#if item.isParent??>
            ++level;
            <@colTree colList=item.children></@colTree>
            tableHead.push({
                "title" : '${item.title!}',
                "horizontal" : '${item.align!}',
                "colspan" : ${item.colspan!1},
                "rowspan" : ${item.rowspan!1},
                "level" : level
            });
        <#else>
            tableHead.push({
                "title" : '${item.title!}',
                "horizontal" : '${item.align!}',
                "colspan" : ${item.colspan!1},
                "rowspan" : <#if item.rowspan??>${item.rowspan}<#else>${maxRowSpan!1}</#if>,
                "level" : level
            });
            const ${item.field!}Index = tableField.indexOf('${item.field!}');
            let ${item.field!}Letter = excelDownloadForArea(${item.field!}Index);
            <#if item.dataType! == 'date'>
                colArray.push({
                    "letter": ${item.field!}Letter,
                    "horizontal": '${item.bodyAlign!}',
                    "dataType": "date"
                });
            <#elseif item.dataType! == 'number' || item.dataType! == 'int' || item.dataType! == 'double' || item.dataType! == 'long'>
                colArray.push({
                    "letter": ${item.field!}Letter,
                    "horizontal": '${item.bodyAlign!}',
                    "dataType": "number"
                });
            <#else>
                colArray.push({
                    "letter": ${item.field!}Letter,
                    "horizontal": '${item.bodyAlign!}',
                    "dataType": "string"
                });
            </#if>
        </#if>
    </#list>
    --level;
</#macro>

<#macro tableHead>
    for (let i = 0; i < tableHead.length; i++){
        if (tableHead[i].rowspan + tableHead[i].level - 1> maxLevel){
            tableHead[i].rowspan = maxLevel - tableHead[i].level + 1;
        }
    }
    let excelCell = [];
    let rows = [];
    for (let i = 0;i < tableField.length; i++){
        for (let j = 0; j < maxLevel; j++){
            let cell = {"xAxis":i,"yAxis":j,isEdit:false};
            excelCell.push(cell);
        }
    }
    for (let i = 0;i < maxLevel; i++){
        let x = 0;
        let row = [];
        for (let j=0;j < tableHead.length; j++){
            let index = excelCell.findIndex(function(value, index, arr) {
                return value.isEdit === false && value.yAxis === i;
            });
            if (index != -1) {
                x = excelCell.find(function(value, index, arr) {
                    return value.isEdit === false && value.yAxis === i;
                }).xAxis;
            }
            if ( tableHead[j].level - 1 === i){
        let startArea = excelDownloadForArea(x) + (1 + i);
        let endArea = excelDownloadForArea(x + tableHead[j].colspan - 1) + (tableHead[j].rowspan + i);
        for (let k = x; k < x + tableHead[j].colspan; k++){
                    for (let m = i;m < tableHead[j].rowspan + i; m++){
                        excelCell.find(function(value, index, arr) {
                            return value.xAxis === k && value.yAxis === m;
                        }).isEdit = true;
                    }
                }
                while (row.length < x){
                    row.push("");
                }
                row[x] = tableHead[j].title;
                tableHead[j].merge = startArea + ":" + endArea;
            }
        }
        rows.push(row);
    }
    worksheet.insertRows(1, rows);
    for (let j=0;j < tableHead.length; j++){
        worksheet.mergeCells(tableHead[j].merge);
        worksheet.getCell(tableHead[j].merge.split(":")[0]).alignment = {
            vertical: 'middle',
            horizontal: tableHead[j].horizontal
        };
    }
    for (let i = 0; i < colArray.length; i++){
        for (let j = maxLevel + 1; j < 1000; j++) {
            worksheet.getCell(colArray[i].letter + j).alignment = { horizontal: colArray[i].horizontal };
            if (colArray[i].dataType === "date"){
                worksheet.getCell(colArray[i].letter+j).dataValidation = {
                    type: 'date',
                    operator: 'between',
                    showErrorMessage: true,
                    allowBlank: true,
                    formulae: [new Date(1900, 1, 1),new Date(2100, 1, 1)],
                    showInputMessage: true,
                    promptTitle: '日期',
                    prompt: '请输入日期格式数据'
                };
            }
            else if (colArray[i].dataType === "number"){
                worksheet.getCell(colArray[i].letter+j).dataValidation = {
                    type: 'decimal',
                    allowBlank: true,
                    showErrorMessage: true,
                    showInputMessage: true,
                    promptTitle: '数字',
                    prompt: '请输入数字格式数据'
                };
            }
        }
    }
</#macro>

<#if componentName?? && componentName != "">
    let tableData = [
        <#list tableFields! as item>
            <#if (item_index != (tableFields?size-1))>
                "${item.title}",
            <#else>
                "${item.title}"
            </#if>
        </#list>
    ];
    let tableField = [
        <#list tableFields! as item>
            <#if (item_index != (tableFields?size-1))>
                "${item.field}",
            <#else>
                "${item.field}"
            </#if>
        </#list>
    ];
    let columns = [];
    for (let i = 0; i < tableData.length ; i++){
        let excelCol = {};
        //excelCol.header = tableData[0][i];
        excelCol.key = tableField[i];
        excelCol.width = 30;
        columns.push(excelCol);
    }
    const Excel = require("exceljs");
    let workbook = new Excel.Workbook();
    let worksheet = workbook.addWorksheet("sheet1");
    const fileName = "data.xlsx";
    workbook.created = new Date();
    workbook.modified = new Date();
    worksheet.columns = columns;
    let colArray = [];
    let tableHead = [];
    let level = 1;
    let maxLevel = 1;
    <@colTree colList=tableShowFields!></@colTree>
    for (let i = 0; i < tableHead.length; i++){
        if (tableHead[i].level > maxLevel){
            maxLevel = tableHead[i].level;
        }
    }
    <#if isHiddenCols?? && isHiddenCols!>
        <#list tableHiddenFields as item>
        tableHead.push({
            "title" : '${item.title!}',
            "horizontal" : '${item.align!"center"}',
            "colspan" : 1,
            "rowspan" : maxLevel,
            "level" : 1
        });
        const ${item.field!}Index = tableField.indexOf('${item.field!}');
        let ${item.field!}Letter = excelDownloadForArea(${item.field!}Index);
            <#if item.dataType! == 'date'>
            colArray.push({
                "letter": ${item.field!}Letter,
                "horizontal": '${item.bodyAlign!"center"}',
                "dataType": "date"
            });
            <#elseif item.dataType! == 'number' || item.dataType! == 'int' || item.dataType! == 'double'>
            colArray.push({
                "letter": ${item.field!}Letter,
                "horizontal": '${item.bodyAlign!"center"}',
                "dataType": "number"
            });
            <#else>
            colArray.push({
                "letter": ${item.field!}Letter,
                "horizontal": '${item.bodyAlign!"center"}',
                "dataType": "string"
            });
            </#if>
        </#list>
    </#if>
    <@tableHead></@tableHead>
    <#if showConfigItemInfos??>
        <#list showConfigItemInfos! as item>
            const dict${item_index} = [];
            const ${item.importName!}Obj${item_index} = {
                inValues: '',
                typeName: '${item.dictType!}',
                ${item.queryObjectAttr!}
            };
            const res${item_index} = await ${item.importName!}.${item.importMethod!}(${item.importName!}Obj${item_index}).catch(function () {
               HussarRouter.showMsg(self, "数据请求异常", 'error');
            });
            const data${item_index} = res${item_index}.data;
            if ((res${item_index}.code === 200 || res${item_index}.code === 10000) && data${item_index}) {
                if (data${item_index}.data && data${item_index}.data.length > 0) {
                    <#list item.mappingRelates! as mapping>
                        const ${mapping.relateField} = [];
                        for (let i = 0; i < data${item_index}.data.length; i++) {
                            ${mapping.relateField}.push(data${item_index}.data[i].${mapping.relateField});
                        }
                        dict${item_index}[${mapping_index}] = ['"' + ${mapping.relateField}.join(",") + '"'];
                    </#list>
                }
            } else {
               HussarRouter.showMsg(self, "数据展示数据请求失败", 'error');
            }
            <#if item.tableFieldWhere?? && item.tableFieldWhere != "">
                <#list item.mappingRelates! as mapping>
                    const field${item_index}${mapping_index} = '${mapping.field!}';
                    const index${item_index}${mapping_index} = tableField.indexOf(field${item_index}${mapping_index});
                    const letter${item_index}${mapping_index} = excelDownloadForArea(index${item_index}${mapping_index});
                </#list>
                for (let i = maxLevel + 1; i < 1000; i++) {
                <#list item.mappingRelates! as mapping>
                    worksheet.getCell(letter${item_index}${mapping_index} + i).dataValidation = {
                        type: 'list',
                        allowBlank: true,
                        formulae: dict${item_index}[${mapping_index}]
                    };
                </#list>
                }
            </#if>
        </#list>
    </#if>
    workbook.xlsx.writeBuffer().then(function (buffer) {
        saveAs(new Blob([buffer], {
            type: 'application/octet-stream'
        }), fileName);
    });
</#if>