/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.internet.element;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.factory.InteractiveClassFactory;
import com.jxdinfo.hussar.formdesign.common.factory.StyleFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClassAdapter;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.internet.utils.NetTextAlignForVertical;
import com.jxdinfo.hussar.formdesign.internet.visitor.element.NetButtonVoidVisitor;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class NetButton
extends LcdpComponent {
    @PostConstruct
    public void register() {
        String name = "com.jxdinfo.internetcomponent.NetElButton";
        ClazzFactory.register((String)name, (String)((Object)((Object)this)).getClass().getName());
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"hover", (String)":hover:not(.is-disabled)");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"focus", (String)".button_additional:focus:not(.is-disabled)");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"disabled", (String)":disabled");
        StyleFactory.addComponentClassName((String)name, (String)".net_ins_netButton");
    }

    public VoidVisitor visitor() {
        return new NetButtonVoidVisitor();
    }

    public Map<String, String> styleTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("iconFontWeight", "${prefix} span i{font-weight:${val};}");
        map.put("buttonMarginLeft", "${prefix} {margin-left:${val};}");
        map.put("iconFontSize", "${prefix} span i{font-size:${val};letter-spacing:0;}");
        map.put("itemAlign", "${prefix} > span {align-items:${val};}");
        map.put("itemJustifyContent", "${prefix} > span {justify-content:${val};}");
        map.put("itemDisplay", "${prefix} > span {display:${val};}");
        return map;
    }

    public Map<String, String> propsTemplate() {
        return null;
    }

    public static NetButton newComponent(JSONObject jsonObject) {
        NetButton button = (NetButton)((Object)ClassAdapter.jsonObjectToBean((JSONObject)jsonObject, (String)NetButton.class.getName()));
        Object backgroundImg = button.getStyles().get("backgroundImageBack");
        button.getStyles().remove("backgroundImageBack");
        if (ToolUtil.isNotEmpty(backgroundImg)) {
            button.getStyles().put("backgroundImage", backgroundImg);
        }
        NetTextAlignForVertical.setTextAlign(button, "styles");
        button.getStyles().remove("vertical");
        button.getInnerStyles().put("iconFontWeight", "normal");
        button.getInnerStyles().put("buttonMarginLeft", "0");
        Object fontSize = button.getStyles().get("fontSize");
        button.getInnerStyles().put("iconFontSize", fontSize);
        button.addClassName("button_additional");
        return button;
    }
}

