/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.internet.visitor.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NetElGridLayoutVoidVisitor
implements VoidVisitor {
    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("/template/internet/component/gridLayout/el_gridLayout.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
        this.dealGridMedia(lcdpComponent);
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) {
        JSONObject columnConfig = (JSONObject)lcdpComponent.getProps().get("columnConfig");
        List columnList = JSON.parseArray((String)columnConfig.get((Object)"columnList").toString(), HashMap.class);
        lcdpComponent.addRenderParam("columnList", (Object)columnList);
        lcdpComponent.addRenderParam("instanceKey", (Object)lcdpComponent.getInstanceKey());
        lcdpComponent.addRenderParam("itemGap", lcdpComponent.getProps().get("itemGap"));
        ctx.addData(lcdpComponent.getInstanceKey() + "ColumnConfig:" + columnConfig);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
    }

    public void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("instanceKey", lcdpComponent.getInstanceKey());
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("isSlotAutoHeight")) && ((Boolean)lcdpComponent.getProps().get("isSlotAutoHeight")).booleanValue()) {
            dataMap.put("isSlotAutoHeight", true);
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("itemGap"))) {
            dataMap.put("itemGap", lcdpComponent.getProps().get("itemGap"));
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add("index");
        ctx.addMethod(lcdpComponent.getInstanceKey() + "itemStyle", params, RenderUtil.renderTemplate((String)"/template/internet/component/gridLayout/gridLayout_itemStyle.ftl", dataMap));
    }

    public void dealGridMedia(LcdpComponent lcdpComponent) {
        JSONObject columnConfig = (JSONObject)lcdpComponent.getProps().get("columnConfig");
        int colSize = JSON.parseArray((String)columnConfig.get((Object)"columnList").toString(), HashMap.class).size();
        int lgGrids = 24 / colSize;
        int mdGrids = 24;
        if (colSize == 3 || colSize == 4) {
            mdGrids = 12;
        } else if (colSize == 6) {
            mdGrids = 8;
        } else if (colSize == 8) {
            mdGrids = 6;
        } else if (colSize == 12) {
            mdGrids = 4;
        }
        lcdpComponent.addRenderParam("lgGrids", (Object)lgGrids);
        lcdpComponent.addRenderParam("mdGrids", (Object)mdGrids);
    }
}

