/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.hdkj.visitor.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.DynDataUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HkCarouselVoidVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        List triggers = lcdpComponent.getTriggers();
        lcdpComponent.registerTemplatePath("/template/hkelement/hdkj/HkCarousel/el_carousel.ftl");
        lcdpComponent.addRenderParam("triggers", (Object)triggers);
        String instanceKey = lcdpComponent.getInstanceKey();
        lcdpComponent.addRenderParam("instanceKey", (Object)instanceKey);
        ctx.addData(instanceKey + "Autoplay: " + lcdpComponent.getProps().get("autoplay"));
        ctx.addData(instanceKey + "Interval: " + lcdpComponent.getProps().get("interval"));
        ctx.addData(instanceKey + "IndicatorPosition: '" + lcdpComponent.getProps().get("indicatorPosition") + "'");
        ctx.addData(instanceKey + "Arrow: '" + lcdpComponent.getProps().get("arrow") + "'");
        ctx.addData(instanceKey + "Type: '" + lcdpComponent.getProps().get("type") + "'");
        ctx.addData(instanceKey + "Loop: " + lcdpComponent.getProps().get("loop"));
        ctx.addData(instanceKey + "Direction: '" + lcdpComponent.getProps().get("direction") + "'");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        List carouselList = JSON.parseArray((String)lcdpComponent.getProps().get("carouselList").toString(), HashMap.class);
        JSONObject fromComponentParams = JSON.parseObject((String)String.valueOf(lcdpComponent.getProps().get("formComponentParams")));
        ArrayList fromComponentParamList = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)fromComponentParams)) {
            for (Map.Entry entry : fromComponentParams.entrySet()) {
                HashMap fromComponentParam = new HashMap();
                fromComponentParam.put(entry.getKey(), entry.getValue());
                fromComponentParamList.add(fromComponentParam);
            }
        }
        int index = 0;
        for (HashMap carousel : carouselList) {
            String routePath = "";
            if (!ToolUtil.isNotEmpty(carousel.get("url"))) continue;
            StringBuilder props = new StringBuilder();
            StringBuilder triggers = new StringBuilder();
            JSONObject pageParamConfig = (JSONObject)((HashMap)JSON.parseObject((String)carousel.get("url").toString(), HashMap.class)).get("pageParamConfig");
            List events = lcdpComponent.getEvents();
            String id = ((HashMap)JSON.parseObject((String)carousel.get("url").toString(), HashMap.class)).get("fileId").toString();
            routePath = FileUtil.posixPath((String[])new String[]{this.fileMappingService.getFormatPath(id)});
            String pageName = routePath.substring(routePath.lastIndexOf(47) + 1);
            for (Object entry : events) {
                String eventName = entry.getTrigger();
                String oldName = "";
                List eventTriggers = lcdpComponent.getDynamicEventTriggers();
                for (Object eventTrigger : eventTriggers) {
                    Map e = DynDataUtil.asObject(eventTrigger).orElse(Collections.emptyMap());
                    if (!eventName.equals(e.get("name"))) continue;
                    oldName = String.valueOf(e.get("oName"));
                }
                if (entry.getTrigger().contains(String.valueOf(carousel.get("slotName")))) {
                    String strTrigger = " @" + oldName + " =" + lcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)eventName);
                    triggers.append(strTrigger);
                }
                this.removeTiggers(lcdpComponent, ctx, eventName);
            }
            for (Object entry : pageParamConfig.entrySet()) {
                HashMap<String, Map<String, Object>> moduleMap = new HashMap<String, Map<String, Object>>();
                String key = String.valueOf(entry.getKey());
                JSONObject value = JSON.parseObject((String)JSON.toJSONString(entry.getValue()));
                String propValue = pageName + index + ToolUtil.firstLetterToUpper((String)key);
                if (!ToolUtil.isNotEmpty((Object)value) || !ToolUtil.isNotEmpty(value.get("type"))) continue;
                String strProp = " :" + key + " = " + propValue;
                props.append(strProp);
                Map<String, Object> config = HkCarouselVoidVisitor.getRenderPageParamData(ctx, (Map.Entry<String, Object>)entry);
                if (config.size() > 0) {
                    moduleMap.put("params", config);
                }
                ctx.addComputed(propValue, RenderUtil.renderTemplate((String)"template/hkelement/hdkj/HkCarousel/carousel_props.ftl", moduleMap));
            }
            String refCarousel = " ref='" + pageName + index + "Ref'";
            carousel.put("url", routePath);
            carousel.put("pageName", "<" + pageName + index + refCarousel + props + triggers + " ></" + pageName + index + ">");
            ctx.addImports("import " + pageName.toLowerCase() + index + " from '#/views" + routePath + "'");
            ctx.addComponent(pageName.toLowerCase() + index);
            ++index;
        }
        lcdpComponent.addRenderParam("carousels", (Object)carouselList);
    }

    private void removeTiggers(LcdpComponent lcdpComponent, Ctx ctx, String eventName) {
        lcdpComponent.getTrigger().removeIf(trigger -> trigger.getName().equals(eventName));
    }

    private static Map<String, Object> getRenderPageParamData(Ctx ctx, Map.Entry<String, Object> entry) throws LcdpException {
        HashMap<String, Object> paramConfig = new HashMap<String, Object>();
        ComponentReference componentReference = (ComponentReference)JSON.parseObject((String)entry.getValue().toString(), ComponentReference.class);
        ComponentData data = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)componentReference);
        if (null != data) {
            paramConfig.put(entry.getKey(), data.getRenderValue());
        } else {
            paramConfig.put(entry.getKey(), "''");
        }
        return paramConfig;
    }
}

