/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.hdkj.element;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.factory.InteractiveClassFactory;
import com.jxdinfo.hussar.formdesign.common.factory.StyleFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClassAdapter;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.hdkj.utils.HkTextAlignForVertical;
import com.jxdinfo.hussar.formdesign.hdkj.visitor.element.HkIconButtonVoidVisitor;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class HkIconButton
extends LcdpComponent {
    @PostConstruct
    public void register() {
        String name = "com.jxdinfo.huakecomponent.HkElIconButton";
        ClazzFactory.register((String)name, (String)((Object)((Object)this)).getClass().getName());
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"hover", (String)":hover:not(.is-disabled)");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"focus", (String)".button_additional:active:not(.is-disabled)");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"disabled", (String)":disabled");
        StyleFactory.addComponentClassName((String)name, (String)".hk_ins_hkIconButton");
    }

    public VoidVisitor visitor() {
        return new HkIconButtonVoidVisitor();
    }

    public Map<String, String> styleTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("iconFontWeight", "${prefix} span i{font-weight:${val};}");
        map.put("buttonMarginLeft", "${prefix} {margin-left:${val};}");
        map.put("iconFontSize", "${prefix} span i{font-size:${val};letter-spacing:0;}");
        map.put("itemAlign", "${prefix} > span {align-items:${val};}");
        map.put("itemJustifyContent", "${prefix} > span {justify-content:${val};}");
        map.put("itemDisplay", "${prefix} > span {display:${val};}");
        return map;
    }

    public static HkIconButton newComponent(JSONObject jsonObject) {
        HkIconButton button = (HkIconButton)((Object)ClassAdapter.jsonObjectToBean((JSONObject)jsonObject, (String)HkIconButton.class.getName()));
        Object backgroundImg = button.getStyles().get("backgroundImageBack");
        button.getStyles().remove("backgroundImageBack");
        if (ToolUtil.isNotEmpty(backgroundImg)) {
            button.getStyles().put("backgroundImage", backgroundImg);
        }
        HkTextAlignForVertical.setTextAlign(button, "styles");
        button.getStyles().remove("vertical");
        button.getInnerStyles().put("iconFontWeight", "normal");
        button.getInnerStyles().put("buttonMarginLeft", "0");
        Object fontSize = button.getStyles().get("fontSize");
        button.getInnerStyles().put("iconFontSize", fontSize);
        button.addClassName("button_additional");
        return button;
    }
}

