/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.hdkj.element;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.utils.EventPreHandler;
import com.jxdinfo.hussar.formdesign.common.factory.InteractiveClassFactory;
import com.jxdinfo.hussar.formdesign.common.factory.ModifierFactory;
import com.jxdinfo.hussar.formdesign.common.factory.StyleFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClassAdapter;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.DefaultStyle;
import com.jxdinfo.hussar.formdesign.hdkj.visitor.element.HKInputVoidVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class HKInput
extends LcdpComponent {
    @PostConstruct
    public void register() {
        String name = "com.jxdinfo.huakecomponent.HKInput";
        ClazzFactory.register((String)name, (String)((Object)((Object)this)).getClass().getName());
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"hover", (String)":hover:not(.is-disabled):not(.checkBad):not(.jxd_ins_hkInputReadonly):not(:focus-within)");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"focus", (String)":focus-within:not(.checkBad):not(.jxd_ins_hkInputReadonly)");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"disabled", (String)".el-input.is-disabled");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"checkBad", (String)".checkBad:not(.jxd_ins_hkInputReadonly)");
        ModifierFactory.addComponentEventModifier((String)name, (String)"click", (String)"native");
        StyleFactory.addComponentClassName((String)name, (String)".jxd_ins_hkInput");
    }

    public VoidVisitor visitor() {
        return new HKInputVoidVisitor();
    }

    public Map<String, String> styleTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("backgroundImage", "${prefix} input{background-image:${val};}");
        map.put("backgroundPosition", "${prefix} input{background-position:${val};}");
        map.put("backgroundSize", "${prefix} input{background-size:${val};}");
        map.put("backgroundRepeat", "${prefix} input{background-repeat:${val};}");
        map.put("height", "${prefix} input{height:${val};}");
        map.put("padding", "${prefix} input{padding:${val};}");
        map.put("backgroundColor", "${prefix} input,${prefix} .el-input__count-inner{background-color:${val};}");
        map.put("placeholderColor", "${prefix} input::-webkit-input-placeholder{color:${val};}");
        map.put("placeholderFontSize", "${prefix} input::-webkit-input-placeholder{font-size:${val};}");
        map.put("placeholderTextAlign", "${prefix} input::-webkit-input-placeholder{text-align:${val};}");
        map.put("placeholderFontFamily", "${prefix} input::-webkit-input-placeholder{font-family:${val};}");
        map.put("placeholderFontWeight", "${prefix} input::-webkit-input-placeholder{font-weight:${val};}");
        map.put("placeholderFontStyle", "${prefix} input::-webkit-input-placeholder{font-style:${val};}");
        map.put("placeholderTextDecoration", "${prefix} input::-webkit-input-placeholder{text-decoration:${val};}");
        map.put("placeholderLineHeight", "${prefix} input::-webkit-input-placeholder{line-height:${val};}");
        map.put("placeholderLetterSpacing", "${prefix} input::-webkit-input-placeholder{letter-spacing:${val};}");
        map.put("letterSpacing", "${prefix} input:not(:placeholder-shown){letter-spacing:${val};}");
        map.put("textAlign", "${prefix} input:not(:placeholder-shown){text-align:${val};}");
        map.put("fontFamily", "${prefix} input:not(:placeholder-shown){font-family:${val};} ");
        map.put("fontSize", "${prefix} input:not(:placeholder-shown){font-size:${val};}");
        map.put("color", "${prefix} input:not(:placeholder-shown){color:${val};}");
        map.put("fontWeight", "${prefix} input:not(:placeholder-shown){font-weight:${val};} ");
        map.put("fontStyle", "${prefix} input:not(:placeholder-shown){font-style:${val};}");
        map.put("textDecoration", "${prefix} input:not(:placeholder-shown){text-decoration:${val};}");
        map.put("borderTop", "${prefix} input{border-top:${val};}");
        map.put("borderRight", "${prefix} input{border-right:${val};}");
        map.put("borderBottom", "${prefix} input{border-bottom:${val};}");
        map.put("borderLeft", "${prefix} input{border-left:${val};}");
        map.put("borderRadius", "${prefix} ,${prefix} input{border-radius:${val};}");
        map.put("inputPadding", "${prefix} input{padding-right:${val};}");
        map.put("errorFontColor", "${prefix}:after{color:${val};position:absolute;left:0;bottom:-18px;font-size:12px;}");
        map.put("checkBadMsgColor", "${prefix}:after{color:${val};}");
        map.put("showPassword", "${prefix} .el-input__inner::-ms-reveal{display:${val}}");
        map.put("hoverBorderRadius", "${prefix} ,${prefix} input:read-only{border-radius:${val};}");
        map.put("iconSuccess", "${prefix} .el-input__suffix .el-icon-success{display:${val}}");
        map.put("iconSuccessChange", "${prefix} .el-input__suffix .el-icon-success:before{content:${val};color: #F2634F;}");
        map.put("searchIcon", "${prefix} .el-input__prefix .el-icon-search{display:${val};}");
        map.put("searchIconAlign", "${prefix} .el-input__prefix .el-icon-search{justify-content:${val};align-items:${val};}");
        map.put("clearIconColor", "${prefix} .el-input__suffix .el-icon-circle-close{color:${val};}");
        map.put("lengthLimitIconColor", "${prefix} .el-input__suffix .el-input__count-inner{color:${val};}");
        map.put("hidePasswordIconColor", "${prefix} .el-input__suffix .el-icon-view{color:${val};}");
        map.put("searchIconColor", "${prefix} .el-input__prefix .el-icon-search{color:${val};}");
        map.put("caretColor", "${prefix} .el-input__inner{caret-color:${val};}");
        map.put("clearIcon", "${prefix} .el-input__suffix{right:${val};}");
        return map;
    }

    public static HKInput newComponent(JSONObject jsonObject) {
        HKInput input = (HKInput)((Object)ClassAdapter.jsonObjectToBean((JSONObject)jsonObject, (String)HKInput.class.getName()));
        EventPreHandler.dealDisabled((LcdpComponent)input);
        Map type = input.getInteractions();
        DefaultStyle checkBad = (DefaultStyle)type.get("checkBad");
        if (ToolUtil.isNotEmpty((Object)checkBad) && ToolUtil.isNotEmpty((Object)checkBad.getInnerStyles())) {
            Object color = checkBad.getInnerStyles().get("errorFontColor");
            if (ToolUtil.isNotEmpty(color)) {
                input.getInnerStyles().put("checkBadMsgColor", color);
                input.getInnerStyles().put("iconSuccessChange", "\\E79D");
            }
            input.getInnerStyles().put("iconSuccess", "inline-block");
        } else {
            input.getInnerStyles().put("iconSuccess", "inline-block");
            input.getInnerStyles().put("iconSuccessChange", "\\E79C");
        }
        Object backgroundImg = input.getInnerStyles().get("backgroundImageBack");
        Object selectType = input.getProps().get("select");
        if (ToolUtil.isNotEmpty(selectType) && "number".equals((String)selectType)) {
            input.getInnerStyles().put("clearIcon", "15px");
        }
        input.getInnerStyles().remove("backgroundImageBack");
        input.getInnerStyles().put("backgroundImage", backgroundImg);
        Optional<Map> inputProps = Optional.of(input).map(LcdpComponent::getProps);
        boolean isMaxlength = inputProps.map(maxlength -> maxlength.get("maxlength")).map(getMaxlength -> (Integer)getMaxlength != 0).orElse(false);
        boolean isShowWordLimit = (Boolean)inputProps.map(showWordLimit -> showWordLimit.get("showWordLimit")).orElse(false);
        boolean isSelect = inputProps.map(select -> select.get("select")).map(getSelect -> getSelect.equals("text")).orElse(false);
        if (isMaxlength && isShowWordLimit && isSelect) {
            input.getInnerStyles().put("inputPadding", "47px");
        } else {
            input.getInnerStyles().put("inputPadding", "0px");
        }
        input.getInnerStyles().put("showPassword", "none");
        input.getInnerStyles().put("iconSuccess", "none");
        return input;
    }
}

