<el-tabs v-model="${instanceKey!}Active" type="${type!}" tab-position="${tabPosition!}":stretch="${stretch?c}">
    <#list tabs! as tab >
        <el-tab-pane name="${tab.slotName}" :disabled="${instanceKey!}TabTabItemDisabled['${tab.slotName}']" <#if refresh?? && refresh!>:key="`<#noparse>$</#noparse>{${instanceKey!}Active}${tab.slotName}`"<#else>key="${tab.slotName}"</#if> <#if tab.lazy?? && tab.lazy!>:lazy="true"</#if>>
            <el-tooltip
                    :content="${instanceKey!}${tab.slotName}"
                    placement="${tabPosition!}"
                    :enterable="false"
                    slot="label"
                    :disabled="${instanceKey!}TabTooltipDisabled['${tab.slotName}']"
                    effect="dark">
                <div @mouseenter="${instanceKey!}TabTooltipHid('${instanceKey!}${tab.slotName}LabelSpan', '${tab.slotName}')">
                    <span ref="${instanceKey!}${tab.slotName}LabelSpan"><#if tab.iconClassName?? && tab.iconClassName != ""><i class="tabIcon ${tab.iconClassName!}"></i></#if>{{${instanceKey!}${tab.slotName}}}</span>
                </div>
            </el-tooltip>
            <#if  (!tab.url?? && !tab.outLink??) || (tab.url = "" && tab.outLink = "")>
                <#list slotCodes?keys as key>
                    <#assign slotVue=slotCodes[key]>
                    <#if key=tab.slotName>
                         <#list scrolls! as scroll >
                             <#if scroll.slotName = tab.slotName>
                                 <div style="width: ${scroll.scrollWidth};height: ${scroll.scrollHeight};" class="tabContainer">
                                     ${slotVue}
                                 </div>
                             </#if>
                         </#list>
                    </#if>
                </#list>
            <#else>
                <#if tab.outLink?? && tab.outLink != "">
                    <iframe src="${tab.outLink}" class="iframe"></iframe>
                <#elseif tab.pageName?? && tab.pageName !="">
                    <#list scrolls! as scroll >
                        <#if scroll.slotName = tab.slotName>
                            <div style="width: ${scroll.scrollWidth};height: ${scroll.scrollHeight};" class="tabContainer">
                                ${tab.pageName}
                            </div>
                        </#if>
                    </#list>
                <#--                    ${tab.pageName}-->
                </#if>
            </#if>
        </el-tab-pane>
    </#list>
</el-tabs>
